package org.phoenix.util;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.*;

public class sorterHeaderRenderer extends DefaultTableCellRenderer {
	TableSorter t;
	public sorterHeaderRenderer(TableSorter t) {
		this.t = t;
	}
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
		Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
		try {
			JLabel label = (JLabel) c;
			Border b1 = new BevelBorder(BevelBorder.RAISED);
			Border b2 = new BevelBorder(BevelBorder.LOWERED);
			label.setBorder(new CompoundBorder(b2, b1));
			if (table.convertColumnIndexToModel(column) == t.getSortedColumn()) {
				if (t.isDescending()) {
					label.setIcon(new ImageIcon(getClass().getResource("resources/down.gif")));
				} else {
					label.setIcon(new ImageIcon(getClass().getResource("resources/up.gif")));
				}
			} else {
				label.setIcon(null);
			}
		} catch (ClassCastException e) {
		}	
		return c;
	}
}
