
#include "stdafx.h"
#include "SerialRedirect.h"

#include "NetworkPorts.h"
#include "SerialPorts.h"
#include "PortServer.h"








CSerialPort::CSerialPort( class CPortServer *port )
{
	m_IsCommPortOpen	= FALSE;
	m_hComm	= NULL;

	m_port = port;
	m_curRcvBlock = m_curXmitBlock = NULL;
}



CSerialPort::~CSerialPort()
{
	if( m_IsCommPortOpen ) prtCloseCommPort();
}








BOOL	CSerialPort::prtOpenCommPort( CString pname, int pbaud, int pparity, int pdbits, int pstop, int opts )
{
	BOOL			fSuccess, rval = FALSE;
	DCB				dcb;
	COMMTIMEOUTS	ctime;

	if( m_IsCommPortOpen ) return TRUE;

	if( (m_hComm = CreateFile( (LPCTSTR)pname,
								GENERIC_READ | GENERIC_WRITE, 
								0, 
								NULL, 
								OPEN_EXISTING,
								0,
								NULL )) ==  INVALID_HANDLE_VALUE )
	{
		m_hComm = NULL;
		return FALSE;
	}

	m_opts = opts;




	memset( &dcb,0,sizeof(DCB));

	dcb.DCBlength	=	sizeof(DCB);
	dcb.BaudRate	=	pbaud;
	dcb.fBinary		=	TRUE;

	if( pparity != NOPARITY )
		dcb.fParity	= TRUE;
	else
		dcb.fParity	= FALSE;

	dcb.fOutxCtsFlow = ( m_opts & COPT_CTSFLOW )? TRUE : FALSE;
	dcb.fOutxDsrFlow = ( m_opts & COPT_DSRFLOW )? TRUE : FALSE;
	dcb.fDtrControl	 = ( m_opts & COPT_ASSERTDTR )? DTR_CONTROL_ENABLE : DTR_CONTROL_DISABLE;
	dcb.fDsrSensitivity = FALSE;

	dcb.fTXContinueOnXoff	= FALSE;
	dcb.fOutX				= FALSE;
	dcb.fInX				= FALSE;

	dcb.fErrorChar = 0;
	dcb.fNull = FALSE;

	if( m_opts & COPT_RTSON )
		dcb.fRtsControl = RTS_CONTROL_ENABLE;
	else if( m_opts & COPT_RTSFLOW )
		dcb.fRtsControl = RTS_CONTROL_TOGGLE;
	else
		dcb.fRtsControl = RTS_CONTROL_DISABLE;

	dcb.fAbortOnError = FALSE;
	dcb.XonLim = dcb.XoffLim = 0;
	dcb.XonChar = dcb.XoffChar = 0;
	dcb.EofChar = dcb.EvtChar = 0;

	dcb.ErrorChar = 0;

	dcb.ByteSize	= pdbits;
	dcb.Parity		= pparity;
	dcb.StopBits	= pstop;

	if( !(fSuccess= SetCommState( m_hComm, &dcb )) )
	{
		CloseHandle( m_hComm );
		return FALSE;
	}




	ctime.ReadIntervalTimeout			= 0;
	ctime.ReadTotalTimeoutMultiplier	= 0;
	ctime.ReadTotalTimeoutConstant		= 5;
	ctime.WriteTotalTimeoutMultiplier	= 0;
	ctime.WriteTotalTimeoutConstant		= 0;

	if( !(fSuccess= SetCommTimeouts( m_hComm, &ctime )) )
	{
		CloseHandle( m_hComm );
		return FALSE;
	}






	if( m_opts & COPT_CTSFLOW )
		m_dwEvtMask = EV_CTS | EV_TXEMPTY;
	else
		m_dwEvtMask = EV_TXEMPTY;

	if( !(fSuccess = SetCommMask( m_hComm, m_dwEvtMask )) )
	{
		CloseHandle( m_hComm );
		return FALSE;
	}

//	m_overlapped.hEvent = CreateEvent(	NULL,	/* no security attributes */
//										FALSE,	/* auto reset event */
//										FALSE,	/* not signaled */
//										NULL	/* no name */
//									);
//	ASSERT( m_overlapped.hEvent );


	m_IsCommPortOpen = TRUE;
	return TRUE;
}









void	CSerialPort::prtCloseCommPort(void)
{
	if( m_IsCommPortOpen )
	{
		CloseHandle( m_hComm );
	}
	if( m_curRcvBlock ) theApp.dblkRelease( m_curRcvBlock );
	if( m_curXmitBlock ) theApp.dblkRelease( m_curXmitBlock );

	m_curRcvBlock = m_curXmitBlock = NULL;

	m_IsCommPortOpen = FALSE;
	return;
}









void	CSerialPort::prtServiceCommPort(void)
{
	DWORD	dwNumBytes,dwBytes2Process;

	if( m_IsCommPortOpen )
	{
		if( !m_curRcvBlock ) m_curRcvBlock = theApp.dblkAlloc();

		dwBytes2Process = min( m_curRcvBlock->blkLeft() , SERIAL_IO_BLOCKSIZE );

		ReadFile( m_hComm, (LPVOID)&m_curRcvBlock->blkData[ m_curRcvBlock->blkLen ], dwBytes2Process, &dwNumBytes, NULL );

		if( dwNumBytes > 0 )
		{
			m_port->isTranceiving = TRUE;

			//
			// start the ageing timer if this block is empty
			//
			if( m_curRcvBlock->blkLen==0 ) m_curRcvBlock->blkStartTimer();

			m_curRcvBlock->blkLen += dwNumBytes;

			//
			// if this block is filled beyond the fill threshold, commit it
			//
			if( m_curRcvBlock->blkLeft() < DATABLOCK_FILLTHRESHOLD )
			{
				m_port->m_listNetTransmit.AddTail( m_curRcvBlock );
				m_curRcvBlock = NULL;
			}
		}
		if( m_curRcvBlock )
		{
			//
			// commit a partially filled block if the max age is exceeded
			//
			if( m_curRcvBlock->blkAge() > DATABLOCK_MAXAGE )
			{
				m_port->m_listNetTransmit.AddTail( m_curRcvBlock );
				m_curRcvBlock = NULL;
			}
		}



		if( !m_curXmitBlock ) 
		{
			//
			// load the next outbound block if we're not already working on one
			//
			if( m_port->m_listNetReceive.GetCount() > 0 )
			{
				m_curXmitBlock = (CDataBlock *)m_port->m_listNetReceive.RemoveHead();
			}
		}
		if( m_curXmitBlock )
		{
			m_port->isTranceiving = TRUE;

			dwBytes2Process = min( (m_curXmitBlock->blkLen - m_curXmitBlock->blkSent), SERIAL_IO_BLOCKSIZE );

			WriteFile( m_hComm, (LPVOID)&m_curXmitBlock->blkData[ m_curXmitBlock->blkSent ], dwBytes2Process, &dwNumBytes, NULL );

			m_curXmitBlock->blkSent += dwNumBytes;

			if( m_curXmitBlock->blkSent == m_curXmitBlock->blkLen )
			{
				theApp.dblkRelease( m_curXmitBlock );
				m_curXmitBlock = NULL;
			}
		}
	}
}


// eof
