VERSION 4.00
Begin VB.Form frmMain 
   Caption         =   "aiNet DLL & VB40 32 bit; Example #1"
   ClientHeight    =   6324
   ClientLeft      =   1068
   ClientTop       =   1536
   ClientWidth     =   9024
   BeginProperty Font 
      name            =   "MS Sans Serif"
      charset         =   1
      weight          =   700
      size            =   7.8
      underline       =   0   'False
      italic          =   0   'False
      strikethrough   =   0   'False
   EndProperty
   Height          =   6708
   Icon            =   "T1VB432.frx":0000
   Left            =   1020
   LinkTopic       =   "Form1"
   ScaleHeight     =   6324
   ScaleWidth      =   9024
   Top             =   1200
   Width           =   9120
   Begin VB.PictureBox Picture1 
      BorderStyle     =   0  'None
      Height          =   1452
      Left            =   120
      Picture         =   "T1VB432.frx":030A
      ScaleHeight     =   1452
      ScaleWidth      =   7692
      TabIndex        =   3
      Top             =   120
      Width           =   7692
   End
   Begin VB.TextBox tOut 
      BorderStyle     =   0  'None
      BeginProperty Font 
         name            =   "Courier New"
         charset         =   1
         weight          =   400
         size            =   8.4
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      Height          =   4572
      Left            =   120
      MultiLine       =   -1  'True
      ReadOnly        =   -1  'True
      TabIndex        =   2
      Top             =   1680
      Width           =   7332
   End
   Begin VB.CommandButton btnExit 
      Caption         =   "E&xit"
      Height          =   375
      Left            =   7680
      TabIndex        =   1
      Top             =   2400
      Width           =   1215
   End
   Begin VB.CommandButton btnStart 
      Caption         =   "&Start"
      Height          =   375
      Left            =   7680
      TabIndex        =   0
      Top             =   1920
      Width           =   1215
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_Creatable = False
Attribute VB_Exposed = False

Private Sub btnExit_Click()
   End

End Sub

Private Sub btnStart_Click()
'--------------------------------------------------------------------------'
'                                                                          '
'    (C) Copyright 1996 by:  aiNet                                         '
'                            Trubarjeva 42                                 '
'                            SI-3000 Celje                                 '
'                            Europe, Slovenia                              '
'     All Rights Reserved                                                  '
'                                                                          '
'     Subject: Visual Basic code for single vector prediction.             '
'        File: T1VB432 - The XOR problem created by XOR.CSV file            '
'       EMAIL: AINET@IKPIR.FAGG.UNI-LJ.SI                                  '
'                                                                         '
' Last revision: October 17 1996                                          '
'                                                                          '
'--------------------------------------------------------------------------'

'---------------------------------------------------------------------------
'   Here it will be shown how we can colve the XOR problem using
'   aiNet C functions
'
'   The XOR problem:
'   ================
'      Number of model vectors: 4
'          Number of variables: 3
'    Number of input variables: 3
'       Any discrete variables: NONE
'
'      Model vectors:  Inp,Inp,Out
'              row 1:  1,  1,  0
'              row 2:  1,  0,  1
'              row 3:  0,  1,  1
'              row 4:  0,  0,  0
'
'   Test vectors (vectors which will be used in prediction) together with
'   penalty coefficient and penalty method.
'
'       Prediction vectors:  Inp  Inp  Out
'                    prd 1:  0.9  0.1  ??
'                    prd 2:  0.1  0.9  ??
'                    prd 3:  0.2  0.2  ??
'                    prd 4:  0.7  0.7  ??
'
'       Penalty coeffcient: 0.3
'       Penalty methods: STATIC
'
'   NOTE: Selected penalty coefficients are in no case optimal.
'         They were selected randomly, to perform a few tests.
'         The test results were compared with the results calculated by
'         the main aiNet 1.22 application.
'
'   ------------------------------------------------------------------------
'   Results (rounded at fourth decimal):
'   ------------------------------------------------------------------------
'
'       Penalty cefficient: 0.3
'       Penalty method:     STATIC
'                                      (RESULT)
'       Prediction vectors:  Inp  Inp  (  Out )
'                    prd 1:  0.9  0.1  (1.0000)
'                    prd 2:  0.1  0.9  (1.0000)
'                    prd 3:  0.2  0.2  (0.0007)
'                    prd 4:  0.7  0.7  (0.0096)
'
'   ------------------------------------------------------------------------

Dim i As Long
Dim ret As Long                ' dummy for return values
      
   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Support for text output
   '
   Dim CRNL As String             ' Carriage return + newline
   Dim T As String                ' tab
   Dim TT As String               ' 2 x tab
   CRNL = Chr(13) + Chr(10)
   T = Chr(9)
   TT = Chr(9) + Chr(9)
   
   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Vectors to be predicted
   '
   ReDim predict(0 To 11) As Single
   predict(0) = 0.9: predict(1) = 0.1: predict(2) = 999
   predict(3) = 0.1: predict(4) = 0.9: predict(5) = 999
   predict(6) = 0.2: predict(7) = 0.2: predict(8) = 999
   predict(9) = 0.7: predict(10) = 0.7: predict(11) = 999
   
   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Title
   '
   version = aiGetVersion()
   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' If you are in debug mode and you can not pass the line
   ' above, copy ainet32.dll into Windows\System directory
   '
   major = Int(version / 100)
   minor = version Mod 100
   tOut = "aiNetDLL version " + CStr(major) + "." + CStr(minor)
   tOut = tOut + " (C) Copyright by aiNet, 1996" + CRNL

   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Register DLL
   '
   ret = aiRegistration("Your registration name", "Your code")

   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Setup the model - read the csv file.
   '
   Dim model As Long    ' works like a pointer to aiModel structure
   
   ' In some occasions next line produces en error because of an invalid
   ' path. In this case edit this line and change the path to correct one

   model = aiCreateModelFromCSVFile("c:\cpp\ainet\dll\vb4\32bit\xor.csv")
'   model = aiCreateModelFromCSVFile("c:\ainet\dll\vb4\32bit\xor.csv")
   If model = 0 Then
      tOut = tOut + CRNL + "Error: Something went wrong during model creation!"
      tOut = tOut + CRNL + "Please, see the source code - the file path is probably invalid!"
      tOut = tOut + CRNL + "Specifying the correct path will put the problem away."
      GoTo End_Sub
   End If

   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Output the model
   '
   nVec = aiGetNumberOfModelVectors(model)
   nVar = aiGetNumberOfVariables(model)
   ReDim flag(3) As Long
   flag(1) = aiGetDiscreteFlag(model, 1)
   flag(2) = aiGetDiscreteFlag(model, 2)
   flag(3) = aiGetDiscreteFlag(model, 3)
   tOut = tOut + CRNL + "             Model name: aiNet DLL test 1 (XOR.CSV)"
   tOut = tOut + CRNL + "Number of model vectors: " + CStr(nVec)
   tOut = tOut + CRNL + "    Number of variables: " + CStr(nVar)
   tOut = tOut + CRNL + "         Variable names: A,   B,   A xor B"
   tOut = tOut + CRNL + "          Discrete flag: "
   tOut = tOut + CStr(flag(1)) + "    " + CStr(flag(2)) + "    " + CStr(flag(3))
   ReDim var(3) As Single
   Dim value As Single
   For i = 1 To aiGetNumberOfModelVectors(model) Step 1
      ret = aiGetVariableVB(model, i, 1, value): var(1) = value
      ret = aiGetVariableVB(model, i, 2, value): var(2) = value
      ret = aiGetVariableVB(model, i, 3, value): var(3) = value
      tOut = tOut + CRNL + T + Str(var(1))
      tOut = tOut + TT + Str(var(2))
      tOut = tOut + TT + Str(var(3))
   Next i

   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Normalize the model
   '
   ret = aiNormalize(model, NORMALIZE_REGULAR)

   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Prediction: Pen. coefficient = 0.30, Pen. method = STATIC
   ' This test has static penalty coefficient 0.30
   '
   tOut = tOut + CRNL + CRNL + "   Penalty coefficient : 0.30"
   tOut = tOut + CRNL + "         Penalty method: STATIC"
   tOut = tOut + CRNL + CRNL + T + "A(inp)" + TT + "B(inp)" + TT + "A xor B(out)"
   ReDim pre(3) As Single
   For i = 0 To 3 Step 1
      ret = aiPrediction(model, predict(i * 3), 0.3, PENALTY_STATIC)
      pre(1) = predict(i * 3 + 0)
      pre(2) = predict(i * 3 + 1)
      pre(3) = predict(i * 3 + 2)
      ' If the output is not what it should be, you may try to change
      ' the formating argument in Format$ functions below or ...
      tOut = tOut + CRNL + T + CStr(Format$(pre(1), "0.0"))
      tOut = tOut + TT + CStr(Format$(pre(2), "0.0"))
      tOut = tOut + TT + CStr(Format$(pre(3), "0.0000"))
      ' ... simply comment out lines below and comment lines above however,
      ' the output will not look very nice.
      ' The Format$ function is locale depended - depends on the settings in
      ' your computer (Control Panel)
      ' tOut = tOut + CRNL + T + Str(pre(1))
      ' tOut = tOut + TT + Str(pre(2))
      ' tOut = tOut + TT + Str(pre(3))
   Next

   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Denormalize the model (in this case it is not necessary)
   '
   ret = aiDenormalize(model)
   
   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' We must call the aiDeleteModel function here since the
   ' model was allocated dynamicaly using the
   ' aiCreateModelFromCSVFile function.
   '
   ret = aiDeleteModel(model)

   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' End
   '
   tOut = tOut + CRNL + CRNL + "End."

End_Sub:

End Sub

