VERSION 4.00
Begin VB.Form frmMain 
   BorderStyle     =   3  'Fixed Double
   Caption         =   "aiNet DLL & VB40 32 bit; Example #2"
   ClientHeight    =   6420
   ClientLeft      =   1056
   ClientTop       =   1488
   ClientWidth     =   9000
   BeginProperty Font 
      name            =   "MS Sans Serif"
      charset         =   1
      weight          =   700
      size            =   7.8
      underline       =   0   'False
      italic          =   0   'False
      strikethrough   =   0   'False
   EndProperty
   Height          =   6804
   Icon            =   "t2vb432.frx":0000
   Left            =   1008
   LinkTopic       =   "Form1"
   ScaleHeight     =   6420
   ScaleWidth      =   9000
   Top             =   1152
   Width           =   9096
   Begin VB.PictureBox Picture1 
      AutoSize        =   -1  'True
      Height          =   1308
      Left            =   120
      Picture         =   "t2vb432.frx":030A
      ScaleHeight     =   1284
      ScaleWidth      =   7224
      TabIndex        =   3
      Top             =   120
      Width           =   7248
   End
   Begin VB.TextBox tOut 
      BorderStyle     =   0  'None
      BeginProperty Font 
         name            =   "Courier New"
         charset         =   1
         weight          =   400
         size            =   8.4
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      Height          =   4692
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   2
      Top             =   1560
      Width           =   7332
   End
   Begin VB.CommandButton btnExit 
      Caption         =   "E&xit"
      Height          =   375
      Left            =   7620
      TabIndex        =   1
      Top             =   2400
      Width           =   1215
   End
   Begin VB.CommandButton btnStart 
      Caption         =   "&Start"
      Height          =   375
      Left            =   7620
      TabIndex        =   0
      Top             =   1920
      Width           =   1215
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_Creatable = False
Attribute VB_Exposed = False

Private Sub btnExit_Click()
   End

End Sub

Private Sub btnStart_Click()
'------------------------------------------------------------------------ '
'                                                                         '
'    (C) Copyright 1996 by:  aiNet                                        '
'                            Trubarjeva 42                                '
'                            SI-3000 Celje                                '
'                            Europe, Slovenia                             '
'     All Rights Reserved                                                 '
'                                                                         '
'     Subject: Visual Basic code for single vector prediction.            '
'        File: T2VB432 - The XOR problem with dynamic model creation      '
'       EMAIL: AINET@IKPIR.FAGG.UNI-LJ.SI                                 '
'                                                                         '
' Last revision: October 17 1996                                          '
'                                                                         '
'-------------------------------------------------------------------------'

'--------------------------------------------------------------------------
'   Here it will be shown how we can solve the XOR problem using
'   aiNet C functions.
'
'   The XOR problem:
'   ================
'      Number of model vectors: 4
'          Number of variables: 3
'    Number of input variables: 3
'       Any discrete variables: NONE
'
'      Model vectors:  Inp,Inp,Out
'              row 1:  1,  1,  0
'              row 2:  1,  0,  1
'              row 3:  0,  1,  1
'              row 4:  0,  0,  0
'
'   Test vectors (vectors which will be used in prediction) together with
'   penalty coefficient and penalty method.
'
'       Prediction vectors:  Inp  Inp  Out
'                    prd 1:  0.9  0.1  ??
'                    prd 2:  0.1  0.9  ??
'                    prd 3:  0.2  0.2  ??
'                    prd 4:  0.7  0.7  ??
'
'       Penalty coeffcient: 1.5
'       Penalty methods:    NEAREST
'
'   NOTE: Selected penalty coefficients are in no case optimal.
'         They were selected randomly, to perform a few tests.
'         The test results were compared with the results calculated by
'         the main aiNet 1.22 application.
'
'   -----------------------------------------------------------------------
'   Results (rounded at fourth decimal):
'   -----------------------------------------------------------------------
'
'       Penalty cefficient: 1.5
'       Penalty method:     NEAREST N.
'                                      (RESULT)
'       Prediction vectors:  Inp Inp(Out)
'                    prd 1:  0.9  0.1  (0.9989)
'                    prd 2:  0.1  0.9  (0.9989)
'                    prd 3:  0.2  0.2  (0.1054)
'                    prd 4:  0.7  0.7  (0.3449)
'
'   -----------------------------------------------------------------------

Dim i As Long
Dim ret As Long                ' dummy for return values

   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Support for text output
   '
   Dim CRNL As String             ' Carriage return + newline
   Dim T As String                ' tab
   Dim TT As String               ' 2 x tab
   CRNL = Chr(13) + Chr(10)
   T = Chr(9)
   TT = Chr(9) + Chr(9)

   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Vectors to be predicted
   '
   ReDim predict(0 To 11) As Single
   predict(0) = 0.9: predict(1) = 0.1: predict(2) = 999
   predict(3) = 0.1: predict(4) = 0.9: predict(5) = 999
   predict(6) = 0.2: predict(7) = 0.2: predict(8) = 999
   predict(9) = 0.7: predict(10) = 0.7: predict(11) = 999
   
   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Model variable
   '
   Dim model As Long              ' works like a pointer to aiModel structure
   model = 0

   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Title
   '
   ' If Visual Basic fails here saying: can not load DLL ...
   ' copy AINET32.DLL and AINET16.DLL to Windows\System directory!
   
   version = aiGetVersion()
   major = Int(version / 100)
   minor = version Mod 100
   tOut = "aiNetDLL version " + CStr(major) + "." + CStr(minor)
   tOut = tOut + " (C) Copyright by aiNet, 1996" + CRNL
   
   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Register DLL
   '
   ret = aiRegistration("Your registration name", "Your code")

   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Allocate the model variable and necessary memory
   '
   ' 4 model vectors
   ' 3 variables
   ' 2 input variables
   ' 1 output variable: 3-2=1 (calculated by aiCreateModel)
   '
   model = aiCreateModel(4, 3, 2)
   If model = 0 Then
      tOut = tOut + CRNL + "Error: Something went wrong during model creation!"
      GoTo End_Sub
   End If

   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Loading data into the model using aiSetVariable function
   '
   ret = aiSetVariable(model, 1, 1, 1#) ' first model vector
   ret = aiSetVariable(model, 1, 2, 1#) ' 1 xor 1 = 0
   ret = aiSetVariable(model, 1, 3, 0#)

   ret = aiSetVariable(model, 2, 1, 1#) ' second model vector
   ret = aiSetVariable(model, 2, 2, 0#) '1 xor 0 = 1
   ret = aiSetVariable(model, 2, 3, 1#)

   ret = aiSetVariable(model, 3, 1, 0#) ' third model vector
   ret = aiSetVariable(model, 3, 2, 1#) ' 0 xor 1 = 1
   ret = aiSetVariable(model, 3, 3, 1#)

   ret = aiSetVariable(model, 4, 1, 0#) ' fourth model vector
   ret = aiSetVariable(model, 4, 2, 0#) ' 0 xor 0 = 0
   ret = aiSetVariable(model, 4, 3, 0#)

   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Output the model
   '
   nVec = aiGetNumberOfModelVectors(model)
   nVar = aiGetNumberOfVariables(model)
   ReDim flag(3) As Long
   flag(1) = aiGetDiscreteFlag(model, 1)
   flag(2) = aiGetDiscreteFlag(model, 2)
   flag(3) = aiGetDiscreteFlag(model, 3)
   tOut = tOut + CRNL + "             Model name: aiNet DLL test 2 (aiCreateModel)"
   tOut = tOut + CRNL + "Number of model vectors: " + CStr(nVec)
   tOut = tOut + CRNL + "    Number of variables: " + CStr(nVar)
   tOut = tOut + CRNL + "         Variable names: A,   B,   A xor B"
   tOut = tOut + CRNL + "          Discrete flag: "
   tOut = tOut + CStr(flag(1)) + "    " + CStr(flag(2)) + "    " + CStr(flag(3))
   ReDim var(3) As Single
   Dim value As Single
   For i = 1 To aiGetNumberOfModelVectors(model) Step 1
      ret = aiGetVariableVB(model, i, 1, value): var(1) = value
      ret = aiGetVariableVB(model, i, 2, value): var(2) = value
      ret = aiGetVariableVB(model, i, 3, value): var(3) = value
      tOut = tOut + CRNL + T + Str(var(1))
      tOut = tOut + TT + Str(var(2))
      tOut = tOut + TT + Str(var(3))
   Next i

   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Normalize the model
   '
   ret = aiNormalize(model, NORMALIZE_REGULAR)

   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Prediction
   ' This test has nearest neighbour penalty coefficient 1.50
   '
   tOut = tOut + CRNL + CRNL + "   Penalty coefficient : 1.50"
   tOut = tOut + CRNL + "         Penalty method: NEAREST N."
   tOut = tOut + CRNL + CRNL + T + "A(inp)" + TT + "B(inp)" + TT + "A xor B(out)"
   ReDim pre(3) As Single
   For i = 0 To 3 Step 1
      ret = aiPrediction(model, predict(i * 3), 1.5, PENALTY_NEAREST)
      pre(1) = predict(i * 3 + 0)
      pre(2) = predict(i * 3 + 1)
      pre(3) = predict(i * 3 + 2)
      ' If the output is not what it should be, you may try to change
      ' the formating argument in Format$ functions below or ...
      tOut = tOut + CRNL + T + CStr(Format$(pre(1), "0.0"))
      tOut = tOut + TT + CStr(Format$(pre(2), "0.0"))
      tOut = tOut + TT + CStr(Format$(pre(3), "0.0000"))
      ' ... simply comment out lines below and comment lines above however,
      ' the output will not look very nice.
      ' The Format$ function is locale depended - depends on the
      ' settings in your computer (Control Panel)
      ' tOut = tOut + CRNL + T + Str(pre(1))
      ' tOut = tOut + TT + Str(pre(2))
      ' tOut = tOut + TT + Str(pre(3))
   Next
   
   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' Denormalize the model (in this case it is not necessary)
   '
   ret = aiDenormalize(model)
   
   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' We must call the aiDeleteModel function here since the
   ' model was allocated dynamicaly using the aiCreateModel
   ' function.
   '
   ret = aiDeleteModel(model)

   '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
   ' End
   '
   tOut = tOut + CRNL + CRNL + "End."

End_Sub:

End Sub

