unit dpfrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, powerprn, Mask, WinSpool, ExtCtrls, Printers;

type
  TPowerPrinterForm = class(TForm)
    Button1: TButton;
    PageControl1: TPageControl;
    btnAbout: TButton;
    Label1: TLabel;
    DefaultPrinter: TEdit;
    Label2: TLabel;
    DefaultDriver: TEdit;
    Label3: TLabel;
    DefaultPort: TEdit;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Label4: TLabel;
    st_orientation: TLabel;
    Button3: TButton;
    Button4: TButton;
    lbPrnList: TListBox;
    Button5: TButton;
    Label5: TLabel;
    btnUnlock: TButton;
    Label6: TLabel;
    Label7: TLabel;
    eUserName: TEdit;
    eKey: TMaskEdit;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    lb_bins: TListBox;
    btnGetBinList: TButton;
    btnSetBin: TButton;
    btnGetBin: TButton;
    lb_papersize: TListBox;
    btnGetPaperSizeList: TButton;
    btnGetPaperSize: TButton;
    bntSetPaperSize: TButton;
    rbDefault: TRadioButton;
    rbNamed: TRadioButton;
    TabSheet5: TTabSheet;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Button2: TButton;
    TabSheet6: TTabSheet;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    btnErrorCode: TButton;
    btnErrorMessage: TButton;
    TabSheet7: TTabSheet;
    Label16: TLabel;
    Label17: TLabel;
    Button6: TButton;
    Button7: TButton;
    emServerName: TEdit;
    emPrinterName: TEdit;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    TabSheet8: TTabSheet;
    Label21: TLabel;
    Label22: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    emSetPrnName: TEdit;
    emSetPortName: TEdit;
    emSetDriverName: TEdit;
    emSetPrintProcessor: TEdit;
    btnAddPrinter: TButton;
    btnDelPrinter: TButton;
    TabSheet9: TTabSheet;
    TabSheet10: TTabSheet;
    emSetServerName: TEdit;
    Label28: TLabel;
    Label23: TLabel;
    Label27: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    emDrvPrinterName: TEdit;
    emDrvEnvironment: TEdit;
    emDrvDataFile: TEdit;
    emDrvConfigFile: TEdit;
    emDrvVersion: TEdit;
    emDrvServer: TEdit;
    btnDrvAdd: TButton;
    btnDrvDel: TButton;
    Label33: TLabel;
    emDrvDriverPath: TEdit;
    Label34: TLabel;
    tabEnumDrivers: TTabSheet;
    lbDrivers: TListBox;
    btnEnumDrivers: TButton;
    Button8: TButton;
    emGetPrnDrvPrinterName: TEdit;
    Button9: TButton;
    cbPrinterAccess: TComboBox;
    btnSetAccessRight: TButton;
    Label35: TLabel;
    btnGetOrientation: TButton;
    lbJobs: TListBox;
    btnEnumJobs: TButton;
    emPrinterEnumJob: TEdit;
    tabCapture: TTabSheet;
    EnumPrinterFonts: TTabSheet;
    lbPrinterFonts: TListBox;
    Label26: TLabel;
    btnGetPrinterFonts: TButton;
    Label36: TLabel;
    btnTestSetFont: TButton;
    GroupBox1: TGroupBox;
    btncaptureWindow: TButton;
    btnWindow: TRadioButton;
    btnClientArea: TRadioButton;
    GroupBox2: TGroupBox;
    btnCaptureDesktop: TButton;
    GroupBox3: TGroupBox;
    btnPrintDesktop: TButton;
    btnBestFit: TRadioButton;
    btnStretch: TRadioButton;
    Label37: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure lbPrnListDblClick(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure btnUnlockClick(Sender: TObject);
    procedure btnGetPaperSizeListClick(Sender: TObject);
    procedure btnGetBinListClick(Sender: TObject);
    procedure btnGetBinClick(Sender: TObject);
    procedure rbDefaultClick(Sender: TObject);
    procedure rbNamedClick(Sender: TObject);
    procedure btnSetBinClick(Sender: TObject);
    procedure btnGetPaperSizeClick(Sender: TObject);
    procedure bntSetPaperSizeClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button2Click(Sender: TObject);
    procedure btnErrorCodeClick(Sender: TObject);
    procedure btnErrorMessageClick(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure btnAddPrinterClick(Sender: TObject);
    procedure btnDelPrinterClick(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure btnEnumDriversClick(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure btnGetOrientationClick(Sender: TObject);
    procedure btnSetAccessRightClick(Sender: TObject);
    procedure btnDrvAddClick(Sender: TObject);
    procedure btnDrvDelClick(Sender: TObject);
    procedure btnEnumJobsClick(Sender: TObject);
    procedure btnCaptureDesktopClick(Sender: TObject);
    procedure btnPrintDesktopClick(Sender: TObject);
    procedure btnGetPrinterFontsClick(Sender: TObject);
    procedure btnSetFontClick(Sender: TObject);
    procedure btnTestSetFontClick(Sender: TObject);
    procedure btncaptureWindowClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PowerPrinterForm: TPowerPrinterForm;

implementation

{$R *.DFM}

procedure TPowerPrinterForm.Button1Click(Sender: TObject);
begin
     Close;
end;

procedure TPowerPrinterForm.FormCreate(Sender: TObject);
begin
      CreatePowerPrinter;
      DefaultPrinter.Text := GetDefPrinterName;
      DefaultPort.Text    := GetDefPrinterPort;
      DefaultDriver.Text  := GetDefPrinterDriver;
      st_Orientation.Caption := GetPrinterOrientationString;

      // new for v1.1. Supply printer name
      emGetPrnDrvPrinterName.text := DefaultPrinter.Text;
      emPrinterEnumJob.text := DefaultPrinter.text;

      // New for v1.1 printer access (NT ONLY)
      cbPrinterAccess.Items.AddObject('PRINTER_ALL_ACCESS', nil);
      cbPrinterAccess.Items.AddObject('PRINTER_ACCESS_USE', nil);
      cbPrinterAccess.Items.AddObject('PRINTER_READ', nil);
      cbPrinterAccess.Items.AddObject('PRINTER_WRITE', nil);
      cbPrinterAccess.Items.AddObject('PRINTER_EXECUTE', nil);

      Application.HelpFile := 'powerprn.hlp';
end;

procedure TPowerPrinterForm.Button3Click(Sender: TObject);
var
 lRet:LOngInt;
begin
     lRet := SetPrinterOrientation (DMORIENT_LANDSCAPE);

     if (lRet > 0) then
        st_Orientation.Caption := GetPrinterOrientationString
     else
         ShowMessage('SetPrinterOrientation failed. Error Code: ' + IntToStr(lRet) + ' Go to the Errors TAB Page and check the extended error code and message.');
end;

procedure TPowerPrinterForm.Button4Click(Sender: TObject);
var
   lRet :LongInt;
begin
     lRet := SetPrinterOrientation (DMORIENT_PORTRAIT);
     if (lRet > 0 ) then
        st_Orientation.Caption := GetPrinterOrientationString
     else
         ShowMessage('SetPrinterOrientation failed. Error Code: ' + IntToStr(lRet) + ' Go to the Errors TAB Page and check the extended error code and message.');
end;

procedure TPowerPrinterForm.Button5Click(Sender: TObject);
var
   pPrnList, pName:string;
   i, iPos:smallint;
begin
     lbPrnList.Clear();
     pPrnList := GetPrinterList;
     iPos := Pos(';', pPrnList);
     while (iPos > 0 ) do
     begin
          pName := copy(pPrnList, 1, iPos -1);
          lbPrnList.Items.AddObject(pName, nil);
          pPrnLIst := copy(pPrnList, iPos +1, Length(pPrnList) - iPos);
          iPos := Pos(';', pPrnList);
     end;
end;

procedure TPowerPrinterForm.lbPrnListDblClick(Sender: TObject);
var
   PrnName:string;
begin
     PrnName := lbPrnList.Items[lbPrnList.ItemIndex];

     SetDefaultPrinter (PrnName);

      DefaultPrinter.Text := GetDefPrinterName;
      DefaultPort.Text    := GetDefPrinterPort;
      DefaultDriver.Text  := GetDefPrinterDriver;
      st_Orientation.Caption := GetPrinterOrientationString;

end;

procedure TPowerPrinterForm.btnAboutClick(Sender: TObject);
begin
     About;
end;

procedure TPowerPrinterForm.btnUnlockClick(Sender: TObject);
var
   lKey, lCode :longint;
   button:integer;
begin
     Val(trim(eKey.text), lKey, lCode);
     if Unlock (eUserName.text, lKey) = 1 then
        button := application.MessageBox('Valid KEY. The registration reminder will not be shown when PowerPrinter gets unloaded.', 'PowerPrinter', MB_OK);

end;

procedure TPowerPrinterForm.btnGetPaperSizeListClick(Sender: TObject);
var
   sPaperSizeList, sPaperSizeName:string;
   iPos:integer;
begin

     sPaperSizeList := GetPaperSizeList();
     iPos := pos(';', sPaperSizeList);
     lb_papersize.Clear();
     while (iPos > 0) do
     begin
          sPaperSizeName := copy(sPaperSizeList, 1, iPos -1);
          lb_PaperSize.Items.AddObject(sPaperSizeName, nil);
          sPaperSizeList := copy(sPaperSizeList, iPos +1, Length(sPaperSizeList) - iPos);
          iPos := Pos(';', sPaperSizeList);
     end;
end;


procedure TPowerPrinterForm.btnGetBinListClick(Sender: TObject);
var
   sBinList, sBinName:string;
   iPos:integer;
begin

     if rbDefault.checked = TRUE then
        sBinList := GetPaperBinList()
     else
         sBinList := GetNamedPaperBinList();

     lb_Bins.Clear();

     iPos := pos(';', sBinList);
     while (iPos > 0) do
     begin
          sBinName := copy(sBinList, 1, iPos -1);
          lb_Bins.Items.AddObject(sBinName, nil);
          sBinLIst := copy(sBinList, iPos +1, Length(sBinList) - iPos);
          iPos := Pos(';', sBinList);
     end;
end;

procedure TPowerPrinterForm.btnGetBinClick(Sender: TObject);
var
   iBin:SmallInt;
   lRet :LongInt;
   Button:integer;
   pMsg : array [0..200] of Char;
   sMsg : string;
begin
     lRet := GetDefaultSource(iBin);

     if lRet > 0 then
     begin
        sMsg := 'Default Paper Source :' + IntToStr(iBin);
        strPCopy(pMsg, sMsg);
     end
     else
        strPCopy(pMsg, 'Could not fetch default paper source');

     Button := Application.MessageBox(pMsg, 'PowerPrinter', mb_OK);
end;

procedure TPowerPrinterForm.rbDefaultClick(Sender: TObject);
begin
     btnSetBin.enabled := TRUE;
     btnGetBinListClick(rbDefault);
end;

procedure TPowerPrinterForm.rbNamedClick(Sender: TObject);
begin
     btnSetBin.enabled := FALSE;
     btnGetBinListClick(rbNamed);
end;

procedure TPowerPrinterForm.btnSetBinClick(Sender: TObject);
var
   BinName : string;
   BinIndex : SmallInt;
   button :integer;
begin
     if lb_Bins.ItemIndex >= 0 then
     begin
          BinName := lb_Bins.Items[lb_Bins.ItemIndex];
          BinIndex := StrToInt(copy(BinName, 1, pos(' ', BinName) -1));
          if SetDefaultSource (BinIndex) > 0 then
             button := application.MessageBox('Set default Source succeeded', 'PowerPrinter', MB_OK)
          else
             button := application.MessageBox('Set default Source failed', 'PowerPrinter', MB_OK);
     end
     else
         button := application.MessageBox('No Paper Bin to choose from !', 'PowerPrinter', MB_OK);
end;

procedure TPowerPrinterForm.btnGetPaperSizeClick(Sender: TObject);
var
   iSize:SmallInt;
   lRet :LongInt;
   Button:integer;
   pMsg : array [0..200] of Char;
   sMsg : string;
begin
     lRet := GetPaperSize(iSize);

     if lRet > 0 then
     begin
        sMsg := 'Default Paper Size :' + IntToStr(iSize);
        strPCopy(pMsg, sMsg);
     end
     else
        strPCopy(pMsg, 'Could not fetch default paper size. Is your printer online ?');

     Button := Application.MessageBox(pMsg, 'PowerPrinter', mb_OK);
end;


procedure TPowerPrinterForm.bntSetPaperSizeClick(Sender: TObject);
var
   SizeName : string;
   SizeIndex : SmallInt;
   button :integer;
begin
     if lb_papersize.ItemIndex >= 0 then
     begin
          SizeName := lb_papersize.Items[lb_papersize.ItemIndex];
          SizeIndex := StrToInt(copy(SizeName, 1, pos(' ', SizeName) -1));
          if SetPaperSize (SizeIndex) > 0 then
             button := application.MessageBox('Set Paper Size succeeded', 'PowerPrinter', MB_OK)
          else
             button := application.MessageBox('Set Paper Size failed', 'PowerPrinter', MB_OK);
     end
     else
         button := application.MessageBox('No Paper Size to choose from !', 'PowerPrinter', MB_OK);
end;


procedure TPowerPrinterForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
     DestroyPowerPrinter;
end;

procedure TPowerPrinterForm.Button2Click(Sender: TObject);
begin
     application.HelpContext(1); 
end;

procedure TPowerPrinterForm.btnErrorCodeClick(Sender: TObject);
var
   lErrCode :LongInt;
   button:integer;
   pMsg : array [0..200] of Char;
   sMsg : string;
begin

     lErrCode := GetExtendedErrorCode;

     sMsg := 'Extended Error Code is ' + IntToStr(lErrCode);

     strPCopy(pMsg, sMsg);

     button := application.MessageBox(pMsg, 'PowerPrinter Error Managment APIs', MB_OK)
end;

procedure TPowerPrinterForm.btnErrorMessageClick(Sender: TObject);
var
   sMsg : string;
   pMsg : array [0..200] of Char;
   button : integer;
begin

     sMsg := GetExtendedErrorMessage;
     strPCopy(pMsg, sMsg);
     button := application.MessageBox(pMsg, 'PowerPrinter Error Managment APIs', MB_OK);

end;

procedure TPowerPrinterForm.Button6Click(Sender: TObject);
var
   lRet :LongInt;
begin
     if (length(emServerName.text) = 0) OR (length(emPrinterName.text) = 0) then
        ShowMessage('Please supply both Server Name and Printer Name')
     else
     begin
          lRet := AddAPrinterConnection(emServerName.text, emPrinterName.text);

          if lRet <> 1 then
             btnErrorMessageClick(Button6)
          else
              ShowMessage('Printer Successfully Connected !')
      end;
end;

procedure TPowerPrinterForm.Button7Click(Sender: TObject);
var
   lRet :LongInt;
begin
     if (length(emServerName.text) = 0) OR (length(emPrinterName.text) = 0) then
        ShowMessage('Please supply both Server Name and Printer Name')
     else
     begin
          lRet := DeleteAPrinterConnection(emServerName.text, emPrinterName.text);

          if lRet <> 1 then
             btnErrorMessageClick(Button6)
          else
              ShowMessage('Printer Successfully Deleted !')
      end;

end;

procedure TPowerPrinterForm.btnAddPrinterClick(Sender: TObject);
var
   lRet :longint;
begin

     lRet := AddAPrinter (emSetServerName.text,
                        emSetPrnName.text,
                        emSetPortName.text,
                        emSetDriverName.text,
                        emSetPrintProcessor.text);

     // remember that Windows 95 does not use Server Name !
     if lRet = -1 then
        ShowMessage('Bad argument given. Please refer to help file for additional details.')
     else if lRet < 1 then
          btnErrorMessageClick(Button6)
     else
        ShowMessage('Printer Successfully Added !')


end;

procedure TPowerPrinterForm.btnDelPrinterClick(Sender: TObject);
var
   lRet :longint;
begin
     lRet := DeleteAPrinter (emSetPrnName.text);
     if lRet <> 1 then
        btnErrorMessageClick(Button6)
     else
         ShowMessage('Printer Successfully Deleted !')

end;

procedure TPowerPrinterForm.Button8Click(Sender: TObject);
var
   PrnName, sMsg, sItem:string;
   DriverInfo:TDriverInfo2A;
   lRet:LongInt;
begin
     DriverInfo.pName        := StrAlloc(100);
     DriverInfo.pEnvironment := StrAlloc(100);
     DriverInfo.pDriverPath  := StrAlloc(100);
     DriverInfo.pDataFile    := StrAlloc(100);
     DriverInfo.pConfigFile  := StrAlloc(100);

     PrnName := emGetPrnDrvPrinterName.text;
     lRet := GetAPrinterDriver(PrnName, @DriverInfo);

     if lRet = 1 then
     begin
          lbDrivers.Clear();

          sItem := 'Printer Driver Name: ';
          sItem := sItem + DriverInfo.pName;
          lbDrivers.Items.AddObject(sItem, nil);

          sItem := ' Version: ';
          sItem := sItem + IntToStr(DriverInfo.cVersion);
          lbDrivers.Items.AddObject(sItem, nil);

          sItem := ' Environment: ';
          sItem := sItem + DriverInfo.pEnvironment;
          lbDrivers.Items.AddObject(sItem, nil);

          sItem := ' Driver Path: ';
          sItem := sItem + DriverInfo.pDriverPath;
          lbDrivers.Items.AddObject(sItem, nil);

          sItem := ' Data File: ';
          sItem := sItem + DriverInfo.pDataFile;
          lbDrivers.Items.AddObject(sItem, nil);

          sItem := ' Config File: ';
          sItem := sItem + DriverInfo.pConfigFile;
          lbDrivers.Items.AddObject(sItem, nil);


     end
     else // what's wrong ?
          sMsg := 'Extended Error Code is ' + IntToStr(lRet);

     StrDispose(DriverInfo.pName);
     StrDispose(DriverInfo.pEnvironment);
     StrDispose(DriverInfo.pDriverPath);
     StrDispose(DriverInfo.pDataFile);
     StrDispose(DriverInfo.pConfigFile);

end;

procedure TPowerPrinterForm.btnEnumDriversClick(Sender: TObject);
var
   sMsg, sItem:string;
   DriverInfo: array [1..10] of TDriverInfo2A;
   lRet, i:LongInt;
   iActualOnes:SmallInt;
begin

     // initialize
     for I := 1 to 10 do
     begin
         DriverInfo[i].pName         := StrAlloc (100);
         DriverInfo[i].pEnvironment  := StrAlloc(100);
         DriverInfo[i].pDriverPath   := StrAlloc(100);
         DriverInfo[i].pDataFile     := StrAlloc(100);
         DriverInfo[i].pConfigFile   := StrAlloc(100);
     end;

     lRet := GetPrinterDrivers(@DriverInfo, 10, iActualOnes);

     if lRet = 1 then
     begin
          lbDrivers.Clear();

          for i := 1 to iActualOnes do
          begin
               sItem := 'Printer Driver Name: ';
               sItem := sItem + DriverInfo[i].pName;
               lbDrivers.Items.AddObject(sItem, nil);

               sItem := ' Version: ';
               sItem := sItem + IntToStr(DriverInfo[i].cVersion);
               lbDrivers.Items.AddObject(sItem, nil);

               sItem := ' Environment: ';
               sItem := sItem + DriverInfo[i].pEnvironment;
               lbDrivers.Items.AddObject(sItem, nil);

               sItem := ' Driver Path: ';
               sItem := sItem + DriverInfo[i].pDriverPath;
               lbDrivers.Items.AddObject(sItem, nil);

               sItem := ' Data File: ';
               sItem := sItem + DriverInfo[i].pDataFile;
               lbDrivers.Items.AddObject(sItem, nil);

               sItem := ' Config File: ';
               sItem := sItem + DriverInfo[i].pConfigFile;
               lbDrivers.Items.AddObject(sItem, nil);
           end;
     end
     else // what's wrong ?
          sMsg := 'Extended Error Code is ' + IntToStr(lRet);

// Free memory
for i := 1 to 10 do
begin
    StrDispose(DriverInfo[i].pName);
    StrDispose(DriverInfo[i].pEnvironment);
    StrDispose(DriverInfo[i].pDriverPath);
    StrDispose(DriverInfo[i].pDataFile);
    StrDispose(DriverInfo[i].pConfigFile);
end;

end;
procedure TPowerPrinterForm.Button9Click(Sender: TObject);
var
   PrnName:string;
   DriverInfo:TDriverInfo2A;
   lRet:LongInt;
begin
     DriverInfo.pName        := StrAlloc(100);
     DriverInfo.pEnvironment := StrAlloc(100);
     DriverInfo.pDriverPath  := StrAlloc(100);
     DriverInfo.pDataFile    := StrAlloc(100);
     DriverInfo.pConfigFile  := StrAlloc(100);

     PrnName := emGetPrnDrvPrinterName.text;
     lRet := GetAPrinterDriver(PrnName, @DriverInfo);

     if lRet = 1 then
     begin
          emDrvPrinterName.text   := DriverInfo.pName;
          emdrvVersion.text       := IntToStr(DriverInfo.cVersion);
          emDrvEnvironment.text   := DriverInfo.pEnvironment;
          emDrvDriverPath.text    := DriverInfo.pDriverPath;
          emDrvDataFile.text      := DriverInfo.pDataFile;
          emDrvConfigFile.text    := DriverInfo.pConfigFile;
     end;

     StrDispose(DriverInfo.pName);
     StrDispose(DriverInfo.pEnvironment);
     StrDispose(DriverInfo.pDriverPath);
     StrDispose(DriverInfo.pDataFile);
     StrDispose(DriverInfo.pConfigFile);

end;

procedure TPowerPrinterForm.btnGetOrientationClick(Sender: TObject);
begin
     st_Orientation.Caption := GetPrinterOrientationString;
end;

procedure TPowerPrinterForm.btnSetAccessRightClick(Sender: TObject);
var
   lRet:LongInt;
   lAccess:LOngInt;
   sAccess:String;
begin
     sAccess := cbPrinterAccess.Text;

     if (sAccess = 'PRINTER_ALL_ACCESS') then
        lAccess := PRINTER_ALL_ACCESS
     else if (sAccess = 'PRINTER_ACCESS_USE') then
        lAccess := PRINTER_ACCESS_USE
     else if (sAccess = 'PRINTER_READ') then
          lAccess := PRINTER_READ
     else if (sAccess = 'PRINTER_WRITE') then
          lAccess := PRINTER_WRITE
     else if (sAccess = 'PRINTER_EXECUTE') then
          lAccess := PRINTER_EXECUTE
     else
         lAccess := PRINTER_ALL_ACCESS;

     lRet := SetPrinterAccess (lAccess);

end;

procedure TPowerPrinterForm.btnDrvAddClick(Sender: TObject);
var
   lRet :LongInt;
   lKey, lCode :longint;
begin
     val(trim(emDrvVersion.Text), lCode, lKey);

     lRet := AddAPrinterDriver(emDrvServer.text,
                                emDrvPrinterName.text,
                                emDrvEnvironment.text,
                                emDrvDriverPath.Text,
                                emDrvDataFile.Text,
                                emDrvConfigFile.Text,
                                lCode);

    if (lRet <=0) then
       ShowMessage('AddPrinterDriver failed. Error Code: ' + IntToStr(lRet) + ' Go to the Errors TAB Page and check the extended error code and message.');
end;

procedure TPowerPrinterForm.btnDrvDelClick(Sender: TObject);
var
   lRet:LOngInt;
begin
     lRet := DeleteAPrinterDriver (emDrvServer.text,
                                   emDrvEnvironment.Text,
                                   emDrvPrinterName.Text);

     if (lRet <=0) then
        ShowMessage('DeletePrinterDriver failed. Error Code: ' + IntToStr(lRet) + ' Go to the Errors TAB Page and check the extended error code and message.');
end;


procedure TPowerPrinterForm.btnEnumJobsClick(Sender: TObject);
var
   sMsg, sItem:string;
   JobInfo: array [1..10] of TJobInfo1A;
   lRet, lJobs, i:LongInt;
begin

     // initialize
     for I := 1 to 10 do
     begin
         JobInfo[i].pPrinterName        := StrAlloc (200);
         JobInfo[i].pMachineName        := StrAlloc(200);
         JobInfo[i].pUserName           := StrAlloc(200);
         JobInfo[i].pDocument           := StrAlloc(200);
         JobInfo[i].pDataType           := StrAlloc(200);
         JobInfo[i].pStatus             := StrAlloc(200);
     end;

     lRet := EnumPrinterJobs(emPrinterEnumJob.text, 10, @JobInfo, lJobs);

     if (lRet >= 0) then
     begin
          lbJobs.Clear();

          if (lJobs = 0) then // printer queue is empty
             ShowMessage('No print Jobs found in the printer queue of ' + emPrinterEnumJob.text);

          for i := 1 to lJobs do
          begin
               sItem := 'Printer Name: ';
               sItem := sItem + JobInfo[i].pPrinterName;
               lbJobs.Items.AddObject(sItem, nil);

               sItem := 'Machine Name: ';
               sItem := sItem + JobInfo[i].pMachineName;
               lbJobs.Items.AddObject(sItem, nil);

               sItem := 'User Name: ';
               sItem := sItem + JobInfo[i].pUserName;
               lbJobs.Items.AddObject(sItem, nil);

               sItem := 'Document: ';
               sItem := sItem + JobInfo[i].pDocument;
               lbJobs.Items.AddObject(sItem, nil);

               sItem := 'Data Type: ';
               sItem := sItem + JobInfo[i].pDatatype;
               lbJobs.Items.AddObject(sItem, nil);

               sItem := 'Status: ';
               sItem := sItem + JobInfo[i].pStatus;
               lbJobs.Items.AddObject(sItem, nil);

               sItem := 'Status: ';
               sItem := sItem + IntToStr(JobInfo[i].Status);
               lbJobs.Items.AddObject(sItem, nil);

               sItem := 'Priority: ';
               sItem := sItem + IntToStr(JobInfo[i].Priority);
               lbJobs.Items.AddObject(sItem, nil);

               sItem := 'Position: ';
               sItem := sItem + IntToStr(JobInfo[i].Position);
               lbJobs.Items.AddObject(sItem, nil);

               sItem := 'Total Pages: ';
               sItem := sItem + IntToStr(JobInfo[i].TotalPages);
               lbJobs.Items.AddObject(sItem, nil);

               sItem := 'Pages Printer: ';
               sItem := sItem + IntToStr(JobInfo[i].PagesPrinted);
               lbJobs.Items.AddObject(sItem, nil);

           end;
     end
     else // what's wrong ?
          ShowMessage('EnumPrinterJobs failed. ErrorCode : ' + IntToStr(lRet)+ ' Go to the Errors TAB Page and check the extended error code and message.');
// Free memory
// AAARG: BUG BUG For some reason I am not able to free memory
{
for i := 1 to 10 do
begin
     StrDispose(JobInfo[i].pPrinterName);
     StrDispose(JobInfo[i].pMachineName);
     StrDispose(JobInfo[i].pUserName);
     StrDispose(JobInfo[i].pDocument);
     StrDispose(JobInfo[i].pDataType);
     StrDispose(JobInfo[i].pStatus);
end;
}

end;
procedure TPowerPrinterForm.btnCaptureDesktopClick(Sender: TObject);
var
   lRet:longint;
begin
    lRet := CaptureDesktop;

    if lRet < 1  then
       ShowMessage('CaptureDesktop failed !. See Errors page for more details. (Is PowerDIB.DLL there ?)')
    else
        ShowMessage('Desktop image successfully captured !');

end;

procedure TPowerPrinterForm.btnPrintDesktopClick(Sender: TObject);
var
   lRet:longint;
   iOption:LongInt;
begin
     { 120 STrecth to Page
       119 Best fit
     }

     if btnBestFit.Checked = TRUE then
        iOption := 119
     else
         iOption := 120;

     lRet := PrintTheDIB(iOption, 'Job NAME');

     if lRet < 1  then
       ShowMessage('PrintTheDIB failed !. See Errors page for more details. (Is PowerDIB.DLL there ?)')
     else
         ShowMessage('PrintTheDIB ok. Job sent to default printer...');
end;

procedure TPowerPrinterForm.btnGetPrinterFontsClick(Sender: TObject);
var
   prnFonts, FontName:String;
   iPos:integer;
begin

     ShowMessage('This API returns ALL fonts (True type, raster, and vector). We will shortly indtroduce new APIs that will allow you to distinguish between font types.');
     prnFonts := EnumPrnFonts;
     iPos := pos(';', prnFonts);
     lbPrinterFonts.Clear();
     while (iPos > 0) do
     begin
          FontName := copy(prnFonts, 1, iPos -1);
          lbPrinterFonts.Items.AddObject(FontName, nil);
          prnFonts := copy(prnFonts, iPos +1, Length(prnFonts) - iPos);
          iPos := Pos(';', prnFonts);

     end;
end;

procedure TPowerPrinterForm.btnSetFontClick(Sender: TObject);
var
   fontName:string;
   lRet:LongInt;
   handleDC:HDC;
   iPoint, iBold, iItalic, iUnderline, iStrike:integer;
begin
     // get font name
     ShowMessage('This test does not really do anything interesting because SetPrinterFont should be called AFTER BeginDoc. Try the test for something a bit more interesting.');

     if lbPrinterFonts.ItemIndex > 0 then
     begin
        fontName := lbPrinterFonts.Items[lbPrinterFonts.ItemIndex];
        iPoint     := 15; // still working on it !
        iBold      := 0; // 0 = normal, 1 = bold
        iItalic    := 0; // 0 = normal, 1 = italic
        iUnderline := 0; // 0 = normal, 1 = underlined
        iStrike    := 0; // 0 = normal, 1 = striketrough
        lRet := SetPrinterFont(Printer.Canvas.Handle, fontName, iPoint, iBold, iItalic, iUnderline, iStrike);
        if lRet < 1 then
           ShowMessage('dwSetPrinterFont failed !')
     end
     else
         ShowMessage('Please select one...');
end;

procedure TPowerPrinterForm.btnTestSetFontClick(Sender: TObject);
var
   fontName:string;
   lRet:LongInt;
   handleDC:HDC;
   iPoint, iBold, iItalic, iUnderline, iStrike:integer;
begin
     ShowMessage('The SetPrinterFont is not yet complete because the WIDTH attribute is hardcoded !. I am looking for good algorithm to convert the POINT argument (1/72 of an inch) to width and height. Can anybody help ?');

     // get font name
     if lbPrinterFonts.ItemIndex > 0 then
     begin
        fontName := lbPrinterFonts.Items[lbPrinterFonts.ItemIndex];
        iPoint     := 15; // still working on it !
        iBold      := 0; // 0 = normal, 1 = bold
        iItalic    := 0; // 0 = normal, 1 = italic
        iUnderline := 0; // 0 = normal, 1 = underlined
        iStrike    := 0; // 0 = normal, 1 = striketrough

        Printer.BeginDoc;
        lRet := SetPrinterFont(Printer.Canvas.Handle, fontName, iPoint, iBold, iItalic, iUnderline, iStrike);
        Printer.Canvas.TextOut (100, 100, 'Printing on :' + Printer.Printers [Printer.PrinterIndex]);
        Printer.EndDoc;

        if lRet < 1 then
            ShowMessage('dwSetPrinterFont failed !')
        end;

end;

procedure TPowerPrinterForm.btncaptureWindowClick(Sender: TObject);
var
   lRet:LongInt;
   iOption:Integer;
begin
     if btnWindow.Checked = TRUE then
        iOption := 1     // Capture entire window
     else
         iOption := 2;    // capture client area only

     lRet := CaptureWindow ( PowerPrinterForm.handle, iOption);
    if lRet < 1  then
       ShowMessage('CaptureWindow failed !. See Errors page for more details. (Is PowerDIB.DLL there ?)')
    else
        ShowMessage('Window image successfully captured !');

end;

end.

