unit powerprn;

// PowerPrinter interface module
// The purpose of this module is to simplify the use of PowerPrinter DLL.
// Use it as you wish
// Visit us at http://www.digitalw.com to get the latest version

interface

Uses WinSpool;

// Check out the help file: all APIs are documented there
// PowerPrinter APIs are prefixed with dw

// Constructore/destructor. PowerPrinter is written in C++ !
function CWin32Prn_CPP_CONSTRUCTOR : longint; stdcall; external 'powerprn.dll';
Procedure CWin32Prn_CPP_DESTRUCTOR (hdl:Longint) ; stdcall; external 'powerprn.dll';

// Default printer APIs
function dwGetDefaultPrinterName (hdl:LongInt; pPrnName:pChar):longint; stdcall; external 'powerprn.dll';
function dwGetDefaultPrinterPort (hdl:LongInt; pPrnPort:pChar):longint; stdcall; external 'powerprn.dll';
function dwGetDefaultPrinterDriver (hdl:LongInt; pPrnDriver:pChar):longint; stdcall; external 'powerprn.dll';
function dwGetPrinterList (hdl:LongInt; szPrtr:pChar):longint; stdcall; external 'powerprn.dll'
function dwSetDefaultPrinter (hdl:LongInt; szPrinterName:pChar):longint; stdcall; external 'powerprn.dll'
function dwGetDefaultPrinterEx (hdl:LongInt; szPrinterName, szPrinterDriver, szPrinterPort:pChar):longint; stdcall; external 'powerprn.dll'
function dwSetDefaultPrinterEx (hdl:LongInt; const szPrinterName, szPrinterDriver, szPrinterPort:pChar):longint; stdcall; external 'powerprn.dll'

// short orientation
function dwGetPrinterOrientation(hdl:LongInt; var iOrient:SmallInt):longint; stdcall; external 'powerprn.dll';
function dwSetPrinterOrientation(hdl:LongInt; iOrient:SmallInt):longint; stdcall; external 'powerprn.dll';

// short paper size
function dwGetPaperSize(hdl:longint; var iPaperSize:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetPaperSize(hdl:longint; iPaperSize:smallint) :longint; stdcall; external 'powerprn.dll'

// short paper Length
function dwGetPaperLength(hdl:longint; var iPaperLength:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetPaperLength(hdl:longint; iPaperLength:smallint) :longint; stdcall; external 'powerprn.dll'

// short paper Width
function dwGetPaperWidth(hdl:longint; var iPaperWidth:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetPaperWidth(hdl:longint; iPaperWidth:smallint) :longint; stdcall; external 'powerprn.dll'

// Scale
function dwGetScale(hdl:longint; var iScale:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetScale(hdl:longint; iScale:smallint) :longint; stdcall; external 'powerprn.dll'

// Copies
function dwGetCopies(hdl:longint; var iCopies:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetCopies(hdl:longint; iCopies:smallint) :longint; stdcall; external 'powerprn.dll'

// Default Source
function dwGetDefaultSource(hdl:longint; var iSource:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetDefaultSource(hdl:longint; iSource:smallint) :longint; stdcall; external 'powerprn.dll'

// short  dmPrintQuality
function dwGetPrintQuality(hdl:longint; var iPrintQuality:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetPrintQuality(hdl:longint; iPrintQuality:smallint) :longint; stdcall; external 'powerprn.dll'

// Color
function dwGetColor(hdl:longint; var iColor:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetColor(hdl:longint; iColor:smallint) :longint; stdcall; external 'powerprn.dll'

// Duplex
function dwGetDuplex(hdl:longint; var iDuplex:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetDuplex(hdl:longint; iDuplex:smallint) :longint; stdcall; external 'powerprn.dll'

// YResolution
function dwGetYResolution(hdl:longint; var iYResolution:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetYResolution(hdl:longint; iYResolution:smallint) :longint; stdcall; external 'powerprn.dll'

// TTOption
function dwGetTTOption(hdl:longint; var iTTOption:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetTTOption(hdl:longint; iTTOption:smallint) :longint; stdcall; external 'powerprn.dll'

// Collate
function dwGetCollate(hdl:longint; var iCollate:smallint) :longint; stdcall; external 'powerprn.dll'
function dwSetCollate(hdl:longint; iCollate:smallint) :longint; stdcall; external 'powerprn.dll'

Procedure dwAbout ; stdcall; external 'powerprn.dll';
function dwUnlock (sregUser:pChar; lKey:LOngInt): longint; stdcall; external 'powerprn.dll'

Function dwGetPaperBinList (hdl:LongInt; szPaperList:pChar): longint; stdcall; external 'powerprn.dll'
Function dwGetNamedPaperBinList (hdl:LongInt; szPaperList:pChar) : longint; stdcall; external 'powerprn.dll'
Function dwGetSupportedPaperSizeList (hdl:LongInt; szPaperSizeList:pChar) : longint; stdcall; external 'powerprn.dll'

// v1.1 APIs

// Extended error code as defined in the SDK
function dwGetExtendedErrorCode(hdl:LongInt) : LongInt; stdcall; external 'powerprn.dll'
procedure dwGetExtendedErrorMessage(hdl:LongInt; szErrorMessage:pChar) ; stdcall; external 'powerprn.dll'

// NT ONLY ! (for Network printer only). Drivers will be downloaded from SERVER
function dwAddPrinterConnection (hdl:LongInt; szServerName, szPrnShareName:string) :longint; stdcall; external 'powerprn.dll'
function dwDeletePrinterConnection (hdl:LongInt; szServerName,szPrnShareName:string) :longint; stdcall; external 'powerprn.dll'

// Add Delete local & network printers
function dwAddPrinter (hdl:LongInt; szServerName, szPrinterName, szPortName, szDriverName, szPrintProcessor:string) :longint; stdcall; external 'powerprn.dll'
function dwDeletePrinter (hdl:LongInt; szPrinterName:string) :longint; stdcall; external 'powerprn.dll'

// Add Delete printer driver. Files must already be present
function dwAddPrinterDriver (hdl:LongInt; szServerName, szPrinterName, szEnvironment, szDriverPath, szDataFile, szConfigFile:string; dVersion:longint) :longint; stdcall; external 'powerprn.dll'
function dwDeletePrinterDriver (hdl:LongInt; szServerName, szEnvironment, szDriverName:string) :longint; stdcall; external 'powerprn.dll'

// Get printer driver according to printer name
function dwGetPrinterDriver(hdl:longint; szPrinterName:string; DriverInfo:pDriverInfo2):longint; stdcall; external 'powerprn.dll'

// Enumerate all printer drivers installed
function dwGetPrinterDrivers(hdl:longint; DriverInfo:pDriverInfo2; iMax:LongInt;var iActualOnes:smallint):longint; stdcall; external 'powerprn.dll'

// Printer Access
function dwSetPrinterAccess(hdl:longint; PrinterAccess:longint):longint; stdcall; external 'powerprn.dll'
function dwGetPrinterAccess(hdl:longint):longint; stdcall; external 'powerprn.dll'

// Printer Job.
function dwEnumPrinterJobs(hdl:longint; szPrinterName:String; iMaxJobs:LongInt; JobInfo:pJobInfo1; var Jobs:LongInt):longint; stdcall; external 'powerprn.dll'

// Printer Fonts
function dwEnumPrinterFonts(hdl:longint; szFontList:pChar):longint; stdcall; external 'powerprn.dll'
function dwSetPrinterFont(hdl:longint; pDC:LongInt; szFontList:String; iPoint, iBold, iItalic, iUnderline, iStrike:integer):longint; stdcall; external 'powerprn.dll'

// v1.1 BONUS !

// Capture desktop
function dwCaptureDesktop(hdl:longint):longint; stdcall; external 'powerprn.dll'

// Capture Window given its handle
function dwCaptureWindow(hdl, hWin:longint;iOption:integer):longint; stdcall; external 'powerprn.dll'

// print captured window
function dwPrintTheDIB(hdl:longint; iOptions:LongInt; szPrinterName:String):longint; stdcall; external 'powerprn.dll'


// Delphi functions
procedure CreatePowerPrinter;
procedure DestroyPowerPrinter;
procedure About;
function Unlock (RegUser:string; lKey:LongInt): longint;
function GetDefPrinterName : string;
function GetDefPrinterPort : string;
function GetDefPrinterDriver : string;
function GetPrinterOrientationString : string;
function SetPrinterOrientation (iOrient : SmallInt) : LongInt;
function SetPaperSize (iSize : SmallInt) : LongInt;
function GetPaperSize (var iSize : SmallInt) : longint;
function SetDefaultSource (iSource : SmallInt) : LongInt;
function GetDefaultSource (var iSource : SmallInt) : longint;
function GetPrinterList : string;
procedure SetDefaultPrinter (pName:string);
function GetPaperBinList: string;
function GetNamedPaperBinList: string;
function GetPaperSizeList: string ;

// paper Length
function GetPaperLength(var iPaperLength:smallint) :longint;
function SetPaperLength(iPaperLength:smallint) :longint;

// paper Width
function GetPaperWidth(var iPaperWidth:smallint) :longint;
function SetPaperWidth(iPaperWidth:smallint) :longint;

// Scale
function GetScale(var iScale:smallint) :longint;
function SetScale(iScale:smallint) :longint;

// Copies
function GetCopies(var iCopies:smallint) :longint;
function SetCopies(iCopies:smallint) :longint;

// dmPrintQuality
function GetPrintQuality(var iPrintQuality:smallint) :longint;
function SetPrintQuality(iPrintQuality:smallint) :longint;

// Color
function GetColor(var iColor:smallint) :longint;
function SetColor(iColor:smallint) :longint;

// Duplex
function GetDuplex(var iDuplex:smallint) :longint;
function SetDuplex(iDuplex:smallint) :longint;

// YResolution
function GetYResolution(var iYResolution:smallint) :longint;
function SetYResolution(iYResolution:smallint) :longint;

// TTOption
function GetTTOption(var iTTOption:smallint) :longint;
function SetTTOption(iTTOption:smallint) :longint;

// Collate
function GetCollate(var iCollate:smallint) :longint;
function SetCollate(iCollate:smallint) :longint;

// new for v1.1
function GetExtendedErrorCode : LongInt;
function GetExtendedErrorMessage :string ;

function AddAPrinterConnection (szServerName, szPrnShareName:string) :longint;
function DeleteAPrinterConnection (szServerName, szPrnShareName:string) :longint;

function AddAPrinter (szServerName, szPrinterName, szPortName, szDriverName, szPrintProcessor:string) :longint;
function DeleteAPrinter (szPrinterName:string) :longint;

function AddAPrinterDriver (szServerName, szPrinterName, szEnvironment, szDriverPath, szDataFile, szConfigFile:string; dVersion:longint) :longint;
function DeleteAPrinterDriver (szServerName, szEnvironment, szDriverName:string) :longint;

function GetAPrinterDriver(szPrinterName:string;DriverInfo:pDriverInfo2) : LongInt;
function GetPrinterDrivers(DriverInfo:pDriverInfo2; iMax:LOngInt; var iActualOnes:smallint) : LongInt;

function SetPrinterAccess(PrinterAccess:longint):longint;
function GetPrinterAccess:longint;

function EnumPrinterJobs(szPrinterName:String; iMaxJobs:LongInt; JobInfo:pJobInfo1; var Jobs:LOngInt):longint;

// Fonts
function EnumPrnFonts:string;
function SetPrinterFont(pDC:LongInt; fontName:string; iPoint, iBold, iItalic, iUnderline, iStrike:integer):LongInt;

// Capture desktop
function CaptureDesktop:longint;
function CaptureWindow (hWin:LongInt; iOption:Integer) : LongInt;

// print captured window
function PrintTheDIB(iOptions:LongInt; szJobName:String):longint;

Var
   hdl:longint;         { Class instance handle }
   Ret:LOngInt;         {return value}
implementation

uses
  Windows, Messages, SysUtils, Forms;

procedure CreatePowerPrinter;
begin
     // create PowerPrinter class
     hdl := CWin32Prn_CPP_CONSTRUCTOR ();
end;

procedure DestroyPowerPrinter;
begin
     // free memory
     CWin32Prn_CPP_DESTRUCTOR (hdl);
end;

function GetDefPrinterName : string;
var
   pDefaultPrinterName:pChar;
   pBuffer:array [0..256] of char;
begin
     pDefaultPrinterName := pBuffer;
     Ret := dwGetDefaultPrinterName(hdl, pDefaultPrinterName);

     if Ret < 0 then
        Application.MessageBox('Unable to fetch default printer name. If the default printer is undefined PowerPrinter will not work.', 'PowerPrinter Sample', MB_OK);

     GetDefPrinterName := StrPas(pDefaultPrinterName);
end;

function GetDefPrinterPort : string;
var
   pDefaultPrinterPort:pChar;
   pBuffer:array [0..256] of char;
begin
     pDefaultPrinterPort := pBuffer;
     Ret := dwGetDefaultPrinterPort(hdl, pDefaultPrinterPort);

     { TODO: test Ret }

     GetDefPrinterPort := StrPas(pDefaultPrinterPort);
end;

function GetDefPrinterDriver : string;
var
   pDefaultPrinterDriver:pChar;
   pBuffer:array [0..256] of char;
begin
     pDefaultPrinterDriver := pBuffer;
     Ret := dwGetDefaultPrinterDriver(hdl, pDefaultPrinterDriver);

     { TODO: test Ret }

     GetDefPrinterDriver := StrPas(pDefaultPrinterDriver);
end;

function GetPrinterOrientationString : string;
var
   iOrient : SmallInt;
   lError : LongInt;
   sOrient : string;
begin

        lError := dwGetPrinterOrientation(hdl, iOrient);

        if lError > 0 then
        begin
             case iOrient of
                  1: sOrient := 'Portrait';
                  2: sOrient := 'Landscape';
                  3: sOrient := 'Unknown';
             end;

        end
           else
               sOrient := 'Unable to Fetch Orientation. ErrCode : '+ IntToStr(lError);

        GetPrinterOrientationString := sOrient;
end;

function SetPrinterOrientation (iOrient : smallint) : LongInt;
begin
     SetPrinterOrientation := dwSetPrinterOrientation(hdl, iOrient)
end;

function GetPrinterList : string;
var
   iRet :LOngInt;
   pPrnList:pChar;
   pBuffer:array [0..2000] of char;

begin
     pPrnList := pBuffer;
     Ret := dwGetPrinterList (hdl, pPrnList);

     GetPrinterList := StrPas(pPrnList);
end;

procedure SetDefaultPrinter (pName:string);
var
   szPrinterName:pChar;
   tmpBuf: array [0..256] of char;
begin
     StrPCopy(tmpBuf, pName);
     szPrinterName := tmpBuf;
     dwSetDefaultPrinter (hdl, szPrinterName);
end;

procedure About;
begin
     dwAbout();
end;

function Unlock (RegUser:String; lKey:LOngInt):longint;
var
   szRegUser:pChar;
   tmpBuf: array [0..256] of char;
begin
     StrPCopy(tmpBuf, RegUser);
     szRegUser := tmpBuf;
     Unlock := dwUnlock (szRegUser, lKey);
end;

function GetPaperBinList: string;
var
   iRet :LongInt;
   pBinList:pChar;
   pBuffer:array [0..2000] of char;
begin
     pBinList := pBuffer;
     Ret := dwGetPaperBinList (hdl, pBinList);

     if Ret > 0 then
        GetPaperBinList := StrPas(pBinList)
     else
         GetPaperBinList := 'Could not fetch Paper Bin List';
end;

function GetNamedPaperBinList: string;
var
   iRet :LongInt;
   pBinList:pChar;
   pBuffer:array [0..4000] of char;
begin
     pBinList := pBuffer;
     Ret := dwGetNamedPaperBinList (hdl, pBinList);

     if Ret > 0 then
        GetNamedPaperBinList := StrPas(pBinList)
     else
         GetNamedPaperBinList := 'Could not fetch Named Paper Bin List';

end;

function GetPaperSizeList: string ;
var
   iRet :LongInt;
   pPaperSizeList:pChar;
   pBuffer:array [0..2000] of char;
begin
     pPaperSizeList := pBuffer;
     Ret := dwGetSupportedPaperSizeList (hdl, pPaperSizeList);

     if Ret > 0 then
         GetPaperSizeList := StrPas(pPaperSizeList)
     else
         GetPaperSizeList := 'Could not fetch Paper Size List';

end;

function SetPaperSize (iSize : SmallInt) : LongInt;
begin
     SetPaperSize := dwSetPaperSize (hdl, iSize);
end;

function GetPaperSize (var iSize:SmallInt) : longint;
begin
     GetPaperSize := dwGetPaperSize(hdl, iSize);
end;

function SetDefaultSource (iSource : SmallInt) : LongInt;
begin
     SetDefaultSource := dwSetDefaultSource(hdl, iSource);
end;

function GetDefaultSource (var iSource : SmallInt) : longint;
begin
     GetDefaultSource := dwGetDefaultSource(hdl, iSource);
end;

// paper Length
function GetPaperLength(var iPaperLength:smallint) :longint;
begin
     GetPaperLength := dwGetPaperLength(hdl, iPaperlength);
end;

function SetPaperLength(iPaperLength:smallint) :longint;
begin
     SetPaperLength := dwSetPaperLength(hdl, iPaperLength);
end;

// paper Width
function GetPaperWidth(var iPaperWidth:smallint) :longint;
begin
     GetPaperWidth := dwGetPaperWidth(hdl, iPaperWidth);
end;

function SetPaperWidth(iPaperWidth:smallint) :longint;
begin
     SetPaperWidth := dwSetPaperWidth(hdl, iPaperWidth);
end;

// Scale
function GetScale(var iScale:smallint) :longint;
begin
     getScale := dwgetScale(hdl, iScale);
end;

function SetScale(iScale:smallint) :longint;
begin
     SetScale := dwSetScale(hdl, iScale);
end;


// Copies
function GetCopies(var iCopies:smallint) :longint;
begin
     GetCopies := dwGetCopies(hdl, iCopies);
end;

function SetCopies(iCopies:smallint) :longint;
begin
     SetCopies := dwSetCopies(hdl, iCopies);
end;

// dmPrintQuality
function GetPrintQuality(var iPrintQuality:smallint) :longint;
begin
     GetPrintQuality := dwGetPrintQuality(hdl, iPrintQuality);
end;

function SetPrintQuality(iPrintQuality:smallint) :longint;
begin
     SetPrintQuality := dwSetPrintQuality(hdl, iPrintQuality);
end;

// Color
function GetColor(var iColor:smallint) :longint;
begin
     GetColor := dwGetColor(hdl, iColor);
end;

function SetColor(iColor:smallint) :longint;
begin
     SetColor := dwSetColor(hdl, iColor);
end;

// Duplex
function GetDuplex(var iDuplex:smallint) :longint;
begin
     GetDuplex := dwGetDuplex(hdl, iDuplex);
end;

function SetDuplex(iDuplex:smallint) :longint;
begin
     SetDuplex := dwSetDuplex(hdl, iDuplex);
end;

// YResolution
function GetYResolution(var iYResolution:smallint) :longint;
begin
     GetYResolution := dwGetYResolution(hdl,iYResolution);
end;

function SetYResolution(iYResolution:smallint) :longint;
begin
     SetYResolution := dwSetYResolution(hdl,iYResolution);
end;

// TTOption
function GetTTOption(var iTTOption:smallint) :longint;
begin
     GetTTOption := dwSetTTOption(hdl, iTTOption);
end;

function SetTTOption(iTTOption:smallint) :longint;
begin
     SetTTOption := dwSetTTOption(hdl, iTTOption);
end;

// Collate
function GetCollate(var iCollate:smallint) :longint;
begin
     GetCollate := dwGetCollate(hdl, iCollate);
end;

function SetCollate(iCollate:smallint) :longint;
begin
     SetCollate := dwSetCollate(hdl, iCollate);
end;

function GetExtendedErrorCode : LongInt;
begin
     GetExtendedErrorCode := dwGetExtendedErrorCode(hdl);
end;

function GetExtendedErrorMessage :string ;
var
   pMsg:pChar;
   pBuffer:array [0..2048] of char;
begin
     pMsg := pBuffer;
     dwGetExtendedErrorMessage(hdl, pMsg);

     GetExtendedErrorMessage := StrPas(pMsg);
end;

function AddAPrinterConnection (szServerName, szPrnShareName:string) :longint;
begin
     AddAPrinterConnection := dwAddPrinterConnection (hdl, szServerName, szPrnShareName);
end;

function DeleteAPrinterConnection (szServerName, szPrnShareName:string) :longint;
begin
     DeleteAPrinterConnection := dwDeletePrinterConnection(hdl, szServerName, szPrnShareName);
end;

function AddAPrinter (szServerName, szPrinterName, szPortName, szDriverName, szPrintProcessor:string) :longint;
begin
     AddAPrinter := dwAddPrinter( hdl, szServerName, szPrinterName, szPortName, szDriverName, szPrintProcessor);
end;

function DeleteAPrinter (szPrinterName:string) :longint;
begin
     DeleteAPrinter := dwDeletePrinter(hdl, szPrinterName);
end;

function GetAPrinterDriver(szPrinterName:string;DriverInfo:pDriverInfo2) : LongInt;
begin
     GetAPrinterDriver := dwGetPrinterDriver(hdl, szPrinterName, DriverInfo);
end;

function GetPrinterDrivers(DriverInfo:pDriverInfo2; iMax:LongInt;var iActualOnes:smallint) : LongInt;
begin
     GetPrinterDrivers := dwGetPrinterDrivers(hdl, DriverInfo, iMax, iActualOnes);
end;

function SetPrinterAccess(PrinterAccess:longint):longint;
begin
     SetPrinterAccess := dwSetPrinterAccess(hdl, PrinterAccess);
end;

function GetPrinterAccess():longint;
begin
     GetPrinterAccess := dwGetPrinterAccess(hdl);
end;

function AddAPrinterDriver (szServerName, szPrinterName, szEnvironment, szDriverPath, szDataFile, szConfigFile:string; dVersion:longint) :longint;
begin
     AddAPrinterDriver := dwAddPrinterDriver(hdl, szServerName, szPrinterName, szEnvironment, szDriverPath, szDataFile, szConfigFile, dVersion);
end;

function DeleteAPrinterDriver (szServerName, szEnvironment, szDriverName:string) :longint;
begin
     DeleteAPrinterDriver := dwDeletePrinterDriver (hdl, szServerName, szEnvironment, szDriverName);
end;

function EnumPrinterJobs(szPrinterName:String; iMaxJobs:LongInt; JobInfo:pJobInfo1; var Jobs:LongInt):longint;
begin
     EnumPrinterJobs := dwEnumPrinterJobs(hdl, szPrinterName, iMaxJobs, JobInfo, Jobs);
end;


// Capture desktop
function CaptureDesktop:longint;
begin
     CaptureDesktop := dwCaptureDesktop(hdl);
end;

// capture a window by handle
// Option = 1 entire window
//          2 client area
function CaptureWindow (hWin:LongInt; iOption:Integer) : LongInt;
begin
     CaptureWindow := dwCaptureWindow(hdl, hWin, iOption);
end;

// print captured window
function PrintTheDIB(iOptions:LongInt; szJobName:String):longint;
begin
     PrintTheDIB := dwPrintTheDIB(hdl, iOptions, szJobName);
end;

function EnumPrnFonts:string;
var
   pBuf:pChar;
   Buffer:array [0..4096] of char;
   lRet:LongInt;
begin
     pBuf := Buffer;

     lRet := dwEnumPrinterFonts(hdl, pBuf);

     EnumPrnFonts := StrPas(pBuf);
end;


function SetPrinterFont(pDC:LongInt; fontName:string; iPoint, iBold, iItalic, iUnderline, iStrike:integer):LongInt;
begin
     SetPrinterFont := dwSetPrinterFont(hdl, pDC, fontName, iPoint, iBold, iItalic, iUnderline, iStrike);
end;
end.
