VERSION 4.00
Begin VB.Form Form1 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "PowerPrinter VB Sample"
   ClientHeight    =   5760
   ClientLeft      =   1860
   ClientTop       =   2070
   ClientWidth     =   8430
   Height          =   6165
   Left            =   1800
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5760
   ScaleWidth      =   8430
   ShowInTaskbar   =   0   'False
   Top             =   1725
   Width           =   8550
   Begin VB.TextBox eKey 
      Height          =   285
      Left            =   4320
      TabIndex        =   24
      Top             =   5280
      Width           =   1935
   End
   Begin VB.TextBox eUserName 
      Height          =   285
      Left            =   4320
      TabIndex        =   23
      Top             =   4920
      Width           =   1935
   End
   Begin VB.CommandButton cmdUnlock 
      Caption         =   "Unlock"
      Height          =   495
      Left            =   1800
      TabIndex        =   20
      Top             =   4920
      Width           =   1215
   End
   Begin VB.CommandButton cmdAbout 
      Caption         =   "About"
      Height          =   495
      Left            =   360
      TabIndex        =   19
      Top             =   4920
      Width           =   1215
   End
   Begin VB.TextBox tb_port 
      Enabled         =   0   'False
      Height          =   285
      Left            =   5760
      TabIndex        =   7
      Text            =   "Text1"
      Top             =   360
      Width           =   1935
   End
   Begin VB.TextBox tb_driver 
      Enabled         =   0   'False
      Height          =   285
      Left            =   3600
      TabIndex        =   5
      Text            =   "Text1"
      Top             =   360
      Width           =   1815
   End
   Begin VB.TextBox tb_prnname 
      Enabled         =   0   'False
      Height          =   285
      Left            =   240
      TabIndex        =   3
      Text            =   "Text1"
      Top             =   360
      Width           =   2295
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Bye"
      Height          =   495
      Left            =   6480
      TabIndex        =   0
      Top             =   4920
      Width           =   1215
   End
   Begin TabDlg.SSTab SSTab1 
      Height          =   3975
      Left            =   360
      TabIndex        =   1
      Top             =   840
      Width           =   7815
      _Version        =   65536
      _ExtentX        =   13785
      _ExtentY        =   7011
      _StockProps     =   15
      Caption         =   "Enum Drivers"
      TabsPerRow      =   4
      Tab             =   9
      TabOrientation  =   0
      Tabs            =   12
      Style           =   0
      TabMaxWidth     =   0
      TabHeight       =   529
      TabCaption(0)   =   "Orientation"
      Tab(0).ControlCount=   8
      Tab(0).ControlEnabled=   0   'False
      Tab(0).Control(0)=   "Label4"
      Tab(0).Control(1)=   "lbl_orientation"
      Tab(0).Control(2)=   "Label13"
      Tab(0).Control(3)=   "btn_setlandscape"
      Tab(0).Control(4)=   "btn_setportrait"
      Tab(0).Control(5)=   "cmbPrinterAccess"
      Tab(0).Control(6)=   "cbSetPrinterAccess"
      Tab(0).Control(7)=   "Command3"
      TabCaption(1)   =   "Printer List"
      TabPicture(1)   =   "ppform.frx":0000
      Tab(1).ControlCount=   4
      Tab(1).ControlEnabled=   0   'False
      Tab(1).Control(0)=   "Label5"
      Tab(1).Control(1)=   "Label6"
      Tab(1).Control(2)=   "lb_printerlist"
      Tab(1).Control(3)=   "btn_getprnlist"
      TabCaption(2)   =   "PaperBin"
      TabPicture(2)   =   "ppform.frx":001C
      Tab(2).ControlCount=   6
      Tab(2).ControlEnabled=   0   'False
      Tab(2).Control(0)=   "optNamed"
      Tab(2).Control(1)=   "optDefault"
      Tab(2).Control(2)=   "lb_Bins"
      Tab(2).Control(3)=   "cmdSetBin"
      Tab(2).Control(4)=   "cmdGetBin"
      Tab(2).Control(5)=   "cmdGetList"
      TabCaption(3)   =   "Paper Size"
      TabPicture(3)   =   "ppform.frx":0038
      Tab(3).ControlCount=   4
      Tab(3).ControlEnabled=   0   'False
      Tab(3).Control(0)=   "cmdSetPaperSize"
      Tab(3).Control(1)=   "cmdGetPaperSize"
      Tab(3).Control(2)=   "cmdGetPaperSizeList"
      Tab(3).Control(3)=   "lb_papersize"
      TabCaption(4)   =   "Extended Errors"
      TabPicture(4)   =   "ppform.frx":0054
      Tab(4).ControlCount=   5
      Tab(4).ControlEnabled=   0   'False
      Tab(4).Control(0)=   "Label10"
      Tab(4).Control(1)=   "Label11"
      Tab(4).Control(2)=   "Label12"
      Tab(4).Control(3)=   "btnEntendedErrorCode"
      Tab(4).Control(4)=   "Command2"
      TabCaption(5)   =   "Printer Connection"
      TabPicture(5)   =   "ppform.frx":0070
      Tab(5).ControlCount=   9
      Tab(5).ControlEnabled=   0   'False
      Tab(5).Control(0)=   "Label14"
      Tab(5).Control(1)=   "Label15"
      Tab(5).Control(2)=   "Label16"
      Tab(5).Control(3)=   "Label17"
      Tab(5).Control(4)=   "Label18"
      Tab(5).Control(5)=   "txtConnectServerName"
      Tab(5).Control(6)=   "txtConnectPrinterName"
      Tab(5).Control(7)=   "btnAddConnection"
      Tab(5).Control(8)=   "btnDelConnection"
      TabCaption(6)   =   "Add/Del Printers"
      TabPicture(6)   =   "ppform.frx":008C
      Tab(6).ControlCount=   15
      Tab(6).ControlEnabled=   0   'False
      Tab(6).Control(0)=   "btnDelPrinter"
      Tab(6).Control(1)=   "btnAddPrinter"
      Tab(6).Control(2)=   "txtAddPrinterPrnServerName"
      Tab(6).Control(3)=   "txtAddPrinterPrnPrintProcessor"
      Tab(6).Control(4)=   "txtAddPrinterPrnDriverName"
      Tab(6).Control(5)=   "txtAddPrinterPrnPortName"
      Tab(6).Control(6)=   "txtAddPrinterPrnName"
      Tab(6).Control(7)=   "Label26"
      Tab(6).Control(8)=   "Label25"
      Tab(6).Control(9)=   "Label24"
      Tab(6).Control(10)=   "Label23"
      Tab(6).Control(11)=   "Label22"
      Tab(6).Control(12)=   "Label21"
      Tab(6).Control(13)=   "Label20"
      Tab(6).Control(14)=   "Label19"
      TabCaption(7)   =   "Add/Del Drivers"
      TabPicture(7)   =   "ppform.frx":00A8
      Tab(7).ControlCount=   18
      Tab(7).ControlEnabled=   0   'False
      Tab(7).Control(0)=   "Label27"
      Tab(7).Control(1)=   "Label28"
      Tab(7).Control(2)=   "Label29"
      Tab(7).Control(3)=   "Label30"
      Tab(7).Control(4)=   "Label31"
      Tab(7).Control(5)=   "Label32"
      Tab(7).Control(6)=   "Label33"
      Tab(7).Control(7)=   "Label34"
      Tab(7).Control(8)=   "txtAddDriverPrinterName"
      Tab(7).Control(9)=   "txtAddDriverEnvironment"
      Tab(7).Control(10)=   "txtAddDriverPath"
      Tab(7).Control(11)=   "txtAddDriverDataFile"
      Tab(7).Control(12)=   "txtAddDriverConfigFile"
      Tab(7).Control(13)=   "txtAddDriverServerName"
      Tab(7).Control(14)=   "txtAddDriverVersion"
      Tab(7).Control(15)=   "txtAddDriverAdd"
      Tab(7).Control(16)=   "txtAddDriverDelete"
      Tab(7).Control(17)=   "txtAddDriverGet"
      TabCaption(8)   =   "Print Jobs"
      TabPicture(8)   =   "ppform.frx":00C4
      Tab(8).ControlCount=   4
      Tab(8).ControlEnabled=   0   'False
      Tab(8).Control(0)=   "Label35"
      Tab(8).Control(1)=   "txtEnumJobsPrnName"
      Tab(8).Control(2)=   "lstJobs"
      Tab(8).Control(3)=   "btnEnumJobs"
      TabCaption(9)   =   "Enum Drivers"
      TabPicture(9)   =   "ppform.frx":00E0
      Tab(9).ControlCount=   5
      Tab(9).ControlEnabled=   -1  'True
      Tab(9).Control(0)=   "Label37"
      Tab(9).Control(1)=   "btnEnumAllPrinterDrivers"
      Tab(9).Control(2)=   "btnEnumPrinterDriverFor"
      Tab(9).Control(3)=   "txtEnumDriversPrnName"
      Tab(9).Control(4)=   "lstDrivers"
      TabCaption(10)  =   "Desktop"
      TabPicture(10)  =   "ppform.frx":00FC
      Tab(10).ControlCount=   3
      Tab(10).ControlEnabled=   0   'False
      Tab(10).Control(0)=   "Frame1"
      Tab(10).Control(1)=   "Frame2"
      Tab(10).Control(2)=   "Frame3"
      TabCaption(11)  =   "Printer Fonts"
      TabPicture(11)  =   "ppform.frx":0118
      Tab(11).ControlCount=   6
      Tab(11).ControlEnabled=   0   'False
      Tab(11).Control(0)=   "Label9"
      Tab(11).Control(1)=   "Label36"
      Tab(11).Control(2)=   "lstPrinterFonts"
      Tab(11).Control(3)=   "btnEnumPrinterFonts"
      Tab(11).Control(4)=   "btnSetFont"
      Tab(11).Control(5)=   "cbTestMore"
      Begin VB.CommandButton cbTestMore 
         Caption         =   "Test All"
         Height          =   375
         Left            =   -71280
         TabIndex        =   106
         Top             =   2520
         Width           =   1815
      End
      Begin VB.Frame Frame3 
         Caption         =   "Print"
         Height          =   855
         Left            =   -73080
         TabIndex        =   101
         Top             =   2640
         Width           =   3975
         Begin VB.OptionButton cbStrecth 
            Caption         =   "Strecth to page"
            Height          =   255
            Left            =   2280
            TabIndex        =   104
            Top             =   480
            Width           =   1455
         End
         Begin VB.OptionButton cbBestFit 
            Caption         =   "Best Fit"
            Height          =   255
            Left            =   2280
            TabIndex        =   103
            Top             =   240
            Value           =   -1  'True
            Width           =   1575
         End
         Begin VB.CommandButton cbPrint 
            Caption         =   "Print"
            Height          =   495
            Left            =   360
            TabIndex        =   102
            Top             =   240
            Width           =   1695
         End
      End
      Begin VB.Frame Frame2 
         Caption         =   "Capture Window By Handle"
         Height          =   975
         Left            =   -71880
         TabIndex        =   97
         Top             =   1320
         Width           =   3855
         Begin VB.OptionButton cbclientarea 
            Caption         =   "Client arera"
            Height          =   255
            Left            =   2160
            TabIndex        =   100
            Top             =   600
            Width           =   1455
         End
         Begin VB.OptionButton cbentirewindow 
            Caption         =   "Entire Window"
            Height          =   255
            Left            =   2160
            TabIndex        =   99
            Top             =   360
            Value           =   -1  'True
            Width           =   1575
         End
         Begin VB.CommandButton Command4 
            Caption         =   "Capture Window"
            Height          =   495
            Left            =   240
            TabIndex        =   98
            Top             =   360
            Width           =   1815
         End
      End
      Begin VB.Frame Frame1 
         Caption         =   "Capture Desktop"
         Height          =   975
         Left            =   -74640
         TabIndex        =   95
         Top             =   1320
         Width           =   2415
         Begin VB.CommandButton cmdCaptureDesktop 
            Caption         =   "Capture Desktop"
            Height          =   495
            Left            =   120
            TabIndex        =   96
            Top             =   360
            Width           =   2055
         End
      End
      Begin VB.ListBox lstDrivers 
         Height          =   1815
         Left            =   240
         TabIndex        =   94
         Top             =   1800
         Width           =   6975
      End
      Begin VB.TextBox txtEnumDriversPrnName 
         Height          =   285
         Left            =   4560
         TabIndex        =   93
         Top             =   1320
         Width           =   2655
      End
      Begin VB.CommandButton btnEnumPrinterDriverFor 
         Caption         =   "Enum Printer Driver for:"
         Height          =   375
         Left            =   2400
         TabIndex        =   92
         Top             =   1320
         Width           =   2055
      End
      Begin VB.CommandButton btnEnumAllPrinterDrivers 
         Caption         =   "Enum All Printer Drivers"
         Enabled         =   0   'False
         Height          =   375
         Left            =   240
         TabIndex        =   91
         Top             =   1320
         Width           =   1935
      End
      Begin VB.CommandButton btnEnumJobs 
         Caption         =   "Enum Jobs For:"
         Enabled         =   0   'False
         Height          =   375
         Left            =   -74640
         TabIndex        =   89
         Top             =   1320
         Width           =   1575
      End
      Begin VB.ListBox lstJobs 
         Height          =   1815
         Left            =   -74640
         TabIndex        =   88
         Top             =   1800
         Width           =   5775
      End
      Begin VB.TextBox txtEnumJobsPrnName 
         Height          =   285
         Left            =   -72960
         TabIndex        =   87
         Top             =   1320
         Width           =   4095
      End
      Begin VB.CommandButton txtAddDriverGet 
         Caption         =   "Get"
         Height          =   375
         Left            =   -69000
         TabIndex        =   86
         Top             =   1080
         Width           =   1335
      End
      Begin VB.CommandButton txtAddDriverDelete 
         Caption         =   "Delete"
         Height          =   375
         Left            =   -69000
         TabIndex        =   85
         Top             =   3360
         Width           =   1335
      End
      Begin VB.CommandButton txtAddDriverAdd 
         Caption         =   "Add"
         Height          =   375
         Left            =   -70440
         TabIndex        =   84
         Top             =   3360
         Width           =   1335
      End
      Begin VB.TextBox txtAddDriverVersion 
         Height          =   285
         Left            =   -73560
         TabIndex        =   83
         Top             =   3360
         Width           =   2415
      End
      Begin VB.TextBox txtAddDriverServerName 
         Height          =   285
         Left            =   -73560
         TabIndex        =   82
         Top             =   3000
         Width           =   2415
      End
      Begin VB.TextBox txtAddDriverConfigFile 
         Height          =   285
         Left            =   -73560
         TabIndex        =   81
         Top             =   2640
         Width           =   5775
      End
      Begin VB.TextBox txtAddDriverDataFile 
         Height          =   285
         Left            =   -73560
         TabIndex        =   80
         Top             =   2280
         Width           =   5775
      End
      Begin VB.TextBox txtAddDriverPath 
         Height          =   285
         Left            =   -73560
         TabIndex        =   79
         Top             =   1920
         Width           =   5775
      End
      Begin VB.TextBox txtAddDriverEnvironment 
         Height          =   285
         Left            =   -73560
         TabIndex        =   77
         Top             =   1560
         Width           =   2415
      End
      Begin VB.TextBox txtAddDriverPrinterName 
         Height          =   285
         Left            =   -73560
         TabIndex        =   76
         Top             =   1200
         Width           =   2415
      End
      Begin VB.CommandButton btnDelPrinter 
         Caption         =   "Del Printer"
         Height          =   375
         Left            =   -70080
         TabIndex        =   65
         Top             =   1800
         Width           =   2055
      End
      Begin VB.CommandButton btnAddPrinter 
         Caption         =   "Add Printer"
         Height          =   375
         Left            =   -70080
         TabIndex        =   64
         Top             =   1200
         Width           =   2055
      End
      Begin VB.TextBox txtAddPrinterPrnServerName 
         Height          =   285
         Left            =   -73560
         TabIndex        =   63
         Text            =   "\\BIGSERVER"
         Top             =   2760
         Width           =   2655
      End
      Begin VB.TextBox txtAddPrinterPrnPrintProcessor 
         Height          =   285
         Left            =   -73560
         TabIndex        =   62
         Text            =   "WinPrint"
         Top             =   2280
         Width           =   2655
      End
      Begin VB.TextBox txtAddPrinterPrnDriverName 
         Height          =   285
         Left            =   -73560
         TabIndex        =   61
         Text            =   "HP LaserJet 5P"
         Top             =   1920
         Width           =   2655
      End
      Begin VB.TextBox txtAddPrinterPrnPortName 
         Height          =   285
         Left            =   -73560
         TabIndex        =   60
         Text            =   "LPT1:"
         Top             =   1560
         Width           =   2655
      End
      Begin VB.TextBox txtAddPrinterPrnName 
         Height          =   285
         Left            =   -73560
         TabIndex        =   59
         Text            =   "PRNTEST"
         Top             =   1200
         Width           =   2655
      End
      Begin VB.CommandButton btnDelConnection 
         Caption         =   "Delete"
         Height          =   375
         Left            =   -70920
         TabIndex        =   51
         Top             =   2760
         Width           =   1455
      End
      Begin VB.CommandButton btnAddConnection 
         Caption         =   "Connect"
         Height          =   375
         Left            =   -72720
         TabIndex        =   50
         Top             =   2760
         Width           =   1455
      End
      Begin VB.TextBox txtConnectPrinterName 
         Height          =   285
         Left            =   -69960
         TabIndex        =   49
         Top             =   2160
         Width           =   1935
      End
      Begin VB.TextBox txtConnectServerName 
         Height          =   285
         Left            =   -73440
         TabIndex        =   47
         Top             =   2160
         Width           =   2055
      End
      Begin VB.CommandButton Command3 
         Caption         =   "Get"
         Height          =   375
         Left            =   -69240
         TabIndex        =   44
         Top             =   1920
         Width           =   1095
      End
      Begin VB.CommandButton cbSetPrinterAccess 
         Caption         =   "Set"
         Height          =   375
         Left            =   -70560
         TabIndex        =   43
         Top             =   1920
         Width           =   1095
      End
      Begin VB.ComboBox cmbPrinterAccess 
         Height          =   315
         ItemData        =   "ppform.frx":0134
         Left            =   -70560
         List            =   "ppform.frx":0136
         Style           =   2  'Dropdown List
         TabIndex        =   41
         Top             =   1440
         Width           =   2415
      End
      Begin VB.CommandButton Command2 
         Caption         =   "Get Extended Error Message"
         Height          =   495
         Left            =   -71160
         TabIndex        =   40
         Top             =   2520
         Width           =   2415
      End
      Begin VB.CommandButton btnEntendedErrorCode 
         Caption         =   "Get Extended Error Code"
         Height          =   495
         Left            =   -74160
         TabIndex        =   36
         Top             =   2520
         Width           =   2415
      End
      Begin VB.CommandButton btnSetFont 
         Caption         =   "Set Font and Test"
         Height          =   375
         Left            =   -71280
         TabIndex        =   35
         Top             =   2040
         Width           =   1815
      End
      Begin VB.CommandButton btnEnumPrinterFonts 
         Caption         =   "Get Them !"
         Height          =   375
         Left            =   -71280
         TabIndex        =   34
         Top             =   1560
         Width           =   1815
      End
      Begin VB.ListBox lstPrinterFonts 
         Height          =   2010
         Left            =   -74760
         Sorted          =   -1  'True
         TabIndex        =   32
         Top             =   1560
         Width           =   3375
      End
      Begin VB.CommandButton cmdSetPaperSize 
         Caption         =   "Set Paper Size"
         Height          =   495
         Left            =   -69840
         TabIndex        =   31
         Top             =   2880
         Width           =   1575
      End
      Begin VB.CommandButton cmdGetPaperSize 
         Caption         =   "Get Paper Size"
         Height          =   495
         Left            =   -69840
         TabIndex        =   30
         Top             =   2160
         Width           =   1575
      End
      Begin VB.CommandButton cmdGetPaperSizeList 
         Caption         =   "Get List"
         Height          =   495
         Left            =   -69840
         TabIndex        =   29
         Top             =   1440
         Width           =   1575
      End
      Begin VB.ListBox lb_papersize 
         Height          =   2400
         Left            =   -74520
         TabIndex        =   28
         Top             =   1320
         Width           =   3855
      End
      Begin VB.OptionButton optNamed 
         Caption         =   "Named"
         Height          =   255
         Left            =   -72960
         TabIndex        =   27
         Top             =   1200
         Width           =   1215
      End
      Begin VB.OptionButton optDefault 
         Caption         =   "Default"
         Height          =   255
         Left            =   -74520
         TabIndex        =   26
         Top             =   1200
         Value           =   -1  'True
         Width           =   1215
      End
      Begin VB.ListBox lb_Bins 
         Height          =   2205
         Left            =   -74760
         TabIndex        =   25
         Top             =   1560
         Width           =   5295
      End
      Begin VB.CommandButton cmdSetBin 
         Caption         =   "Set Bin"
         Height          =   495
         Left            =   -69240
         TabIndex        =   18
         Top             =   2760
         Width           =   1335
      End
      Begin VB.CommandButton cmdGetBin 
         Caption         =   "Get Bin"
         Height          =   495
         Left            =   -69240
         TabIndex        =   17
         Top             =   2160
         Width           =   1335
      End
      Begin VB.CommandButton cmdGetList 
         Caption         =   "Get List"
         Height          =   495
         Left            =   -69240
         TabIndex        =   16
         Top             =   1560
         Width           =   1335
      End
      Begin VB.CommandButton btn_getprnlist 
         Caption         =   "Get It"
         Height          =   495
         Left            =   -71760
         TabIndex        =   13
         Top             =   1680
         Width           =   1215
      End
      Begin VB.ListBox lb_printerlist 
         Height          =   2010
         Left            =   -74520
         TabIndex        =   12
         Top             =   1680
         Width           =   2535
      End
      Begin VB.CommandButton btn_setportrait 
         Caption         =   "Set as Portrait"
         Height          =   495
         Left            =   -72240
         TabIndex        =   11
         Top             =   3120
         Width           =   1935
      End
      Begin VB.CommandButton btn_setlandscape 
         Caption         =   "Set As Landscape"
         Height          =   495
         Left            =   -74640
         TabIndex        =   10
         Top             =   3120
         Width           =   2175
      End
      Begin VB.Label Label37 
         Caption         =   "These APis are not compatible with VB. Please refer to the 'VB Strings' section in the online help (F1)"
         Height          =   255
         Left            =   240
         TabIndex        =   107
         Top             =   960
         Width           =   7215
      End
      Begin VB.Label Label36 
         Caption         =   "NB: API Not Complete !"
         Height          =   255
         Left            =   -71280
         TabIndex        =   105
         Top             =   3360
         Width           =   3255
      End
      Begin VB.Label Label35 
         Caption         =   "WARNING: This API is not compatible with VB. Please refer to 'VB Strings' section in the help (F1)"
         Height          =   255
         Left            =   -74640
         TabIndex        =   90
         Top             =   960
         Width           =   7095
      End
      Begin VB.Label Label34 
         Caption         =   "Use 'Windows 4.0' for 95"
         Height          =   255
         Left            =   -71040
         TabIndex        =   78
         Top             =   1560
         Width           =   1935
      End
      Begin VB.Label Label33 
         Caption         =   "Server:"
         Height          =   255
         Left            =   -74760
         TabIndex        =   75
         Top             =   3000
         Width           =   975
      End
      Begin VB.Label Label32 
         Caption         =   "Version:"
         Height          =   255
         Left            =   -74760
         TabIndex        =   74
         Top             =   3360
         Width           =   855
      End
      Begin VB.Label Label31 
         Caption         =   "Config File:"
         Height          =   255
         Left            =   -74760
         TabIndex        =   73
         Top             =   2640
         Width           =   975
      End
      Begin VB.Label Label30 
         Caption         =   "Data File:"
         Height          =   255
         Left            =   -74760
         TabIndex        =   72
         Top             =   2280
         Width           =   855
      End
      Begin VB.Label Label29 
         Caption         =   "Driver Path:"
         Height          =   255
         Left            =   -74760
         TabIndex        =   71
         Top             =   1920
         Width           =   1095
      End
      Begin VB.Label Label28 
         Caption         =   "Environment:"
         Height          =   255
         Left            =   -74760
         TabIndex        =   70
         Top             =   1560
         Width           =   1095
      End
      Begin VB.Label Label27 
         Caption         =   "Printer Name:"
         Height          =   255
         Left            =   -74760
         TabIndex        =   69
         Top             =   1200
         Width           =   1215
      End
      Begin VB.Label Label26 
         Caption         =   "locally clear out the field. See How to Add/Delete a printer in the help file."
         Height          =   255
         Left            =   -74760
         TabIndex        =   68
         Top             =   3480
         Width           =   6495
      End
      Begin VB.Label Label25 
         Caption         =   "NB: By specifying a server name under NT you will add the printer over there !. To install it "
         Height          =   255
         Left            =   -74760
         TabIndex        =   67
         Top             =   3240
         Width           =   6615
      End
      Begin VB.Label Label24 
         Caption         =   "NT Only !. see help file for details"
         Height          =   255
         Left            =   -70680
         TabIndex        =   66
         Top             =   2760
         Width           =   2415
      End
      Begin VB.Label Label23 
         Caption         =   "Server Name:"
         Height          =   255
         Left            =   -74760
         TabIndex        =   58
         Top             =   2760
         Width           =   1335
      End
      Begin VB.Label Label22 
         Caption         =   "Print Processor:"
         Height          =   255
         Left            =   -74760
         TabIndex        =   57
         Top             =   2280
         Width           =   1215
      End
      Begin VB.Label Label21 
         Caption         =   "Driver Name:"
         Height          =   255
         Left            =   -74760
         TabIndex        =   56
         Top             =   1920
         Width           =   1095
      End
      Begin VB.Label Label20 
         Caption         =   "Port Name:"
         Height          =   255
         Left            =   -74760
         TabIndex        =   55
         Top             =   1560
         Width           =   975
      End
      Begin VB.Label Label19 
         Caption         =   "Printer Name:"
         Height          =   255
         Left            =   -74760
         TabIndex        =   54
         Top             =   1200
         Width           =   1215
      End
      Begin VB.Label Label18 
         Caption         =   "Type the server name and the printer name as defined in the server and click on CONNECT"
         Height          =   255
         Left            =   -74760
         TabIndex        =   53
         Top             =   1680
         Width           =   6975
      End
      Begin VB.Label Label17 
         Caption         =   "Under Windows NT you can easily connect to a network printer even if you don't have the drivers"
         Height          =   255
         Left            =   -74760
         TabIndex        =   52
         Top             =   1440
         Width           =   7095
      End
      Begin VB.Label Label16 
         Caption         =   "Printer Name:"
         Height          =   255
         Left            =   -71160
         TabIndex        =   48
         Top             =   2160
         Width           =   1095
      End
      Begin VB.Label Label15 
         Caption         =   "Server Name:"
         Height          =   255
         Left            =   -74640
         TabIndex        =   46
         Top             =   2160
         Width           =   1095
      End
      Begin VB.Label Label14 
         Caption         =   "NT Only !"
         BeginProperty Font 
            name            =   "MS Sans Serif"
            charset         =   0
            weight          =   700
            size            =   8.25
            underline       =   0   'False
            italic          =   0   'False
            strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   -74760
         TabIndex        =   45
         Top             =   1080
         Width           =   1335
      End
      Begin VB.Label Label13 
         Caption         =   "NT Printer Access"
         Height          =   255
         Left            =   -70560
         TabIndex        =   42
         Top             =   1080
         Width           =   2415
      End
      Begin VB.Label Label12 
         Caption         =   "These APIs should be called right after an API call failed and you need additional information."
         Height          =   255
         Left            =   -74760
         TabIndex        =   39
         Top             =   1680
         Width           =   6975
      End
      Begin VB.Label Label11 
         Caption         =   "You can access extended errors using dwGetExtendedErrorCode and dwGetExtendedErrorMessage"
         Height          =   255
         Left            =   -74760
         TabIndex        =   38
         Top             =   1440
         Width           =   7215
      End
      Begin VB.Label Label10 
         Caption         =   "Starting with v1.1 PowerPrinter gives you access to the extended error code as defined in the SDK"
         Height          =   255
         Left            =   -74760
         TabIndex        =   37
         Top             =   1200
         Width           =   7095
      End
      Begin VB.Label Label9 
         Caption         =   "Printer Fonts:"
         Height          =   255
         Left            =   -74760
         TabIndex        =   33
         Top             =   1200
         Width           =   2295
      End
      Begin VB.Label Label6 
         Caption         =   "Double click on a printer to set it as default"
         Height          =   255
         Left            =   -74520
         TabIndex        =   15
         Top             =   3960
         Width           =   5295
      End
      Begin VB.Label Label5 
         Caption         =   "Printer List: double click on a printer to set it as default"
         Height          =   255
         Left            =   -74520
         TabIndex        =   14
         Top             =   1320
         Width           =   3975
      End
      Begin VB.Label lbl_orientation 
         Caption         =   "lbl_orientation"
         Height          =   255
         Left            =   -73440
         TabIndex        =   9
         Top             =   1320
         Width           =   3495
      End
      Begin VB.Label Label4 
         Caption         =   "Orientation:"
         Height          =   255
         Left            =   -74640
         TabIndex        =   8
         Top             =   1320
         Width           =   975
      End
   End
   Begin VB.Label Label8 
      Alignment       =   1  'Right Justify
      Caption         =   "Key:"
      Height          =   255
      Left            =   3240
      TabIndex        =   22
      Top             =   5280
      Width           =   975
   End
   Begin VB.Label Label7 
      Alignment       =   1  'Right Justify
      Caption         =   "User Name:"
      Height          =   255
      Left            =   3240
      TabIndex        =   21
      Top             =   4920
      Width           =   975
   End
   Begin VB.Label Label3 
      Caption         =   "Port:"
      Height          =   255
      Left            =   5760
      TabIndex        =   6
      Top             =   120
      Width           =   1815
   End
   Begin VB.Label Label2 
      Caption         =   "Printer Driver:"
      Height          =   255
      Left            =   3600
      TabIndex        =   4
      Top             =   120
      Width           =   1575
   End
   Begin VB.Label Label1 
      Caption         =   "Default Printer Name:"
      Height          =   255
      Left            =   240
      TabIndex        =   2
      Top             =   120
      Width           =   1815
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

Dim iPowerPrn As New powerprn

Private Sub btn_getprnlist_Click()

    Dim PrnList As String
    Dim PrnName As String
    Dim i, iPOs As Integer
    Dim lRet As Long
        
    Screen.MousePointer = 11
    
    lb_printerlist.Clear
     
    lRet = iPowerPrn.GetPrinterList(PrnList)
    
    If lRet > 0 Then
        ' printers are separated by semicolumn
        iPOs = InStr(PrnList, "")
        While iPOs > 0
            ' get name
            PrnName = Left(PrnList, iPOs - 1)
            ' add it to the list box
            lb_printerlist.AddItem PrnName
            ' get next one
            PrnList = Right(PrnList, Len(PrnList) - iPOs)
            iPOs = InStr(PrnList, "")
        Wend
    Else
        MsgBox ("Cannot get printer list")
    End If
    
    Screen.MousePointer = 0
End Sub


Private Sub btn_setlandscape_Click()
    Dim PrnOrient As String
    Dim iRet As Long
    
    Screen.MousePointer = 11    ' Change mouse pointer to hourglass.
    
    iRet = iPowerPrn.SetPrinterOrientation(DMORIENT_LANDSCAPE)
   
    If iRet > 0 Then
        iRet = iPowerPrn.GetPrinterOrientationString(PrnOrient)
        lbl_orientation.Caption = PrnOrient
    Else
        MsgBox ("Set orientation Faileded !. Check extended error code in the Errors Tab Page.")
    End If
    
    Screen.MousePointer = 0 ' Return mouse pointer to normal.

End Sub


Private Sub btn_setportrait_Click()
    Dim iRet As Long
    Dim PrnOrient As String
    
    Screen.MousePointer = 11     ' Change mouse pointer to hourglass.
        
    iRet = iPowerPrn.SetPrinterOrientation(DMORIENT_PORTRAIT)

    If iRet > 0 Then    ' update display
        iRet = iPowerPrn.GetPrinterOrientationString(PrnOrient)
        lbl_orientation.Caption = PrnOrient
    Else
        MsgBox ("Set orientation Faileded !. Check extended error code in the Errors Tab Page.")
    End If
    Screen.MousePointer = 0 ' Return mouse pointer to normal.

End Sub

Private Sub btnAddConnection_Click()
    Dim lRet As Long
    
    lRet = iPowerPrn.AddPrinterConnection(txtConnectServerName.Text, txtConnectPrinterName.Text)
    
    If lRet < 1 Then
        MsgBox ("AddPrinterConnection failed !. Check your parameters and the extended errors page.")
    Else
        MsgBox ("AddPrinterConnection succeeded !")
    End If
End Sub

Private Sub btnAddPrinter_Click()

    Dim lRet As Long
    
    lRet = iPowerPrn.AddPrinter(txtAddPrinterPrnServerName.Text, txtAddPrinterPrnName.Text, txtAddPrinterPrnPortName.Text, txtAddPrinterPrnDriverName.Text, txtAddPrinterPrnPrintProcessor.Text)
    
    If lRet < 1 Then
        MsgBox ("AddPrinter failed !. Please check out the extended errors tab page.")
    Else
        MsgBox ("AddPrinter succeeded")
    End If
    
End Sub

Private Sub btnDelConnection_Click()
    Dim lRet As Long
    
    lRet = iPowerPrn.DeletePrinterConnection(txtConnectServerName.Text, txtConnectPrinterName.Text)
    
    If lRet < 1 Then
        MsgBox ("DeletePrinterConnection failed !. Check your parameters and the extended errors page.")
    Else
        MsgBox ("DeletePrinterConnection succeeded !")
   End If
End Sub


Private Sub btnDelPrinter_Click()

Dim lRet As Long

    lRet = iPowerPrn.DeletePrinter(txtAddPrinterPrnName.Text)
    
    If lRet < 1 Then
        MsgBox ("Delete Printer failed !. When removing a remote printer you have to prefix the printer name with the server name (\\MYSERVER\MYPRINTER). Please check out the extended errors tab page.")
    Else
        MsgBox ("Delete Printer succeeded")
    End If
End Sub

Private Sub btnEntendedErrorCode_Click()
    Dim ExtErrCode As Long
    
    ExtErrCode = iPowerPrn.GetExtendedErrorCode()
    
    MsgBox ("Extended Error Code is " + Str$(ExtErrCode))
    
End Sub

Private Sub btnEnumJobs_Click()

    Dim lRet As Long
    Dim PrinterName As String
    
    PrinterName = tb_prnname.Text
    
    lRet = iPowerPrn.EnumPrinterJobs(PrinterName, lstJobs)
    If lRet < 1 Then
        MsgBox ("EnumPrinterJobs failed !. Please check out the extended errors tab page.")
    Else
        MsgBox ("EnumPrinterJobs succeeded")
    End If
    
End Sub

Private Sub btnEnumPrinterDriverFor_Click()

   Dim PrnName As String
   Dim ServerName As String, DriverName As String, Environment As String, DriverPath As String, DataFile As String, ConfigFile As String
   Dim sItem As String
   Dim Version As String
   Dim lRet As Long

   PrnName = txtEnumDriversPrnName.Text
   
   lRet = iPowerPrn.GetPrinterDriver(PrnName, DriverName, ServerName, Environment, DriverPath, DataFile, ConfigFile, Version)
   
   If lRet = 1 Then
        lstDrivers.Clear
        sItem = "Printer Driver Name: "
        sItem = sItem + DriverName
        lstDrivers.AddItem sItem
        
        sItem = " Version: "
        sItem = sItem + Version
        lstDrivers.AddItem sItem
        
        sItem = " Environment: "
        sItem = sItem + Environment
        lstDrivers.AddItem sItem

        sItem = " Driver Path: "
        sItem = sItem + DriverPath
        lstDrivers.AddItem sItem

        sItem = " Data File: "
        sItem = sItem + DataFile
        lstDrivers.AddItem sItem

        sItem = " Config File: "
        sItem = sItem + ConfigFile
        lstDrivers.AddItem sItem

        
     End If



End Sub

Private Sub btnEnumPrinterFonts_Click()
    Dim FontList As String
    Dim FontName As String
    Dim i, iPOs As Integer
    Dim lRet As Long
        
    Screen.MousePointer = 11
    
    lstPrinterFonts.Clear
     
    lRet = iPowerPrn.EnumPrinterFonts(FontList)
    
    If lRet > 0 Then
        ' fonts are separated by semicolumn
        iPOs = InStr(FontList, "")
        While iPOs > 0
            ' get name
            FontName = Left(FontList, iPOs - 1)
            ' add it to the list box
            lstPrinterFonts.AddItem FontName
            ' get next one
            FontList = Right(FontList, Len(FontList) - iPOs)
            iPOs = InStr(FontList, "")
        Wend
    Else
        MsgBox ("Cannot enumerate printer fonts !")
    End If
    
    Screen.MousePointer = 0
End Sub

Private Sub btnSetFont_Click()
    Dim sFont As String
    Dim iPoint, iBold, iItalic, iUnderline, iStrike As Integer
    Dim TheMessage As String
   
    TheMessage = "PowerPrinter is great !"
    Screen.MousePointer = 11
    
    If lstPrinterFonts.ListCount() > 0 Then
    
        sFont = lstPrinterFonts.List(lstPrinterFonts.ListIndex)
        
        If sFont <> "" Then
                
            iPoint = 15 ' still working on it. not used
            iBold = 0 ' 1 = bold
            iItalic = 0 ' 1 = italic
            iUnderline = 0 ' 1 = underline
            iStrike = 0 ' 1 = striketrough
            
            If iPowerPrn.SetPrinterFont(Printer.hDC, sFont, iPoint, iBold, iItalic, iUnderline, iStrike) > 0 Then
                Printer.Print TheMessage
                Printer.EndDoc
                MsgBox ("Set printer font succeeded")
            Else
                MsgBox ("Set printer font failed")
            End If
        Else
            MsgBox ("No fonts to choose from. Please select one")
        End If
    Else
        MsgBox ("No fonts to choose from")
    End If
    
    Screen.MousePointer = 0
End Sub

   


Private Sub cbPrint_Click()

    Dim iPrintOption As Long
    Dim JobName As String
    Dim lRet As Long
    
    If cbBestFit.Value = True Then
        iPrintOption = 119
    Else
        iPrintOption = 120 ' strecth to page
    End If
    
    JobName = "This si the job name argument"
    lRet = iPowerPrn.PrintTheDIB(iPrintOption, JobName)
    If lRet < 1 Then
        MsgBox ("Could not print. Did you capture an image ?")
    Else
        MsgBox ("Print successful")
    End If
End Sub

Private Sub cbSetPrinterAccess_Click()

    Dim lRet As Long
    Dim lAccess As Long
    
    lAccess = cmbPrinterAccess.ItemData(cmbPrinterAccess.ListIndex)
    
    lRet = iPowerPrn.SetPrinterAccess(lAccess)
    
    If lRet < 1 Then
        MsgBox ("SetPrinterAccess failed !")
    Else
        MsgBox ("SetPrinterAccess succeded !")
    End If
End Sub

Private Sub cbTestMore_Click()
    Dim sFont As String
    Dim iPoint, iBold, iItalic, iUnderline, iStrike As Integer
    Dim i As Integer
    Dim TheMessage As String
   
    TheMessage = "PowerPrinter is great !"
    Screen.MousePointer = 11
    
    If lstPrinterFonts.ListCount() > 0 Then
    
        For i = 1 To lstPrinterFonts.ListCount
            sFont = lstPrinterFonts.List(i)
                       
            iPoint = 15 ' still working on it. not used
            iBold = 0 ' 1 = bold
            iItalic = 0 ' 1 = italic
            iUnderline = 0 ' 1 = underline
            iStrike = 0 ' 1 = striketrough
            
            If iPowerPrn.SetPrinterFont(Printer.hDC, sFont, iPoint, iBold, iItalic, iUnderline, iStrike) > 0 Then
                Printer.Print TheMessage
            End If
        Next i
        Printer.EndDoc
    Else
        MsgBox ("No fonts to choose from")
    End If
    
    Screen.MousePointer = 0

End Sub

Private Sub cmdAbout_Click()
    iPowerPrn.About
End Sub

Private Sub cmdCaptureDesktop_Click()

    Dim lRet As Long
    
    lRet = iPowerPrn.CaptureDesktop()
    If lRet < 1 Then
        MsgBox ("Could not capture image.")
    Else
        MsgBox ("Image captured.")
    End If

End Sub

Private Sub cmdGetBin_Click()

    Dim iSource As Integer
    Dim ret As Long
    
    Screen.MousePointer = 11
    
    ret = iPowerPrn.GetPaperSource(iSource)
    
    Screen.MousePointer = 0
    
    If ret > 0 Then
    
        MsgBox ("Paper Bin: " + Str(iSource))
    Else
        MsgBox ("Coud not fetch Paper Bin")
    End If

End Sub

Private Sub cmdGetList_Click()

    Dim lsBinList, lsBinName As String
    Dim iPOs As Integer
    
    lb_Bins.Clear
    
    If optDefault.Value = True Then
        lsBinList = iPowerPrn.GetPaperBinList()
    Else
        lsBinList = iPowerPrn.GetNamedPaperBinList()
    End If
    
    iPOs = InStr(lsBinList, "")
    
    While iPOs > 0
         ' get name
         lsBinName = Left(lsBinList, iPOs - 1)
         
         ' add it to the list box
         lb_Bins.AddItem lsBinName
         
         ' get next one
         lsBinList = Right(lsBinList, Len(lsBinList) - iPOs)
        iPOs = InStr(lsBinList, "")
        Wend
    
End Sub

Private Sub cmdGetPaperSize_Click()
    Dim iSize As Integer
    Dim ret As Long
    
    Screen.MousePointer = 11
    
    ret = iPowerPrn.GetPaperSize(iSize)
    
    Screen.MousePointer = 0
    
    If ret > 0 Then
    
        MsgBox ("Paper Size: " + Str(iSize))
    Else
        MsgBox ("Coud not fetch Paper Size")
    End If
End Sub

Private Sub cmdGetPaperSizeList_Click()
    Dim lsPaperSizeList, lsPaperName As String
    Dim iPOs As Integer
    
    lb_papersize.Clear
    
    lsPaperSizeList = iPowerPrn.GetPaperSizeList()
    
    iPOs = InStr(lsPaperSizeList, "")
    
    While iPOs > 0
         ' get name
         lsPaperName = Left(lsPaperSizeList, iPOs - 1)
         
         ' add it to the list box
         lb_papersize.AddItem lsPaperName
         
         ' get next one
         lsPaperSizeList = Right(lsPaperSizeList, Len(lsPaperSizeList) - iPOs)
        iPOs = InStr(lsPaperSizeList, "")
        Wend
    
End Sub

Private Sub cmdSetBin_Click()

    Dim iSource As Integer
    Dim sBin As String
    
    Screen.MousePointer = 11
    
    If lb_Bins.ListCount() > 0 Then
    
        sBin = lb_Bins.List(lb_Bins.ListIndex)
        
        If sBin <> "" Then
            iSource = CInt(Left(sBin, InStr(sBin, " ")))
            
            
            If iPowerPrn.SetDefaultSource(iSource) > 0 Then
                MsgBox ("Set Paper Bin succeeded")
            Else
                MsgBox ("Set Paper Bin failed")
            End If
        Else
            MsgBox ("No Paper Bin to choose from. Please select one")
        End If
    Else
        MsgBox ("No Paper Bin to choose from")
    End If
    
    Screen.MousePointer = 0
    
End Sub

Private Sub cmdSetPaperSize_Click()
    
    Dim iSize As Integer
    Dim sSize As String
    
    Screen.MousePointer = 11
    
    If lb_papersize.ListCount() > 0 Then
    
        sSize = lb_papersize.List(lb_papersize.ListIndex)
        
        If sSize <> "" Then
            iSize = CInt(Left(sSize, InStr(sSize, " ")))
                        
            If iPowerPrn.SetPaperSize(iSize) > 0 Then
                MsgBox ("Set Paper Size succeeded")
            Else
                MsgBox ("Set Paper Size failed")
            End If
        Else
            MsgBox ("No Paper Size to choose from. Please select one")
        End If
    Else
        MsgBox ("No Paper Size to choose from")
    End If
    
    Screen.MousePointer = 0
End Sub

Private Sub cmdUnlock_Click()

    Dim RegUser As String
    Dim lKey As Long
    Dim ret As Long
    
    RegUser = eUserName.Text

    If eKey.Text <> "" And IsNumeric(eKey.Text) Then
        lKey = CLng(eKey.Text)

        ret = iPowerPrn.UnlockDLL(RegUser, lKey)
    Else
        MsgBox ("Please provide a numeric key")
    End If
End Sub



Private Sub Command1_Click()
    Unload Me
    End
End Sub






Private Sub Command2_Click()
    Dim ExtErrMsg As String
    
    ExtErrMsg = iPowerPrn.GetExtendedErrorMessage()
    
    MsgBox (ExtErrMsg)
End Sub



Private Sub Command3_Click()
    MsgBox ("Printer access is :" + Str(iPowerPrn.GetPrinterAccess()))
End Sub

Private Sub Command4_Click()

    Dim iCaptureOption As Long
    Dim lRet As Long
    
    If cbentirewindow.Value = True Then
        iCaptureOption = 1
    Else
        iCaptureOption = 2
    End If
    
    lRet = iPowerPrn.CaptureWindow(Form1.hWnd, iCaptureOption)
    If lRet < 1 Then
        MsgBox ("Could not capture image.")
    Else
        MsgBox ("Image captured.")
    End If
End Sub



Private Sub Form_Load()
  
    Dim iOrient As Integer
    Dim lRet As Long
    
    App.HelpFile = "powerprn.hlp"
    
    ' get default printer attributes
    tb_prnname.Text = iPowerPrn.GetDefaultPrinterName()
    tb_driver.Text = iPowerPrn.GetDefaultPrinterDriver()
    tb_port.Text = iPowerPrn.GetDefaultPrinterPort()
    
    ' orientation
    ' get as integer
    lRet = iPowerPrn.GetPrinterOrientation(iOrient)
    If lRet > 0 Then
        lbl_orientation.Caption = CStr(iOrient)
    Else
        lbl_orientation.Caption = "Cannot get Printer Orientation"
    End If

    ' now get it as a string and override previous operation
    ' this not needed: just show both techniques
    Dim PrnOrient As String
    lRet = iPowerPrn.GetPrinterOrientationString(PrnOrient)
    
    ' start with default printer
    txtEnumJobsPrnName.Text = tb_prnname.Text
    txtEnumDriversPrnName.Text = tb_prnname.Text
    
    lbl_orientation.Caption = PrnOrient
    
      cmbPrinterAccess.AddItem ("PRINTER_ALL_ACCESS")
      cmbPrinterAccess.ItemData(cmbPrinterAccess.NewIndex) = PRINTER_ALL_ACCESS
      
      cmbPrinterAccess.AddItem ("PRINTER_ACCESS_USE")
      cmbPrinterAccess.ItemData(cmbPrinterAccess.NewIndex) = PRINTER_ACCESS_USE
      
      cmbPrinterAccess.AddItem ("PRINTER_READ")
      cmbPrinterAccess.ItemData(cmbPrinterAccess.NewIndex) = PRINTER_READ
      
      cmbPrinterAccess.AddItem ("PRINTER_WRITE")
      cmbPrinterAccess.ItemData(cmbPrinterAccess.NewIndex) = PRINTER_WRITE
      
      cmbPrinterAccess.AddItem ("PRINTER_EXECUTE")
      cmbPrinterAccess.ItemData(cmbPrinterAccess.NewIndex) = PRINTER_EXECUTE
      
      cmbPrinterAccess.Text = "PRINTER_ALL_ACCESS"
      cmbPrinterAccess.ItemData(cmbPrinterAccess.NewIndex) = PRINTER_ALL_ACCESS
End Sub


Private Sub lb_printerlist_DblClick()
    
    Dim Ind As Integer
    Dim lRet As Long
    Dim DefPrinter As String
    
    Screen.MousePointer = 11    ' Change mouse pointer to hourglass
    

    Ind = lb_printerlist.ListIndex                   ' Get index.
    If Ind >= 0 Then                                ' Make sure a list item is selected.
        DefPrinter = lb_printerlist.List(Ind)
        lRet = iPowerPrn.SetDefaultPrinter(DefPrinter)
        If lRet > 0 Then
            ' update display
            tb_prnname.Text = iPowerPrn.GetDefaultPrinterName()
            tb_driver.Text = iPowerPrn.GetDefaultPrinterDriver()
            tb_port.Text = iPowerPrn.GetDefaultPrinterPort()
        Else
            MsgBox ("Could not set default printer")
        End If
    End If
    
    Screen.MousePointer = 0    ' Change mouse pointer to default
End Sub





Private Sub optDefault_Click()
    cmdGetList_Click
End Sub


Private Sub optNamed_Click()
    cmdGetList_Click
End Sub





Private Sub txtAddDriverAdd_Click()

    Dim lRet As Long
    Dim dVersion As Long
    
    dVersion = Int(txtAddDriverVersion.Text)
    
    lRet = iPowerPrn.AddPrinterDriver(txtAddDriverServerName.Text, txtAddDriverPrinterName.Text, txtAddDriverEnvironment.Text, txtAddDriverPath.Text, txtAddDriverDataFile.Text, txtAddDriverConfigFile.Text, dVersion)
        
    If lRet < 1 Then
        MsgBox ("AddPrinterDriver failed !. Please check out the extended errors tab page.")
    Else
        MsgBox ("AddPrinterDriver succeeded")
    End If
End Sub


Private Sub txtAddDriverDelete_Click()
    Dim llRet As Long
    
    llRet = iPowerPrn.DeletePrinterDriver(txtAddDriverServerName.Text, txtAddDriverEnvironment.Text, txtAddDriverPrinterName.Text)
        
    If llRet < 1 Then
        MsgBox ("DelPrinterDriver failed !. Please check out the extended errors tab page.")
    Else
        MsgBox ("DelPrinterDriver succeeded")
    End If

End Sub

Private Sub txtAddDriverGet_Click()
   
   Dim PrnName As String
   Dim ServerName As String, DriverName As String, Environment As String, DriverPath As String, DataFile As String, ConfigFile As String
   Dim Version As String
   Dim lRet As Long

   PrnName = tb_prnname.Text
   
   lRet = iPowerPrn.GetPrinterDriver(PrnName, DriverName, ServerName, Environment, DriverPath, DataFile, ConfigFile, Version)
   
   If lRet = 1 Then
        txtAddDriverPrinterName.Text = DriverName
        txtAddDriverVersion.Text = Version
        txtAddDriverEnvironment.Text = Environment
        txtAddDriverPath.Text = DriverPath
        txtAddDriverDataFile.Text = DataFile
        txtAddDriverConfigFile.Text = ConfigFile
     End If
  
End Sub


