#if !defined(__adodialog_h)
#define __adodialog_h

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "AdoWindow.h"

// AdoDialog.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CAdoDialog


class CAdoDialog : public CDialog, public AdoWindow {
	CString caption;
protected:
	bool cont;
		//Attribute for controlling survival of the object after an
		//OnOK event. Useful for continued data entry.
	bool child;
		//This condition is true if the object was created with the child
		//creation constructor.
public:
	CAdoDialog(UINT i, CWnd* p = 0, LPCSTR s = 0, bool a = false);
		//Normal constructor
	CAdoDialog(UINT i, AdoRecordset& r, CWnd* p = 0, bool a = false);
		//Child creation constructor
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAdoDialog)
	public:
	virtual void OnOK();
	//}}AFX_VIRTUAL

	void SetCaption(LPCTSTR str);
	bool Execute();
	LPCSTR TableName() = 0;
	// Generated message map functions
protected:
	void SetModify(int Id, bool mod = true)
     	{SendDlgItemMessage(Id, EM_SETMODIFY, mod);}
		//Helper function for edit controls
	void SetDlgItemText(int nID, LPCTSTR lpszString);
		//Override of the CWnd function. It sets the modify flag in edit controls.
	//{{AFX_MSG(CAdoDialog)
	virtual void OnModificar();		//Manages enabling of controls
	virtual void OnEnter();			//Moves focus among controls
	virtual BOOL OnInitDialog();	
	virtual void DoDataExchange(CDataExchange* pDX) = 0;    // DDX/DDV support
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif
