/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;

public class DCheckbox
extends Component
implements ItemSelectable {
    protected String label;
    protected boolean state = false;
    protected ItemListener itemListener;
    static final boolean CLEARED = false;
    static final boolean CHECKED = true;
    static final int LEFT = 0;
    static final int RIGHT = 1;
    public int position;
    static final int BEVEL_NONE = 0;
    static final int BEVEL_LINE = 1;
    static final int BEVEL_RAISED = 2;
    static final int BEVEL_LOWERED = 3;
    public int border;
    int BORDER_X = 0;
    int BORDER_Y = 0;
    int checksize = 16;

    public DCheckbox() {
        this("", false);
    }

    public DCheckbox(String string) {
        this(string, false);
    }

    public DCheckbox(String string, boolean bl) {
        this.enableEvents(16L);
        this.label = string;
        this.state = bl;
        this.border = 0;
        this.position = 0;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    public void setBevel(int n) {
        this.border = n;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.adjustSize();
        int n = dimension.width;
        int n2 = dimension.height;
        int n3 = dimension2.width;
        int n4 = dimension2.height;
        if (n3 > n || n4 > n2) {
            return dimension2;
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public synchronized void setLabel(String string) {
        this.label = string;
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    public void setState(boolean bl) {
        this.state = bl;
        this.repaint();
    }

    public boolean getState() {
        return this.state;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    protected Dimension adjustSize() {
        int n = this.checksize + this.BORDER_X * 2;
        int n2 = this.checksize + this.BORDER_Y * 2;
        int n3 = 0;
        int n4 = 0;
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (this.label != null) {
                n4 = fontMetrics.getHeight();
                if (n4 > n2) {
                    this.BORDER_Y = n4 - n2;
                    this.BORDER_Y = (this.BORDER_Y + 1) / 2;
                } else if (this.checksize > n4) {
                    n4 = this.checksize;
                }
                n3 = 8 + fontMetrics.stringWidth(this.label) + this.BORDER_X * 2;
            }
        }
        if (n4 > n2) {
            n2 = n4;
        }
        return new Dimension(n + n3, n2);
    }

    public void addNotify() {
        super.addNotify();
        this.setSize(this.getPreferredSize());
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        Color color = this.getBackground();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        if (this.border > 0) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, n4, n5);
        }
        if (this.border == 1) {
            graphics.setColor(this.getForeground());
            graphics.drawRect(0, 0, n4 - 1, n5 - 1);
        } else if (this.border == 2) {
            graphics.setColor(color2);
            graphics.drawLine(0, 0, n4 - 1, 0);
            graphics.drawLine(0, 1, 0, n5 - 1);
            graphics.setColor(color3);
            graphics.drawLine(1, n5 - 1, n4 - 1, n5 - 1);
            graphics.drawLine(2, n5 - 2, n4 - 2, n5 - 2);
            graphics.drawLine(n4 - 1, 1, n4 - 1, n5 - 1);
        } else if (this.border == 3) {
            graphics.setColor(color3);
            graphics.drawLine(0, 0, n4 - 1, 0);
            graphics.drawLine(0, 1, 0, n5 - 1);
            graphics.setColor(color2);
            graphics.drawLine(1, n5 - 1, n4 - 1, n5 - 1);
            graphics.drawLine(2, n5 - 2, n4 - 2, n5 - 2);
            graphics.drawLine(n4 - 1, 1, n4 - 1, n5 - 1);
        }
        if (this.position == 0) {
            n3 = this.BORDER_X;
            n2 = this.checksize + this.BORDER_X * 3 + 6;
        } else {
            n3 = n4 - (this.checksize + this.BORDER_X * 2) - 1;
            n2 = 6;
        }
        int n6 = n3 + this.checksize - 1;
        int n7 = this.BORDER_Y + this.checksize - 1;
        graphics.setColor(color3);
        graphics.drawLine(n3, this.BORDER_Y, n6, this.BORDER_Y);
        graphics.drawLine(n3, this.BORDER_Y, n3, n7);
        graphics.drawLine(n3 + 1, this.BORDER_Y + 1, n6 - 1, this.BORDER_Y + 1);
        graphics.drawLine(n3 + 1, this.BORDER_Y + 2, n3 + 1, n7 - 1);
        graphics.setColor(color2);
        graphics.drawLine(n6, this.BORDER_Y, n6, n7);
        graphics.drawLine(n3, n7, n6, n7);
        graphics.setColor(color3);
        graphics.drawLine(n6 - 1, this.BORDER_Y + 1, n6 - 1, n7 - 1);
        graphics.drawLine(n3 + 1, n7 - 1, n6 - 1, n7 - 1);
        graphics.setColor(color2);
        graphics.fillRect(n3 + 2, this.BORDER_Y + 2, this.checksize - 4, this.checksize - 4);
        if (this.state) {
            int n8 = n3 + 4;
            n = this.BORDER_Y + 4;
            int n9 = n8 + this.checksize - 10;
            int n10 = n + this.checksize - 9;
            graphics.setColor(Color.black);
            graphics.drawLine(n8, n, n9, n10);
            graphics.drawLine(n8, n10, n9, n);
            graphics.drawLine(n8 + 1, n, n9 + 1, n10);
            graphics.drawLine(n8 + 1, n10, n9 + 1, n);
        }
        if (this.label != null && this.label.length() > 0) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (this.position == 1) {
                n2 = n3 - fontMetrics.stringWidth(this.label);
            }
            n = this.BORDER_Y + 14;
            if (this.isEnabled()) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(Color.gray);
            }
            graphics.drawString(this.label, n2, n);
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501 && this.isEnabled()) {
            boolean bl = this.state = !this.state;
            if (this.itemListener != null) {
                int n = this.state ? 1 : 2;
                this.itemListener.itemStateChanged(new ItemEvent(this, 701, this.label, n));
            }
            this.repaint();
        }
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray = new Object[]{this};
        return objectArray;
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }
}

