/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class DLabel
extends Component {
    public static final int BEVEL_LOWERED = 3;
    public static final int BEVEL_RAISED = 2;
    public static final int BEVEL_LINE = 1;
    public static final int BEVEL_NONE = 0;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    protected String sLabel;
    protected int alignStyle;
    protected int bevelStyle;
    protected Color textColor;
    protected Color borderColor;
    protected Color hilightColor;
    protected Color shadowColor;
    protected Color cachedBackground = null;
    private transient FontMetrics _$6615;
    private transient int _$20387;
    private transient int _$20373;

    public DLabel() {
        this("", 0, 0, Color.black);
    }

    public DLabel(int n) {
        this("", n, 0, Color.black);
    }

    public DLabel(String string) {
        this(string, 0, 0, Color.black);
    }

    public DLabel(String string, int n) {
        this(string, n, 0, Color.black);
    }

    public DLabel(String string, int n, int n2) {
        this(string, n, n2, Color.black);
    }

    public DLabel(String string, int n, int n2, Color color) {
        this.sLabel = string;
        this.textColor = color;
        this.borderColor = Color.black;
        this.cachedBackground = this.getBackground();
        this.alignStyle = n2;
        this.bevelStyle = n;
    }

    public void setAlignment(int n) {
        this.alignStyle = n;
        this.repaint();
    }

    public void setBevel(int n) {
        this.bevelStyle = n;
        this.repaint();
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public void setText(String string) {
        this.sLabel = string;
        this.repaint();
    }

    public String getText() {
        return this.sLabel;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public void setStyle(Style style) {
        this.setFont(style.font);
        this.setBackground(style.background);
        this.textColor = style.foreground;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Color color;
        Color color2;
        Color color3 = this.getBackground();
        if (!Tool.objectsEqual(color3, this.cachedBackground)) {
            this.cachedBackground = color3;
            this.hilightColor = Effect.hilight(color3);
            this.shadowColor = Effect.shadow(color3);
        }
        Rectangle rectangle = this.getBounds();
        graphics.setFont(this.getFont());
        switch (this.bevelStyle) {
            case 3: {
                color2 = this.shadowColor;
                color = this.hilightColor;
                break;
            }
            case 2: {
                color2 = this.hilightColor;
                color = this.shadowColor;
                break;
            }
            case 1: {
                color2 = this.borderColor;
                color = this.borderColor;
                break;
            }
            default: {
                color = null;
                color2 = null;
            }
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        if (color2 != null) {
            graphics.setColor(color2);
            graphics.drawLine(0, 0, rectangle.width - 1, 0);
            graphics.setColor(color);
            graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
            graphics.setColor(color2);
            graphics.drawLine(0, 0, 0, rectangle.height - 1);
            graphics.setColor(color);
            graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
        }
        graphics.setColor(this.textColor);
        this._$6615 = this.getFontMetrics(graphics.getFont());
        this._$20373 = (rectangle.height - 1 + this._$6615.getAscent()) / 2;
        switch (this.alignStyle) {
            default: {
                if (this.bevelStyle == 1) {
                    graphics.drawString(this.sLabel, 4, this._$20373);
                    break;
                }
                graphics.drawString(this.sLabel, 8, this._$20373);
                break;
            }
            case 2: {
                this._$20387 = rectangle.width - this._$6615.stringWidth(this.sLabel);
                if (this.bevelStyle == 1) {
                    graphics.drawString(this.sLabel, this._$20387 - 6, this._$20373);
                    break;
                }
                graphics.drawString(this.sLabel, this._$20387 - 10, this._$20373);
                break;
            }
            case 1: {
                this._$20387 = (rectangle.width - this._$6615.stringWidth(this.sLabel)) / 2;
                graphics.drawString(this.sLabel, this._$20387, this._$20373);
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(16, 8);
        Font font = this.getFont();
        if (font != null) {
            this._$6615 = this.getFontMetrics(font);
            dimension.width = this._$6615.stringWidth(this.sLabel) + 16;
            dimension.height = this._$6615.getHeight() + 8;
        }
        return dimension;
    }
}

