/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;

public class ImageViewer
extends Panel
implements MouseListener {
    public static final int NORMAL = 0;
    public static final int TEXTURE = 1;
    public static final int CENTERED = 2;
    public static final int TILED = 4;
    protected int imageStyle = 2;
    public static final int NONE = 0;
    public static final int SCALED = 2;
    public int scaleMode = 0;
    public boolean newSize = false;
    Dimension oldSize = new Dimension(0, 0);
    Dimension dim;
    int originW;
    int originH;
    int imageW;
    int imageH;
    public transient Image image = null;
    protected String fileName = null;
    protected URL url = null;
    String name = null;
    protected transient Image model;
    protected transient Image oldModel;
    ActionListener imgAL;

    public ImageViewer() {
        this.addMouseListener(this);
    }

    public ImageViewer(String string) {
        this();
        this.setImage(string);
    }

    public ImageViewer(URL uRL) {
        this();
        this.setURL(uRL);
    }

    public ImageViewer(Image image) {
        this();
        this.setImage(image);
    }

    void error(String string) {
        System.out.println(string);
    }

    public void nameIt(String string) {
        this.name = string;
    }

    public void setStyle(int n) {
        this.imageStyle = n;
    }

    public void setScaleMode(int n) {
        this.scaleMode = n;
    }

    public Dimension getDimension() {
        return new Dimension(this.imageW, this.imageH);
    }

    public int getStyle() {
        return this.imageStyle;
    }

    public Image getImage() {
        return this.image;
    }

    public Image getModel() {
        return this.model;
    }

    public Image loadImage(String string) {
        return this.loadImage(this.getToolkit().getImage(string));
    }

    public Image loadImage(Image image) {
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
            Image image2 = image;
            return image2;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public void setModel(Image image) {
        this.oldModel = this.model = this.loadImage(image);
        this.imageW = this.model.getWidth(this);
        this.imageH = this.model.getHeight(this);
        this.originW = this.imageW;
        this.originH = this.imageH;
    }

    public void setModel(String string) {
        this.fileName = string;
        this.setModel(this.getToolkit().getImage(string));
    }

    public static Image resize(Image image, int n, int n2, int n3, int n4) {
        int n5 = n4;
        int n6 = (int)((float)n * (float)n4 / (float)n2);
        if (n6 > n3) {
            n6 = n3;
            n5 = (int)((float)n2 * (float)n3 / (float)n);
        }
        return image.getScaledInstance(n6, n5, 1);
    }

    public Image resize(Image image) {
        int n;
        int n2 = this.getWidth();
        this.imageH = n = this.getHeight();
        this.imageW = (int)((float)this.originW * (float)n / (float)this.originH);
        if (this.imageW > n2) {
            this.imageW = n2;
            this.imageH = (int)((float)this.originH * (float)n2 / (float)this.originW);
        }
        return image.getScaledInstance(this.imageW, this.imageH, 1);
    }

    boolean scaleNeeded() {
        return this.originW >= this.getWidth() || this.originH >= this.getHeight();
    }

    public void setImage(String string) {
        this.setModel(string);
        this.image = this.scaleNeeded() ? this.resize(this.model) : this.model;
    }

    public void setImage(Image image) {
        this.setModel(image);
        this.image = this.scaleNeeded() ? this.resize(this.model) : this.model;
        this.fileName = null;
    }

    public void setImage(String string, int n) {
        this.scaleMode = n;
        this.setModel(string);
        switch (n) {
            case 2: {
                this.image = this.resize(this.model);
                this.imageStyle = 2;
            }
        }
        this.image = this.model;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setURL(URL uRL) {
        Image image = null;
        this.url = uRL;
        this.fileName = null;
        if (this.url != null) {
            image = this.getToolkit().getImage(this.url);
        }
        this.setImage(image);
        this.repaint();
    }

    public URL getURL() {
        return this.url;
    }

    public void clear() {
        Graphics graphics = this.getGraphics();
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.dim = this.getSize();
        int n = this.dim.width;
        int n2 = this.dim.height;
        if (this.imageW + this.imageH < 512) {
            graphics.clearRect(0, 0, n, n2);
        }
        if (this.image == null) {
            return;
        }
        if (this.model != null) {
            this.newSize = !this.model.equals(this.oldModel) || !this.oldSize.equals(this.dim);
        }
        switch (this.imageStyle) {
            default: {
                if (this.scaleMode == 2) {
                    if (this.newSize) {
                        this.image = this.resize(this.model);
                    }
                } else if (this.newSize) {
                    if (this.originW >= n || this.originH >= n2) {
                        this.image = this.resize(this.model);
                    } else if (this.imageW != this.originW || this.imageH != this.originH) {
                        this.image = this.model;
                        this.imageW = this.originW;
                        this.imageH = this.originH;
                    }
                }
                int n3 = (n - this.imageW) / 2;
                int n4 = (n2 - this.imageH) / 2;
                graphics.drawImage(this.image, n3, n4, this.imageW, this.imageH, this);
                break;
            }
            case 4: {
                int n5 = n / this.imageW;
                if (n % this.imageW != 0) {
                    ++n5;
                }
                int n6 = n2 / this.imageH;
                if (n2 % this.imageH != 0) {
                    ++n6;
                }
                int n7 = 0;
                for (int i = 0; i < n6; ++i) {
                    int n8 = 0;
                    for (int j = 0; j < n5; ++j) {
                        graphics.drawImage(this.image, n8, n7, this.imageW, this.imageH, this);
                        n8 += this.imageW;
                    }
                    n7 += this.imageH;
                }
                break;
            }
            case 1: {
                graphics.drawImage(this.image, 0, 0, n, n2, this);
                break;
            }
            case 0: {
                graphics.drawImage(this.image, 0, 0, this);
            }
        }
        this.oldSize = this.dim;
    }

    public Dimension getPreferredSize() {
        if (this.image != null) {
            return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        }
        return new Dimension(10, 10);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void addActionListener(ActionListener actionListener) {
        this.imgAL = AWTEventMulticaster.add(this.imgAL, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.imgAL = AWTEventMulticaster.remove(this.imgAL, actionListener);
    }

    public void sendAction(String string) {
        if (this.imgAL != null) {
            this.imgAL.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    protected void sendResizeEvent() {
        this.sendAction("Resized");
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.sendAction("full");
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }
}

