/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

class Thumbnail
extends Component {
    boolean bBorder;
    boolean bName;
    boolean bSize;
    boolean bType;
    int imageWidth = Preferences.ThumbWidth;
    int imageHeight;
    int cellWidth = Preferences.ThumbCell;
    int width;
    int height;
    int rowSize;
    int nRows;
    int count;
    String[] names;
    long[] sizes;
    FileWriter fw;
    BufferedWriter bw;
    static int iBorder = 2;
    static String g = "\"";
    static String htmlFile = "";
    static String htmlName = "";
    static String htmlDir = "";

    public Thumbnail(Dimension dimension) {
        this.bBorder = Preferences.ThumbBorder;
        this.bName = Preferences.ThumbName;
        this.bSize = Preferences.ThumbSize;
        this.bType = Preferences.ThumbType;
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public Thumbnail(Dimension dimension, String string, String[] stringArray, long[] lArray) {
        this(dimension);
        this.setList(string, stringArray, lArray);
    }

    public void setList(String string, String[] stringArray, long[] lArray) {
        this.names = stringArray;
        this.sizes = lArray;
        this.count = stringArray.length;
    }

    public Thumbnail(Dimension dimension, DirBox dirBox, int n, String string) {
        this(dimension);
        if (dirBox.isSelected() || dirBox.isTagged()) {
            this.setList(string, dirBox.getSelectedItems(), dirBox.getSelectedSizes());
            return;
        }
        int n2 = dirBox.items.size();
        int n3 = 0;
        VectorString vectorString = new VectorString();
        VectorLong vectorLong = new VectorLong();
        for (int i = n; i < n2; ++i) {
            String string2;
            ListItem listItem = (ListItem)dirBox.items.elementAt(i);
            String string3 = listItem.sText;
            if (new File(string, string3).isDirectory() || !(string2 = Path.getExtension(string3)).equalsIgnoreCase("gif") && !string2.equalsIgnoreCase("jpg") && !string2.equalsIgnoreCase("bmp") && !string2.equalsIgnoreCase("xbm") && !string2.equalsIgnoreCase("png")) continue;
            vectorString.addElement(string3);
            vectorLong.addElement(dirBox.VSize.elementAt(i));
            ++n3;
        }
        if (n3 > 0) {
            this.names = new String[n3];
            vectorString.copyInto(this.names);
            this.sizes = new long[n3];
            vectorLong.copyInto(this.sizes);
            this.count = this.names.length;
        }
    }

    public static void setFile(String string, String string2) {
        htmlFile = Path.merge(string, string2);
        htmlDir = string;
        htmlName = string2;
    }

    String getFile() {
        return htmlFile;
    }

    private void _$6696(String string) {
        try {
            this.bw.write(string, 0, string.length());
            this.bw.newLine();
        }
        catch (IOException iOException) {
            System.out.println("Enable to write ".concat(String.valueOf(string)));
        }
    }

    public void resize(Image image) {
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        this.imageHeight = (int)((float)n2 * (float)this.imageWidth / (float)n);
    }

    public void resize(String string) {
        if (new File(string).isDirectory()) {
            return;
        }
        this.resize(this.getToolkit().getImage(string));
    }

    public void createTD(int n) {
        this.resize(this.names[n]);
        this._$6696(String.valueOf(new StringBuffer("<TD width=").append(g).append(this.cellWidth).append(g).append("><br>")));
        if (this.bBorder) {
            this._$6696(String.valueOf(new StringBuffer("<TABLE border =").append(g).append(iBorder).append(g).append("> <TD>")));
        }
        this._$6696(String.valueOf(new StringBuffer("<A HREF=").append(g).append(this.names[n]).append(g).append("> <IMG SRC=").append(g).append(this.names[n]).append(g).append(" WIDTH=").append(g).append(this.imageWidth).append(g).append(" HEIGHT=").append(g).append(this.imageHeight).append(g).append(" BORDER=").append(g).append("0").append(g).append("> </A>")));
        if (this.bBorder) {
            this._$6696("</TD></TABLE>");
        }
        this._$6696("</TD>");
    }

    public void createTDLabel(int n) {
        try {
            int n2 = this.names[n].lastIndexOf(".");
            String string = this.names[n].substring(0, n2);
            this._$6696(String.valueOf(new StringBuffer("<TD width=").append(g).append(this.cellWidth).append(g).append(">")));
            if (this.bName) {
                this._$6696(String.valueOf(new StringBuffer("<FONT SIZE=").append(g).append("1").append(g).append(">")));
                this._$6696(String.valueOf(new StringBuffer("<b> ").append(string).append(" </b></FONT>")));
            }
            if (this.bType || this.bSize) {
                this._$6696(String.valueOf(new StringBuffer("<FONT SIZE=").append(g).append("-3").append(g).append(">")));
                if (this.bType) {
                    this._$6696("<br>".concat(String.valueOf(this.names[n].substring(n2 + 1))));
                }
                if (this.bSize) {
                    this._$6696("<br>".concat(String.valueOf(this.sizes[n])));
                }
                this._$6696("</FONT>");
            }
            this._$6696("</TD>");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void createTR(int n) {
        int n2;
        int n3;
        this._$6696(String.valueOf(new StringBuffer("<TR align=").append(g).append("center").append(g).append("> ")));
        for (n3 = 0; n3 < this.rowSize; ++n3) {
            n2 = n + n3;
            if (n2 >= this.count) continue;
            this.createTD(n2);
        }
        this._$6696("</TR>");
        this._$6696(String.valueOf(new StringBuffer("<TR align=").append(g).append("center").append(g).append("> ")));
        for (n3 = 0; n3 < this.rowSize; ++n3) {
            n2 = n + n3;
            if (n2 >= this.count) continue;
            this.createTDLabel(n2);
        }
        this._$6696("</TR>");
    }

    public int createHtml() {
        int n = 0;
        if (this.count == 0) {
            return 0;
        }
        this.rowSize = Math.max(1, (this.width - 40) / this.cellWidth);
        this.nRows = Math.max(1, (this.count + this.rowSize) / this.rowSize);
        System.gc();
        try {
            this.fw = new FileWriter(htmlFile);
            this.bw = new BufferedWriter(this.fw);
        }
        catch (IOException iOException) {
            System.out.println("Enable to make ".concat(String.valueOf(htmlFile)));
        }
        this._$6696("<HTML>");
        this._$6696("<HEAD>");
        this._$6696("<TITLE>Thumbnail</TITLE>");
        this._$6696(String.valueOf(new StringBuffer("<STYLE TYPE=").append(g).append("text/css").append(g).append(" MEDIA=screen >")));
        this._$6696("<!--");
        this._$6696(String.valueOf(new StringBuffer(" BODY { font-family: ").append(g).append("Courrier New").append(g).append(", Courrier, mono, Monospaced, Arial  }")));
        this._$6696("-->");
        this._$6696("</STYLE>");
        this._$6696("</HEAD>");
        if (Preferences.pageColor.equalsIgnoreCase("None")) {
            this._$6696("<BODY>");
        } else {
            this._$6696(String.valueOf(new StringBuffer("<BODY bgcolor=").append(Preferences.pageColor).append(">")));
        }
        this._$6696(String.valueOf(new StringBuffer("<TABLE CELLSPACING=").append(g).append("4").append(g).append(" CELLPADDING=").append(g).append("0").append(g).append(" BORDER=").append(g).append("0").append(g).append(" >")));
        for (int i = 0; i < this.nRows; ++i) {
            this.createTR(n);
            n += this.rowSize;
        }
        this._$6696("</TABLE>");
        this._$6696("</BODY>");
        this._$6696("</HTML>");
        try {
            this.bw.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this.count;
    }
}

