/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class TreeManager
extends Panel
implements ActionListener,
ComponentListener,
MouseListener {
    DMessageBar statusbar;
    Frame frame;
    DToolBar toolbar;
    TreeDir treeDir;
    DButton buttonMakeSrc;
    DButton buttonMakeDst;
    DButton buttonBuild;
    boolean started = false;
    transient ActionListener actionListener;

    public TreeManager(Frame frame, DMessageBar dMessageBar) {
        this.frame = frame;
        this.setLayout(new BorderLayout());
        this.setVisible(false);
        this.toolbar = new DToolBar();
        this.add((Component)this.toolbar, "North");
        this.treeDir = new TreeDir();
        this.treeDir.addActionListener(this);
        this.treeDir.addMouseListener(this);
        this.add((Component)this.treeDir, "Center");
        this.buttonMakeSrc = new DButton(Icons.Open, "Source");
        this.buttonMakeSrc.setSize(84, 24);
        this.buttonMakeSrc.setTip("Display selected dir in source window");
        this.buttonMakeSrc.addActionListener(this);
        this.toolbar.add(this.buttonMakeSrc);
        this.buttonMakeDst = new DButton(Icons.Open, "Target");
        this.buttonMakeDst.setSize(84, 24);
        this.buttonMakeDst.setTip("Use the selected dir as target");
        this.buttonMakeDst.addActionListener(this);
        this.toolbar.add(this.buttonMakeDst);
        this.buttonBuild = new DButton(Icons.Cancel, "Rebuild");
        this.buttonBuild.setSize(84, 24);
        this.buttonBuild.setTip("Reload the tree of dirs");
        this.buttonBuild.addActionListener(this);
        this.toolbar.add(this.buttonBuild);
        this.treeDir.setStyle(Preferences.TreeStyle);
    }

    public void init() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.treeDir.init();
    }

    public void setStyle(Style style) {
        this.treeDir.setStyle(style);
    }

    public void message(String string) {
        this.dispTip(string);
    }

    public void dispTip(String string) {
        if (this.statusbar != null) {
            this.statusbar.setText(" ".concat(String.valueOf(string)));
        }
    }

    public String getSelected() {
        return this.treeDir.getSelectedPath();
    }

    void rebuild() {
        this.dispTip("Rebuilding the tree");
        this.treeDir.clear();
        this.treeDir.init();
        this.treeDir.repaint();
        this.treeDir.requestFocus();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        int n = mouseEvent.getClickCount();
        if (n == 2) {
            this.sendAction("src");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        Object object = actionEvent.getSource();
        if (object == this.buttonMakeSrc) {
            this.sendAction("src");
        } else if (object == this.buttonMakeDst) {
            this.sendAction("dst");
        } else if (object == this.buttonBuild) {
            this.rebuild();
        } else if (object == this.treeDir && (string = actionEvent.getActionCommand()).equalsIgnoreCase("enter")) {
            this.sendAction("src");
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    void sendAction(String string) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
        if (this.treeDir.getViewCount() < 1) {
            this.treeDir.init();
        }
        this.requestFocus();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }
}

