VERSION 4.00
Begin VB.Form Form1
   Caption         =   "Simple animation in Visual Basic"
   ClientHeight    =   7185
   ClientLeft      =   1140
   ClientTop       =   1515
   ClientWidth     =   9600
   Height          =   7590
   Left            =   1080
   LinkTopic       =   "Form1"
   ScaleHeight     =   7185
   ScaleWidth      =   9600
   Top             =   1170
   Width           =   9720
   Begin VB.Timer Timer1
      Interval        =   40
      Left            =   120
      Top             =   120
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Dim Board As Long
Dim hwndBoard As Integer

Dim Sprite As Long

Dim DeltaX As Integer
Dim DeltaY As Integer

Private Sub Form_Load()
    ' create a board from an image
    Dim ImageName As String
    ImageName = CurDir + "\maze.bmp"
    Board = as_LoadBoard(ImageName, AS_MODE_PAL_COLORS, 0, 0)
    If Board = 0 Then
        MsgBox "Cannot create board (probable cause: image is not found)"
        Exit Sub
    End If

    ' create a window for the boatd
    hwndBoard = as_CreateBoardWindow(Board, "", 0, 0, 0, hWnd, 0)

    ' load a sprite and attach it to the board
    ImageName = CurDir + "\sprite1.bmp"
    Sprite = as_Load(ImageName, &HFF00FF, 0, 0)
    If Sprite = 0 Then
        MsgBox "Cannot load sprite (probable cause: image is not found)"
        Exit Sub
    End If
    as_Assign Sprite, Board, 1
    as_Show Sprite, 1

    ' draw the initial state
    as_PaintBoard 0, Board, 0, 0, 0

    ' set the initial direction of the sprite
    DeltaX = 6
    DeltaY = 4
End Sub


Private Sub Timer1_Timer()
    ' protection
    If Board = 0 Or Sprite = 0 Then
        Exit Sub
    End If

    ' move the sprite
    as_Move Sprite, DeltaX, DeltaY

    ' check whether the sprite touches an edge of the board
    ' NOTE: "box" is a handle (or pointer if you wish) to a
    '       rectangle inside the AniSprite DLL.
    Dim box As Long
    box = as_GetBoardData(Board, AS_DATA_BOX, 0)
    If as_InBox(Sprite, box) = 0 Then
        ' get the dimensions of the board
        Dim BoardWidth As Integer, BoardHeight As Integer
        BoardWidth = as_GetBoardValue(Board, AS_VALUE_WIDTH, 0)
        BoardHeight = as_GetBoardValue(Board, AS_VALUE_HEIGHT, 0)
        ' get the position and the dimension of the sprite
        Dim SpriteX As Long, SpriteY As Long
        Dim SpriteWidth As Integer, SpriteHeight As Integer
        as_GetPos Sprite, SpriteX, SpriteY
        SpriteWidth = as_GetValue(Sprite, AS_VALUE_WIDTH)
        SpriteHeight = as_GetValue(Sprite, AS_VALUE_HEIGHT)
        ' check the horizontal edges
        If SpriteX < 0 Or SpriteX + SpriteWidth > BoardWidth Then
            DeltaX = -DeltaX
        End If
        ' check the vertical edges
        If SpriteY < 0 Or SpriteY + SpriteHeight > BoardHeight Then
            DeltaY = -DeltaY
        End If
    End If

    as_PaintBoard 0, Board, 0, 0, 0
End Sub


