// Report.cpp: implementation of the Report class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"
#include "Report.h"
#include "ReportTask.h"
#include "ReportSummaryTask.h"

#define SUMMARY

//////////////////////////////////////////////////////////////////////
// Static Definitions
//////////////////////////////////////////////////////////////////////

static ReportTask report_task;

static ReportSummaryTask report_summary_task;

static const char* state_format[nPhilosopherState] = {
	"Thinking for %d milliseconds",
	"Waiting to grab forks",
	"Eating for %d milliseconds"};

//////////////////////////////////////////////////////////////////////
// Member Functions
//////////////////////////////////////////////////////////////////////

void Report::update_philosopher_state
		(PhilosopherId id, PhilosopherState state, Milliseconds time)
{
	char sender[32];
	char message[128];

	_snprintf(sender, 32, "Philosopher %1d", id);
	_snprintf(message, 128, state_format[state], time);
	print(sender, message);

	ReportSummaryTask::UpdateParams update_params;
	update_params.id = id;
	update_params.state = state;
	update_params.time = time;
	report_summary_task.update(update_params);
}

void Report::print(char* sender, char* message)
{
	report_task.print(sender, message);
}

void Report::wait_for_quit(int &exit_code)
{
	report_summary_task.end();
	report_task.quit(exit_code);
}

bool Report::end_flagged()
{
	return report_task.end_flag;
}

void Report::make_versioned_string
	(char* str_buf, size_t count, const char* format, HINSTANCE hInstance)
{
	char version[128];

	LoadString(hInstance, IDS_VERSION, version, 128);
	_snprintf(str_buf, count, format, version);
}

