// ReportTask.h: interface for the ReportTask class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_REPORTTASK_H__361BE023_8305_4F41_8DA6_6E94CD083E5E__INCLUDED_)
#define AFX_REPORTTASK_H__361BE023_8305_4F41_8DA6_6E94CD083E5E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <atask\Task.h>
#include <atask\Synchronization.h>
#include "WindowLog.h"
#include "AboutTask.h"

class ReportTask : public Task  
{
public:
	typedef char *SenderName;
	typedef char *MessageStr;
	typedef int ExitCode;

	Entry2<SenderName, MessageStr> print;
	Entry1<ExitCode> quit;
	MsgEntry msg_entry;

	bool volatile end_flag;

	ReportTask();
	~ReportTask();

protected:
	Priority priority();
	void body();
	size_t virtual_sizeof();
private:
	bool initialize_window(int cmdShow);
	void message_loop();
	void terminate_application();

	static LRESULT CALLBACK window_proc
		(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

	HINSTANCE hInstance;
	HWND hWnd;
	WindowLog *log_ptr;
	AboutTask *about_task_ptr;
	bool suspended;
	HMENU control_menu;

	class WindowClass;
};


#endif // !defined(AFX_REPORTTASK_H__361BE023_8305_4F41_8DA6_6E94CD083E5E__INCLUDED_)
