use perlchartdir;


sub main
{
	#The data for the area chart
	my $data = [25, 18, 9, 4, 5, 8, 14, 20, 40, 92, 75, 88, 75, 
		58, 90, 95, 83, 75, 70, 66, 46, 38, 28, 15, 22];

	#The labels for the area chart
	my $labels = ["0", "", "", "3", "", "", "6", "", "", "9", "", "", 
		"12", "", "", "15", "", "", "18", "", "", "21", "", "", "24"];
	
	#First, create a XYChart of size 300 pixels x 280 pixels
	my $c = new XYChart(300, 280);

	#Set the plotarea at (50, 25) and of 200 pixel (w) x 200 pixels (h)
	$c->setPlotArea(50, 25, 200, 200);

	#Add a title to the chart
	$c->addTitle("Daily Server Load");
		
	#Add a title to the y axis
	$c->yAxis()->setTitle("MBytes");

	#Add a title to the x axis
	$c->xAxis()->setTitle("June 12, 2001");
	
	#Set the x axis labels using the supplied labels
	$c->xAxis()->setLabels($labels);

	#Add an area layer to the chart
	my $layer = $c->addAreaLayer();

	#Add a data set to the area layer, and set the data color to 
	#light blue (0xa8a8ff) and the line color to blue (0x0000ff)
	$layer->addDataSet($data)->setDataColor(0xa8a8ff, 0x0000ff);

	#Set the line width to 3 pixels to highlight the line
	$layer->setLineWidth(3);

	#output the chart as a PNG file
	$c->makeChart("linearea.png");
}


main();
    