#include <stdio.h>
#include "chartdir.h"

void shadowpie(int angle, const char *filename)
{
	//The data for the pie chart
	double data[] = { 25, 18, 15, 12, 8, 30, 35 };

	//First, create a PieChart of size 100 pixels x 110 pixels
	PieChart *c = PieChart::create(100, 110);

	//Set the center of the pie at (50, 55) and the radius to 36 pixels
	c->setPieSize(50, 55, 36);

	//Set the depth, tilt angle and 3D mode of the 3D pie 
	//(-1 means auto depth, "true" means the 3D effect is in shadow mode)
	c->set3D(-1, angle, true);

	//Add a title showing the tilt angle
	char buffer[256];
	sprintf(buffer, "Shadow @ %d deg", angle);
	c->addTitle(buffer, "arial.ttf", 8);

	//Set the pie data and the pie labels
	c->setData(sizeof(data)/sizeof(data[0]), data);

	//Disable the sector labels by setting the color to transparent
	c->setLabelStyle(0, 8, Transparent);

	//output the chart
	c->makeChart(filename);

	//destroy the chart to free up resources
	c->destroy();
}

int main(int argc, char *argv[])
{
	shadowpie(45, "shadow45pie.png");
	shadowpie(135, "shadow135pie.png");
	shadowpie(225, "shadow225pie.png");
	shadowpie(315, "shadow315pie.png");
	return 0;
}
