/*
 * Copyright (C) 2001 Advanced Software Engineering Limited.
 *
 * This file is part of the ChartDirector software. Usage of this file is
 * subjected to the ChartDirector license agreement. See the LICENSE.TXT
 * file that comes with the ChartDirector software release, or visit
 * Advanced Software Engineering's web site at www.advsofteng.com or 
 * email to support@advsofteng.com for information.
 *
 */
 
#ifndef drawobj_HDR
#define drawobj_HDR


#include "libgraphics.h"


enum 
{
	Palette = 0xffff0000,
	BackgroundColor = 0xffff0000, 
	LineColor = 0xffff0001,
	TextColor = 0xffff0002,
	DataColor = 0xffff0008
};


class TextStyle
{
public :
	virtual ~TextStyle() {}
	virtual void setFontStyle(const char *font, int fontIndex = 0) = 0;
	virtual void setFontSize(double fontHeight, double fontWidth = 0) = 0;
	virtual void setFontAngle(double angle, bool vertical = false) = 0;
	virtual void setFontColor(int color) = 0;
	virtual void setBackground(int color, int edgeColor = Transparent) = 0;
	virtual void setMargin(int leftMargin, int rightMargin, int topMargin, int bottomMargin) = 0;
	virtual void setMargin(int m) = 0;
};


class DrawObj
{
public :
	virtual ~DrawObj() {}
	virtual void destroy() = 0;

	virtual void paint(DrawArea *d) = 0;
};


class Box : virtual public DrawObj
{
public :
	virtual ~Box() {}
	
	virtual void setPos(int x, int y) = 0;
	virtual void setSize(int w, int h) = 0;
	virtual void setBackground(int color, int edgeColor = Transparent) = 0;
};


class TextBox : virtual public TextStyle, virtual public Box
{
public :
	virtual ~TextBox() {}
	static TextBox *create();

	virtual void setText(const char *text) = 0;
	virtual void setAlignment(Alignment a) = 0;
	virtual void setBackground(int color, int edgeColor = Transparent) = 0;
};


class Line : virtual public DrawObj
{
public :
	virtual ~Line() {}
	static Line *create();
	virtual void destroy() = 0;
	
	virtual void setPos(int x1, int y1, int x2, int y2) = 0;
	virtual void setColor(int c) = 0;
	virtual void setWidth(int w) = 0;
};


#endif
