<?php
include("phpchartdir.php");

#The data for the bar chart
$data0 = array(100, 125, 245.78, 147, 67);
$data1 = array(85, 156, 179.5, 211, 123);
$data2 = array(97, 87, 56, 267, 157);

#The labels for the bar chart
$labels = array("Mon", "Tue", "Wed", "Thu", "Fri");

#First, create a XYChart of size 500 pixels x 320 pixels
$c = new XYChart(500, 320);

#the plotarea rectangle to start at (100, 40) and of 
#280 pixels in width and 240 in height
$c->setPlotArea(100, 40, 280, 240);

#Add a legend box at (400, 100)
$c->addLegend(400, 100);

#Add a title to the chart
$c->addTitle("Weekday Network Load");

#Add a multiline title to the y axis. draw the title upright by setting the 
#font angle 0 (the default is to draw the title sideways for y axis)
$textBox = $c->yAxis->setTitle("Average\nThroughput\n(MBytes\nPer Hour)");
$textBox->setFontAngle(0);

#the labels on the x axis
$c->xAxis->setLabels($labels);

#Add three bar layers, each represent one data set
$c->addBarLayer($data0, 0x808080ff, "Server #1", 5);
$c->addBarLayer($data1, 0x80ff0000, "Server #2", 5);
$c->addBarLayer($data2, 0x8000ff00, "Server #3", 5);

#output the chart
header("Content-type: image/png");
print($c->makeChart2(PNG));
?>