use perlchartdir;


sub main
{
	#The data for the bar chart
	my $data0 = [100, 125, 245.78, 147, 67];
	my $data1 = [85, 156, 179.5, 211, 123];
	my $data2 = [97, 87, 56, 267, 157];

	#The labels for the bar chart
	my $labels = ["Mon", "Tue", "Wed", "Thu", "Fri"];

	#First, create a XYChart of size 500 pixels x 320 pixels
	my $c = new XYChart(500, 320);

	#Set the plotarea rectangle to start at (100, 40) and of 
	#280 pixels in width and 240 in height
	$c->setPlotArea(100, 40, 280, 240);

	#Add a legend box at (400, 100)
	$c->addLegend(400, 100);

	#Add a title to the chart
	$c->addTitle("Weekday Network Load");

	#Add a multiline title to the y axis. draw the title upright by setting the 
	#font angle 0 (the default is to draw the title sideways for y axis)
	$c->yAxis()->setTitle("Average\nThroughput\n(MBytes\nPer Hour)")
		->setFontAngle(0);
	
	#Set the labels on the x axis
	$c->xAxis()->setLabels($labels);

	#Add three bar layers, each represent one data set
	$c->addBarLayer($data0, 0x808080ff, "Server #1", 5);
	$c->addBarLayer($data1, 0x80ff0000, "Server #2", 5);
	$c->addBarLayer($data2, 0x8000ff00, "Server #3", 5);

	#output the chart as a PNG file
	$c->makeChart("depthbar.png");
}


main();
