use perlchartdir;


sub gridBar
{
	my ($filename, $bgimage) = @_;

	#The data for the chart
	my $data = [85, 156, 179.5, 211, 123];
	my $labels = ["Mon", "Tue", "Wed", "Thu", "Fri"];

	#First, create a XYChart of size 250 pixels x 250 pixels
	my $c = new XYChart(250, 250);

	#Set the plotarea at (100, 40) and of size 200(w) x 200(h)
	my $p = $c->setPlotArea(25, 15, 200, 200);
	
	if ($bgimage != "") {
		#use the given background image as the plot area background
		$p->setBackground2($bgimage);
		#turn off the grid by setting it to Transparent
		$p->setGridColor($perlchartdir::Transparent);
	}
	else {
		#no background image, use white and gray as two alternate
		#plotarea background colors
		$p->setBackground(0xffffff, 0xe0e0e0);
		#enable horizontal and vertical grid by setting their colors
		$p->setGridColor(0xc0c0c0, 0xc0c0c0);
	}

	#Set the labels on the x axis
	$c->xAxis()->setLabels($labels);

	#Add a 3D bar layer with the given data
	$c->addBarLayer($data).set3D();

	#output the chart
	$c->makeChart($filename);
}


gridBar("gridband.png", "");
gridBar("gridbg.png", "bg.png");

