use perlchartdir;


sub main
{
	#The data for the bar chart
	my $data0 = [100, 125, 245.78, 147, 67];
	my $data1 = [85, 156, 179.5, 211, 123];
	my $data2 = [97, 87, 56, 267, 157];

	#The labels for the bar chart
	my $labels = ["Mon", "Tue", "Wed", "Thu", "Fri"];

	#First, create a XYChart of size 500 pixels x 320 pixels
	my $c = new XYChart(500, 320);

	#Set the plotarea rectangle to start at (100, 40) and of 
	#280 pixels in width and 240 in height
	$c->setPlotArea(100, 40, 280, 240);

	#Add a legend box at (400, 100)
	$c->addLegend(400, 100);

	#Add a title to the chart
	$c->addTitle("Weekday Network Load");

	#Add a multiline title to the y axis. draw the title upright by setting the 
	#font angle 0 (the default is to draw the title sideways for y axis)
	$c->yAxis()->setTitle("Average\nThroughput\n(MBytes\nPer Hour)")
		->setFontAngle(0);
	
	#Set the labels on the x axis
	$c->xAxis()->setLabels($labels);

	#Add a bar layer and set the layer 3D depth to 8 pixels
	my $layer = $c->addBarLayer2($Layer::Stack, 8);

	#Add the three data sets to the bar layer
	$layer->addDataSet($data0, -1, "Server #1");
	$layer->addDataSet($data1, -1, "Server #2");
	$layer->addDataSet($data2, -1, "Server #3");

	#Enable bar label for the whole bar
	$layer->setAggregateLabelStyle();

	#Enable bar label for each segment of the stacked bar
	$layer->setDataLabelStyle();

	#output the chart
	$c->makeChart("labelbar.png");
}


main();
    