       IDENTIFICATION DIVISION. 
      **************************************
      * THIS IS A SAMPLE PROGRAM USED TO   *
      * DEMONSTRATE FEATURES OF THE COBOL  *
      * LANGUAGE THAT ARE SUPPORTED IN     *
      * Deskware COBOL Intepreter - Alpha  *
      * release 0.000                      *
      **************************************
       PROGRAM-ID.      SAMPLE1.CBL
       AUTHOR.          DESKWARE.

       ENVIRONMENT DIVISION.
      **************************************
      * THIS PROGRAM WAS SUCCESSFULLY      *
      * TESTED UNDER DOS, WINDOWS NT, AND  *
      * LINUX.                             * 
      **************************************
       CONFIGURATION SECTION.
       SOURCE COMPUTER. 486.  
       OBJECT COMPUTER. 486.  

       DATA DIVISION.
      **************************************
      * SAMPLE1.IN IS USED AS AN INPUT FILE*
      * AND SAMPLE1.OUT IS USED AS AN      *
      * OUTPUT FILE.                       *  
      **************************************
       FILE SECTION.
       FD SAMPLE1.IN RECORD IS 128 BYTES.  
       FD SAMPLE1.OUT RECORD IS 128 BYTES.  

      **************************************
      * VARIABLE DECLARATIONS              *
      **************************************
       WORKING-STORAGE SECTION.
       01 WS-VAR-2.
           05 WS-VAR21        PIC XXXXXXXXXXXXXXXXXXXXXXXXXXXXX.
           05 WS-VAR23.
              10 WS-TEST1     PIC X. 
              10 WS-TEST2     PIC X. 
       01 WS-EOF              PIC X.
       01 WS-YES              PIC X.
       01 WS-NO               PIC X.
       01 WS-INPUT-RECORD.
           05 WS-INPUT1       PIC XXXX.
           05 WS-INPUT2       PIC XXXX.
           05 WS-INPUT3       PIC XXXX.
           05 WS-INPUT4       PIC XXXX.
       01 WS-OUTPUT-RECORD.
           05 WS-OUTPUT1      PIC XXXX.
           05 WS-OUTPUT2      PIC XXXXXX.
        
       PROCEDURE DIVISION.
      **************************************
      * MODULE:                            *
      *    0000-MAIN                       *
      * DESCRIPTION:                       *
      *    THIS IS THE MAIN DRIVER MODULE  *
      *    FOR THIS SAMPLE PROGRAM.        *
      **************************************
       0000-MAIN.
            MOVE "N" TO WS-EOF.
            MOVE "Y" TO WS-YES.
            MOVE "X" TO WS-TEST1.
            MOVE "Y" TO WS-TEST2.
 
            IF WS-YES = "Y" THEN
               DISPLAY "WS-YES is equal to Y"
               IF WS-EOF = "Y" THEN
                  DISPLAY "WS-EOF is equal to Y"
               ELSE
                  DISPLAY "WS-EOF is not equal to Y"
                  IF WS-TEST1 = "X" THEN
                     DISPLAY "WS-TEST1 is equal to X"
                  ENDIF
               ENDIF
            ELSE
               DISPLAY "WS-YES is not equal to Y"
            ENDIF.
            PERFORM 1000-CREATE-SAMPLE-DATA.
            OPEN SAMPLE1.IN FOR READING DELIMITED WITH "," AT END MOVE WS-YES TO WS-EOF.
            OPEN SAMPLE1.OUT FOR WRITING
            PERFORM 1000-READ-INPUT-RECORD.
            PERFORM 2000-WRITE-OUTPUT-RECORD UNTIL WS-EOF = WS-YES.
            PERFORM 3000-CLOSE-FILES. 
            GOBACK.
      **************************************
      * MODULE:                            *
      *    1000-CREATE-SAMPLE-DATA         *
      * DESCRIPTION:                       *
      *    CREATE THE TEST DATA THAT IS    *
      *    USED TO DEMONSTRATE THE         *
      *    DELIMITED FEATURE OF THE OPEN   *
      *    COMMAND.                        * 
      **************************************
       1000-CREATE-SAMPLE-DATA.  
           DISPLAY "Create the sample data".  
           OPEN SAMPLE1.IN FOR WRITING.
           WRITE "1234" TO SAMPLE1.IN
           WRITE "1234,567890,ab,cdefghij,klmnop" TO SAMPLE1.IN
           CLOSE SAMPLE1.IN
           DISPLAY "Sample data has been created".
      **************************************
      * MODULE:                            *
      *   1000-READ-INPUT-RECORD           *
      * DESCRIPTION:                       *
      *   READS RECORD FROM THE INPUT FILE *
      **************************************
       1000-READ-INPUT-RECORD.
            READ SAMPLE1.IN INTO WS-INPUT-RECORD.
            PERFORM 9000-DISPLAY-INPUT-RECORD.
      **************************************
      * MODULE:                            *
      *   2000-WRITE-OUTPUT-RECORD         *
      * DESCRIPTION:                       *
      *   WRITES THE OUTPUT RECORD TO      *
      *   SAMPLE1.OUT                      *
      **************************************
       2000-WRITE-OUTPUT-RECORD.
            MOVE WS-INPUT-RECORD TO WS-OUTPUT-RECORD.
            WRITE WS-OUTPUT-RECORD TO SAMPLE1.OUT
            PERFORM 1000-READ-INPUT-RECORD.
      **************************************
      * MODULE:                            *
      *   3000-CLOSE-FILES                 *
      * DESCRIPTION:                       *
      *   CLOSES ALL THE FILES THAT ARE    *
      *   USED BY THIS PROGRAM.            * 
      **************************************
       3000-CLOSE-FILES.
           CLOSE SAMPLE1.IN
           CLOSE SAMPLE1.OUT
      **************************************
      * MODULE:                            *
      *   9000-DISPLAY-INPUT-RECORD        *
      * DESCRIPTION:                       *
      *   JUST DISPLAYS A VARIABLE         *
      **************************************
       9000-DISPLAY-INPUT-RECORD.
           DISPLAY WS-INPUT-RECORD.
