#include <stdio.h>
#include <errno.h>
#include <time.h>
#include <libp.h>


int fputc(int c, FILE *stream)
{
	int rv;
	if (stream->token != FILTOK)
		return EOF;
	if (!(stream->flags & _F_WRIT)) {
		stream->flags |= _F_ERR;
		errno = EFAULT;
		return EOF;
	}
	if ((stream->flags & _F_IN) || 
			stream->buffer && ( stream->flags & _F_OUT) 
				&& stream->level >= 0) {
		if (fflush(stream))
			return EOF;
		goto join;
	}
	else {
		if (!(stream->flags & _F_OUT)) {
join:
			stream->flags &= ~_F_IN;
			stream->flags |= _F_OUT;
			stream->level = -stream->bsize;
			stream->curp = stream->buffer;
		}
	}
	if (stream->buffer) {
		++stream->level;
		*stream->curp++ = (unsigned char)c;
		if (c == '\n' && (stream->flags & _F_LBUF))
			fflush(stream);
	}		
	else {
		if (!(stream->flags & _F_BIN) && c == '\n') {
			int c1 = 13;
			if (_ll_write(stream->fd,&c1,1) < 0) {
				stream->flags |= _F_ERR;
				errno = EIO;
				return EOF;
			}
		}
		if (_ll_write(stream->fd,&c,1) < 0) {
			stream->flags |= _F_ERR;
			errno = EIO;
			return EOF;
		}
	}
	return 0;
}
int _fputc(int c, FILE *stream)
{
	stream->level--;
	return fputc(c,stream);
}
#undef putc
#undef putchar
int putc(int c, FILE *stream)
{
	return fputc(c,stream);
}
int putchar(int c)
{
	return fputc(c,stdout);
}