#include <vcl.h>
#pragma hdrstop

#include <dos.h>
#include "stl.hpp"

char* new_str(const char* src) {
	char* dest = new char[::strlen(src) + 1];
	return ::strcpy(dest, src);
}

String get_path(const char* env) {
	char* ptr = ::getenv(env);
	if(ptr) {
		String temp(ptr);
		if(!temp.IsEmpty()) {
			char last = temp[temp.Length() - 1];
			if(!(last == '\\' || last == '/')) {
				temp += '\\';
			}
		}
		return String(temp);
	}
	return String();
}

String get_temp_filename() {
	struct time t;
	char buffer[16];
	::gettime(&t);
	::sprintf(buffer, "%2.2d%2.2d%2.2d.tmp", t.ti_hour, t.ti_min, t.ti_sec);
	return String(get_path("HOME") + buffer);
}

String get_anagram(const char* src, bool nodigits) {
	set_of_char buffer;
	for(register i = 0; src[i]; i++) {
		if(nodigits) {
			if(::IsCharAlpha(src[i])) {
				buffer.insert(src[i]);
			}
		}
		else if(::IsCharAlphaNumeric(src[i])) {
			buffer.insert(src[i]);
		}
	}
	String rv;
	set_of_char::const_iterator i = buffer.begin();
	while(i != buffer.end()) {
		rv += (*i);
		i++;
	}
	return String(rv);
}
