// cisendDlg.cpp : implementation file
//

#include "stdafx.h"
#include "cisend.h"
#include "cisendDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
//Create dll instance
	HINSTANCE cifilexdll = NULL;
	HINSTANCE civerbsdll = NULL;
//Define the type definition
	typedef int (*CIFILEX)(int *, char *, struct descriptor *,
				struct descriptor *, struct descriptor *,
				struct descriptor *, struct descriptor *,
				char *,
				struct descriptor *, struct descriptor *);
	typedef int (*CISTART)(int *, char *, char *, struct descriptor *);
//declare external subroutines
	CIFILEX	cifilex;
	CISTART	cistart;

	CString	password;
	int		cmn,
			i,
			j,
			len,
			stat;
	char	retcode[7],
			role[2],
			options[17],
			flags[9],
			temp[128],
			*pos;
	struct	descriptor	d_logtype,
						d_pgmdevname,
						d_lcllib,
						d_rmtlib,
						d_lclmem,
						d_rmtmem,
						d_username,
						d_password;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCisendDlg dialog

CCisendDlg::CCisendDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCisendDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCisendDlg)
	m_from = _T("");
	m_monitor = FALSE;
	m_password = _T("");
	m_to = _T("");
	m_translate = FALSE;
	m_truncate = FALSE;
	m_username = _T("");
	m_location = _T("");
	m_replace = FALSE;
	m_append = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCisendDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCisendDlg)
	DDX_Control(pDX, IDC_START_BUTTON, m_start);
	DDX_Text(pDX, IDC_FROM_EDIT, m_from);
	DDX_Check(pDX, IDC_MONIT_CHECK, m_monitor);
	DDX_Text(pDX, IDC_PASSWORD_EDIT, m_password);
	DDX_Text(pDX, IDC_TO_EDIT, m_to);
	DDX_Check(pDX, IDC_TRANS_CHECK, m_translate);
	DDX_Check(pDX, IDC_TRUNC_CHECK, m_truncate);
	DDX_Text(pDX, IDC_USERNAME_EDIT, m_username);
	DDX_Text(pDX, IDC_LOCATION_EDIT, m_location);
	DDX_Check(pDX, IDC_REPLACE_CHECK, m_replace);
	DDX_Check(pDX, IDC_APPEND_CHECK, m_append);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCisendDlg, CDialog)
	//{{AFX_MSG_MAP(CCisendDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_EXIT_BUTTON, OnExitButton)
	ON_EN_CHANGE(IDC_FROM_EDIT, OnChangeFromEdit)
	ON_EN_CHANGE(IDC_TO_EDIT, OnChangeToEdit)
	ON_EN_CHANGE(IDC_LOCATION_EDIT, OnChangeLocationEdit)
	ON_EN_CHANGE(IDC_USERNAME_EDIT, OnChangeUsernameEdit)
	ON_EN_CHANGE(IDC_PASSWORD_EDIT, OnChangePasswordEdit)
	ON_BN_CLICKED(IDC_START_BUTTON, OnStartButton)
	ON_BN_CLICKED(IDC_APPEND_CHECK, OnAppendCheck)
	ON_BN_CLICKED(IDC_REPLACE_CHECK, OnReplaceCheck)
	ON_BN_CLICKED(IDC_MONIT_CHECK, OnMonitCheck)
	ON_BN_CLICKED(IDC_TRUNC_CHECK, OnTruncCheck)
	ON_BN_CLICKED(IDC_TRANS_CHECK, OnTransCheck)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCisendDlg message handlers

BOOL CCisendDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_translate = TRUE;
	m_monitor = TRUE;
	UpdateData(FALSE);
	d_lclmem.w_length = (short)strlen(strcpy(d_lclmem.a_pointer, ""));
	d_logtype.w_length = (short)strlen(strcpy(d_logtype.a_pointer, "PROD"));
//Load the library
	civerbsdll = LoadLibrary("ci_verbs.dll");
	if(civerbsdll == NULL)
	{
		MessageBox("Could notload ci_verbs.dll.");
		GetDlgItem(IDC_START_BUTTON)->EnableWindow(TRUE);
		return(TRUE);
	}
	cifilexdll = LoadLibrary("cifilex.dll");
	if(civerbsdll == NULL)
	{
		MessageBox("Could notload cifilex.dll.");
		GetDlgItem(IDC_START_BUTTON)->EnableWindow(TRUE);
		return(TRUE);
	}
//Get address of subroutine
	cifilex = (CIFILEX)GetProcAddress(cifilexdll, "cifilex");
	cistart = (CISTART)GetProcAddress(civerbsdll, "cistart");

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCisendDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCisendDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCisendDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCisendDlg::OnExitButton() 
{
	// TODO: Add your control notification handler code here
	OnOK();
	
}

void CCisendDlg::OnChangeFromEdit() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	UpdateData(FALSE);
	
}

void CCisendDlg::OnChangeToEdit() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	UpdateData(FALSE);
	
}

void CCisendDlg::OnChangeLocationEdit() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	UpdateData(FALSE);
	
}

void CCisendDlg::OnChangeUsernameEdit() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	UpdateData(FALSE);
	
}

void CCisendDlg::OnChangePasswordEdit() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	password = password + m_password;
	if(m_password[0] == '!')
		password.Empty();
	m_password.Empty();
	UpdateData(FALSE);
//	MessageBox(password);

}

void CCisendDlg::OnStartButton() 
{
	// TODO: Add your control notification handler code here
	GetDlgItem(IDC_START_BUTTON)->EnableWindow(FALSE);

//Check a few things
	len = m_from.GetLength();
	i = 0;
	while((i < len) && (m_from[i] != '.'))
		i++;
	if(i >= len)
	{
		MessageBox("Illegal local file specification.");
		GetDlgItem(IDC_START_BUTTON)->EnableWindow(TRUE);
		return;
	}
	strncpy(d_lcllib.a_pointer, m_from, len);
	d_lcllib.w_length = len;
	i = 0;
	j = 0;
	len = m_to.GetLength();
	while((j < len) && ((temp[i] = m_to[j]) != '<'))
	{
		i++;
		j++;
	}
	if(j < len)
	{
		temp[i] = 0;
		strcat(temp, "/");
		i = strlen(temp);
		j++;
		while((j < len) &&
			((temp[i] = m_to[j]) != ';') &&
			(m_to[j] != '>'))
		{
			i++;
			j++;
		}
		if(j >= len)
		{
			MessageBox("Illegal remote file specification.");
			GetDlgItem(IDC_START_BUTTON)->EnableWindow(TRUE);
			return;
		}
		temp[i] = 0;
		d_rmtlib.w_length = (short)strlen(strcpy(d_rmtlib.a_pointer, temp));
		if(m_to[j] == ';')
		{
			i = 0;
			j++;
			while((j < len) &&
				((temp[i] = m_to[j]) != '>'))
			{
				i++;
				j++;
			}
			temp[i] = 0;
			d_rmtmem.w_length = (short)strlen(strcpy(d_rmtmem.a_pointer, temp));
		}
		else
		{
			d_rmtmem.w_length = (short)strlen(strcpy(d_rmtmem.a_pointer, "*FIRST"));
		}
	}
	else
	{
		d_rmtmem.w_length = 0;
		d_rmtlib.w_length = (short)len;
		strncpy(d_rmtlib.a_pointer, m_to, len);
	}
	len = m_location.GetLength();
	d_pgmdevname.w_length = (short)len;
	strncpy(d_pgmdevname.a_pointer, m_location, len);
	len = m_username.GetLength();
	if(len > 0)
	{
		d_username.w_length = (short)len;
		strncpy(d_username.a_pointer, m_username, len);
		len = password.GetLength();
		d_password.w_length = (short)len;
		strncpy(d_password.a_pointer, password, len);
	}
	else
	{
		d_username.w_length = 0;
		d_password.w_length = 0;
	}

	
	strcpy(options, "NNNNNNNNNNNNNNNN");
	options[FETCHPOS] = 'N';
	if(m_replace)
        options[REPLPOS] = 'Y';

    if(m_truncate) 
        options[TRUNPOS] = 'Y';

    if(m_translate) 
        options[TRANPOS] = 'Y';

    if(m_append) 
        options[APNDPOS] = 'Y';

    if(m_monitor) 
        options[MONIPOS] = 'Y';

    if ((stat=cistart(&cmn, retcode, role, &d_logtype))!= CI$_NORMAL) 
	{
		sprintf(temp, "Bad return from cistart, retcode = %d\n", retcode);
		MessageBox(temp);
		GetDlgItem(IDC_START_BUTTON)->EnableWindow(TRUE);
		return;
	}
	if(m_monitor)
	{
		sprintf(temp, "PARENT_WINDOW=%d\0", this->m_hWnd);
		_putenv(temp);
	}
    if((stat=cifilex(&cmn, retcode, &d_pgmdevname, &d_lcllib,
		&d_lclmem, &d_rmtlib, &d_rmtmem, options, &d_username, 
        &d_password)) != CI$_NORMAL)
	{
		sprintf(temp, "Bad return from cifilex, retcode = %s\n", retcode);
		MessageBox(temp);
	}
	else
	{
		if(m_monitor)
			MessageBox("Normal successful return.");
	}
	GetDlgItem(IDC_START_BUTTON)->EnableWindow(TRUE);
	return;
}

void CCisendDlg::OnAppendCheck() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	if(m_append)
		m_replace = FALSE;
	UpdateData(FALSE);
	
}

void CCisendDlg::OnReplaceCheck() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	if(m_replace)
		m_append = FALSE;
	UpdateData(FALSE);

}

void CCisendDlg::OnMonitCheck() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	UpdateData(FALSE);
	
}

void CCisendDlg::OnTruncCheck() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	UpdateData(FALSE);
	
}

void CCisendDlg::OnTransCheck() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	UpdateData(FALSE);
	
}

void CCisendDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
/*
	int	m;
	KillTimer(1);
	m = atoi(getenv("PERCENT_DONE"));
	if(m > 100)
	{
		GetDlgItem(IDC_PROGRESS)->EnableWindow(FALSE);
		GetDlgItem(IDC_PROGRESS)->ShowWindow(SW_HIDE);
	}
	else
	{
		m_prog.SetPos(m);
		SetTimer(1, 200, NULL);
	}
*/	
	CDialog::OnTimer(nIDEvent);
}
