
/*
 * Copyright (C) 1994,95 David Stes.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "fab.h"

@implementation Fabobject

- object:anObject
{
    object = anObject;
    return self;
}

+ object:anObject
{
    return [[super new] object:anObject];
}

- setpublic:(BOOL)flag		{ flags.public = flag; return self; }

BOOL fabtestmode;

- settest:(BOOL)flag		{ flags.test = flag; return self; }

- dumpheader:(FILE *)f		{ return self; }
- dumpsource:(FILE *)f		{ return self; }

- dumppublicsource:(FILE *)f
{
    return [self dumpsource:f];
}

- dumppublicheader:(FILE*)f
{
    if (flags.public) return [self dumpheader:f];
    return self;
}

- include
{
    return self;
}

id    fabmethodsummary;
id    fabMethodType;

- makepublicsummary
{
    return self;
}

- dumpdepend:(FILE *)f		{ return self; }

- asParagraph
{
  return nil; /* don't add anything by default */
}

- paragraphs:aCltn
{
  if (flags.public) [aCltn add:[self asParagraph]];
  return aCltn;
}

- allparagraphs:aCltn
{
  if (!flags.public) return self;
  return [self paragraphs:aCltn];
}

@end

