
/*
 * Copyright (C) 1994,95 David Stes.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "fab.h"

@implementation Fabstring

- chars:(STR)chars count:(int)c filename:(STR)name lineno:(int)no
{
    value=(STR)malloc(c+1);strncpy(value,chars,c);value[c]=0;
    filename = name;lineno = no;return self;
}

+ chars:(STR)chars count:(int)c filename:(STR)name lineno:(int)no
{
    return [[super new] chars:chars count:c filename:name lineno:no];
}

+ chars:(STR)chars count:(int)c
{
    return [self chars:chars count:c filename:NULL lineno:0];
}

+ str:(STR)string
{
    return [self chars:string count:strlen(string)];
}

- (STR)str
{
    return value;
}

- (unsigned) size
{
  return strlen(value);
}

- (BOOL)isEqual:b
{
    return (self==b)?YES:strcmp([b str],value) == 0;
}

- dumpsource:(FILE *)f
{
    fprintf(f,"#line %d \"%s\"\n",lineno,filename);
    return [self print:f];
}

- dumppublicsource:(FILE *)f
{
    return [self print:f];
}

- settypeface:(TYPEFACE)anAttribute
{
    attribute = anAttribute;return self;
}

- asText
{
  id text,attrib;
  text = [Text str:value];
  attrib = [TextAttribute emphasiscode:attribute];
  if (attrib) [text addAttribute:attrib from:0 to:[text size] - 1];
  return text;
}

- asText:text
{
  id attrib;
  unsigned pos = [text size];
  [[text string] concatSTR:value];
  attrib = [TextAttribute emphasiscode:attribute];
  if (attrib) [text addAttribute:attrib from:pos to:[text size] - 1];
  return text;
}

- substitute
{
    if (substitutions) {
	STR p,r;
	char aBuffer[64000];
	
	p = value;
	r = aBuffer;
	
	while (*p) {
	    STR q;int len;
	    q = doSubs(p,&len);
	    if (q) { strcpy(r,q);r += strlen(q);p += len; } else *r++ = *p++;
	}
	
	*r++ = 0;return [isa str:aBuffer];
    } else {
	return self;
    }
}

- print:(FILE *)f
{
    if (substitutions) {
	STR p = value;

	while (*p) {
	    STR q;int len;
	    q = doSubs(p,&len);
	    if (q) { fputs(q,f);p += len; } else fputc(*p++,f);
	}
	
	return self;
    } else {
	/* don't use printf as text might contain percent signs */
	fputs(value,f);return self;
    }
}

@end

