
/*
 * Copyright (C) 1994,95 David Stes.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "fab.h"

@implementation Include

- object:anObject deflist:dList
{
    object = anObject;
    deflist = dList;
    return self;	
}

+ object:anObject deflist:dList
{
    return [[super new] object:anObject deflist:dList];
}

- include
{
    STR filename;
    extern id yyres;
    extern int yyparse();
    extern int yyconnect(STR file);
    
    filename = [fab searchfile:[object str]];
    yyconnect(filename);if (yyparse()) exit(1);
    list = yyres;
    /* stpstn's +self returns (SHR), so typecast to id for -isKindOf: */
    assert([yyres isKindOf:(id)[Fablist self]]);    
    /* recursively descend */
    list = [list include];return self;
}

- newsubs
{
    subs = substitutions; /* save value */
    
    if (deflist!=nil && substitutions!=nil) {
	substitutions = [deflist substitute];
    } else {
	substitutions = deflist;
    }
    
    return self;
}

- oldsubs
{
    substitutions = subs; /* restore value */
    return self;
}

- makepublicsummary
{
    return [list makepublicsummary];
}

- dumpheader:(FILE *)f
{
    [self newsubs];[list dumpheader:f];[self oldsubs];
    return self;
}

- dumpsource:(FILE *)f
{
    [self newsubs];[list dumpsource:f];[self oldsubs];
    return self;
}

- dumppublicheader:(FILE *)f
{
    [self newsubs];[list dumppublicheader:f];[self oldsubs];
    return self;
}

- dumppublicsource:(FILE *)f
{
    [self newsubs];[list dumppublicsource:f];[self oldsubs];
    return self;
}

- dumpdepend:(FILE *)f
{
    return [list dumpdepend:f];
}

@end

