
/*
 * Copyright (C) 1994,95 David Stes.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "fab.h"

/******************************************************************************
 *
 * Methodatom : a term of the form "name:(TYPE)var"
 * 
 *****************************************************************************/

@implementation Methodatom
{
    id	name;		/* can be nil */
    id	type;		/* can be nil */
    id	var;		/* can be nil */
}

- name:n type:t var:v
{
    name = n;type = t;var = v;return self;
}

+ name:n type:t var:v
{
    return [[super new] name:n type:t var:v];
}

- print:(FILE *)f
{
    /* note the space between previous var and this name */
    if (name) { fprintf(f," ");[name print:f]; }
    if (var)  fprintf(f,":");
    if (type) { fprintf(f,"(");[type print:f];fprintf(f,")"); }
    if (var)  [var print:f];
    
    return self;
}

- asText:text
{
    id string = [text string];

    if (name) {
      unsigned p = [text size];
      [string concatSTR:[name str]];
      [text makeBoldFrom:p to:p + strlen([name str]) - 1];
    }
    if (var)  {
      [string concatSTR:":"];
    }
    if (type) {
      [string concatSTR:"("];
      [string concatSTR:[type str]];
      [string concatSTR:")"];
    }
    if (var)  {
      id attrib;
      unsigned p = [text size];
      [string concatSTR:[var str]];
      attrib = [TextAttribute emphasiscode:ITALIC];
      [text addAttribute:attrib from:p to:p + strlen([var str]) - 1];
    }

    return text;
}
- nameAsText:text
{
    id string = [text string];
    if (name) [string concatSTR:[name str]];
    if (var) [string concatSTR:":"];
    return text;
}

@end

