
/*
 * Copyright (C) 1998 David Stes.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <txtstyle.h> 
#include <octext.h> 
#include <txtattr.h> 
#include <ordcltn.h> 
#include <paragrph.h> 
#include <assert.h> 
#include <ctype.h>

static void ptitle(char *s)
{
  int i,n = strlen(s);
  printf("\n");
  printf("\n");
  for(i=0;i<n;i++) { int c = toupper(s[i]);printf("%c ",c); }
  printf("\n");
  n += n - 1;while (n--) printf("-");
  printf("\n");
}

static void psubtitle(char *s)
{
  int n = strlen(s);
  printf("\n%s\n",s);
  while (n--) printf("-");
  printf("\n");
}

static void pdot(char *s)
{
  printf("\n * %s\n",s);
}

static void pmethodname(char *s)
{
  printf("\n %s\n",s);
}

static void pmethodproto(char *s)
{
  printf("\n        %s\n",s);
}

void writeascii(id paragraphs)
{
  int i,n = [paragraphs size];
  for(i=0;i<n;i++) {
    id p = [paragraphs at:i];
    char *s = [[p asText] str];
    char *style = [[p textStyle] name];
    assert(style != NULL && s != NULL);
    if (!strcmp(style,"Title")) ptitle(s);
    else if (!strcmp(style,"Subtitle")) psubtitle(s);
    else if (!strcmp(style,"Methodname")) pmethodname(s);
    else if (!strcmp(style,"Methodproto")) pmethodproto(s);
    else if (!strcmp(style,"Dotbegin")) {}
    else if (!strcmp(style,"Dotitem")) pdot(s);
    else if (!strcmp(style,"Dotend")) {}
    else printf("\n%s\n",s);
  }

  printf("\n");
}

