// ISImageDemoDoc.cpp : implementation of the CISImageDemoDoc class
//

#include "stdafx.h"
#include "ISImageDemo.h"
#include "REsizeDlg.h"
#include "ISImageDemoDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CISImageDemoDoc

IMPLEMENT_DYNCREATE(CISImageDemoDoc, CDocument)

BEGIN_MESSAGE_MAP(CISImageDemoDoc, CDocument)
	//{{AFX_MSG_MAP(CISImageDemoDoc)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_FILE_SAVE_AS, OnFileSaveAs)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE, OnUpdateFileSave)
	ON_COMMAND(ID_EDIT_RESIZE, OnEditResize)
	ON_UPDATE_COMMAND_UI(ID_EDIT_RESIZE, OnUpdateEditResize)
	ON_COMMAND(ID_EDIT_HORIZONTALFLIP, OnEditHorizontalflip)
	ON_UPDATE_COMMAND_UI(ID_EDIT_HORIZONTALFLIP, OnUpdateEditHorizontalflip)
	ON_COMMAND(ID_EDIT_VERTICALFLIP, OnEditVerticalflip)
	ON_UPDATE_COMMAND_UI(ID_EDIT_VERTICALFLIP, OnUpdateEditVerticalflip)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CISImageDemoDoc construction/destruction

CISImageDemoDoc::CISImageDemoDoc()
{
	// TODO: add one-time construction code here

}

CISImageDemoDoc::~CISImageDemoDoc()
{
}

BOOL CISImageDemoDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	OnFileOpen();

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CISImageDemoDoc serialization

void CISImageDemoDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CISImageDemoDoc diagnostics

#ifdef _DEBUG
void CISImageDemoDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CISImageDemoDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CISImageDemoDoc commands

void CISImageDemoDoc::OnFileOpen() 
{
	// big, scary input filter
	CString filt="Image Files |*.BMP;*.JPG;*.PCX;*.PNG;*.TGA;*.TIF;*.PSD;*.WBMP|\
Windows BMP Files (*.BMP)|*.BMP|\
JPEG Files (*.JPG)|*.JPG|\
ZSoft PCX Files (*.PCX)|*.PCX|\
Adobe Photoshop Files (*.PSD)|*.PSD|\
PNG Files (*.PNG)|*.PNG|\
Targa TGA Files (*.TGA)|*.TGA|\
Wireless Bitmap Files (*.WBMP)|*.WBMP|\
TIFF Files (*.TIF)|*.TIF|\
All files (*.*)|*.*||";

	CString defFilt = "*.Bmp;*.Jpg;*.Pcx;*.Png;*.Tga;*.Psd;*.wbmp;*.Tif";

	CFileDialog fileDlg(TRUE, defFilt, defFilt, NULL, filt, NULL);

	fileDlg.m_ofn.Flags|=OFN_FILEMUSTEXIST;
	fileDlg.m_ofn.lpstrTitle="Load image file";

	if (fileDlg.DoModal()==IDOK)
	{

		CString csFQSrcFile = fileDlg.GetPathName();

	   CWaitCursor waitHere;

	   // read it
	   UINT res = m_image.LoadFromFile(csFQSrcFile);
	   
	   if (m_cBmp.GetSafeHandle())
		   m_cBmp.DeleteObject();

      if (res!=IS_ERR_OK)
      {
		  AfxMessageBox(CISImage::ErrorString(res));
		  if (res==IS_ERR_TRIALVERSION)
		  {
		  }
		  else
		  {
	         return;
		  }
      }

      UpdateImage();

      SetTitle(csFQSrcFile);
	}

}


void CISImageDemoDoc::UpdateImage()
{
   //
   // copy to a CBitmap for display
   //
	m_image.CopyToCBitmap(m_cBmp, NULL);

	// force a redraw and a scroll bar recalc
	UpdateAllViews(NULL, eHintNewImage, NULL);

}

void CISImageDemoDoc::OnUpdateFileSave(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable(m_image.IsValid());
}

void CISImageDemoDoc::OnFileSaveAs() 
{
	// big, scary output filter
	CString filt="Image Files |*.BMP;*.JPG;*.PCX;*.PNG;*.TGA;*.TIF;*.PSD;*.WBMP|\
Windows BMP Files (*.BMP)|*.BMP|\
JPEG Files (*.JPG)|*.JPG|\
ZSoft PCX Files (*.PCX)|*.PCX|\
Adobe Photoshop Files (*.PSD)|*.PSD|\
PNG Files (*.PNG)|*.PNG|\
Targa TGA Files (*.TGA)|*.TGA|\
Wireless Bitmap Files (*.WBMP)|*.WBMP|\
TIFF Files (*.TIF)|*.TIF|\
All files (*.*)|*.*||";

	CString defFilt = "*.Bmp;*.Jpg;*.Pcx;*.Png;*.Tga;*.psd;*.wbmp;*.Tif";
	CFileDialog fileDlg(FALSE, defFilt, defFilt, NULL, filt, NULL);

	fileDlg.m_ofn.lpstrTitle="Save current image to this file";
	
	if (fileDlg.DoModal()==IDOK) 
	{
		CString csOutPath = fileDlg.GetPathName();
		CISImage::eFormat eSaveFmt = CISImage::GuessFileTypeFromExtension(csOutPath);
		
		CWaitCursor wait_here_please;
		
		UINT32 res = m_image.SaveToFile(csOutPath, eSaveFmt);
		
		SetPathName(csOutPath);
	}

}

void CISImageDemoDoc::OnUpdateEditResize(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_image.IsValid());
}

// resize the image
void CISImageDemoDoc::OnEditResize() 
{
   CResizeDlg d;

   d.m_uX = m_image.GetSize().cx;
   d.m_uY = m_image.GetSize().cy;

   if (d.DoModal()==IDOK)
   {
      m_image.Resize(CSize(d.m_uX,d.m_uY));
	   UpdateImage();
   }
}

// flip and update
void CISImageDemoDoc::OnEditHorizontalflip() 
{
   m_image.HorizontalFlip();
	UpdateImage();
}

void CISImageDemoDoc::OnUpdateEditHorizontalflip(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable(m_image.IsValid());
}

// flip and update
void CISImageDemoDoc::OnEditVerticalflip() 
{
   m_image.VerticalFlip();
	UpdateImage();
}

void CISImageDemoDoc::OnUpdateEditVerticalflip(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable(m_image.IsValid());
}
