/*************************************************************************
** interpcom-2.3    (command interpreter)                                **
** command.c : Most of the built-in commands                             **
**                                                                       **
** Copyright (C) 2001  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**                                                                       **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details.                     **
**                                                                       **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free           **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      Aile 45-55                                                       **
**      2, place Jussieu                                                 **
**      75251 Paris Cedex 05                                             **
**      France                                                           **
**                                                                       **
 *************************************************************************/

#include "interp.h"



/*--------------------------------------------------------------------
    Function associated to the command 'exit'.
--------------------------------------------------------------------*/
int
exit_cmd(int argc, char *argv[])
{
    int             i;
    flow_data      *flow_interp;

    if (argc > 1) {
        if (comp(argv[1], "all") == 1) {
            for (i = 0; i < __n_max_threads; i++)
                flow_I[i].kill = 1;
        }
    }
    while (num_thread_run > 0) {
        interpcom_dummy(&num_thread_run);
    }
    flow_interp = (flow_data *) argv[-1];
    print(flow_interp, "%d instructions\n", flow_interp->n_instr);
    clean_exit_interp(flow_interp);
    exit_prog();
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to  the command 'loopf'
--------------------------------------------------------------------*/
int
bouclex_f(int argc, char *argv[])
{
    FILE           *stream;
    char            g[50],
                    h[150];
    int             i,
                    j,
                    inb;
    double          deb,
                    incr;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    strcpy(g, "<");
    strcpy(h, command_rep);
    strcat(h, argv[1]);
    stream = fopen(h, "w");
    if (stream == NULL) {
        err_mess(1);
        return 1;
    }
    strcat(g, argv[2]);
    inb = convert_int(argv[3], flow_interp);
    deb = convert_float(argv[4], flow_interp);
    incr = convert_float(argv[5], flow_interp);

    for (i = 0; i < inb; i++) {
        fprintf(stream, "%s %f ", g, i * incr + deb);
        for (j = 6; j < argc; j++)
            fprintf(stream, "%s ", argv[j]);
        fprintf(stream, "\n");
    }

    fclose(stream);
    return 0;
}
/*------------------------------------------------------------------*/



/*--------------------------------------------------------------------
    Function associated to the command 'loop'
--------------------------------------------------------------------*/
int
bouclex(int argc, char *argv[])
{
    FILE           *stream;
    char            g[50],
                    h[150];
    int             i,
                    j,
                    inb,
                    deb,
                    incr;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    strcpy(g, "<");
    strcpy(h, command_rep);
    strcat(h, argv[1]);
    stream = fopen(h, "w");
    if (stream == NULL) {
        err_mess(1);
        return 1;
    }
    strcat(g, argv[2]);
    inb = convert_int(argv[3], flow_interp);
    deb = convert_int(argv[4], flow_interp);
    incr = convert_int(argv[5], flow_interp);

    for (i = 0; i < inb; i++) {
        fprintf(stream, "%s %d ", g, i * incr + deb);
        for (j = 6; j < argc; j++)
            fprintf(stream, "%s ", argv[j]);
        fprintf(stream, "\n");
    }

    fclose(stream);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'repete'
--------------------------------------------------------------------*/
int
repetex(int argc, char *argv[])
{
    FILE           *stream;
    char            g[50],
                    h[150];
    int             i,
                    j,
                    inb;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    strcpy(h, command_rep);
    strcat(h, argv[1]);
    stream = fopen(h, "w");
    if (stream == NULL) {
        err_mess(1);
        return 1;
    }
    strcpy(g, "<");
    strcat(g, argv[2]);
    inb = convert_int(argv[3], flow_interp);
    if (inb < 1) {
        err_mess(2);
        return 1;
    }
    if (argc < 4 + inb) {
        err_mess(0);
        return 1;
    }

    for (i = 0; i < inb; i++) {
        fprintf(stream, "%s %f ", g, convert_float(argv[4 + i], flow_interp));
        for (j = 4 + inb; j < argc; j++)
            fprintf(stream, "%s ", argv[j]);
        fprintf(stream, "\n");
    }

    fclose(stream);
    return 0;
}
/*------------------------------------------------------------------*/



/*-------------------------------------------------------------------
    Function associated to the command 'echo'
-------------------------------------------------------------------*/
int
echo_cmd(int argc, char *argv[])
{
    int             i,
                    j,
                    m,
                    k,
                    len;
    char            h[400];
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    j = flow_interp->PRLEVEL;
    flow_interp->PRLEVEL = -1;

    for (i = 1; i < argc; i++) {
        len = strlen(argv[i]);
        memset(h, 0, 400);
        m = 0;

        for (k = 0; k < len; k++) {
            if (k < len - 1) {
                if (argv[i][k] == '\\' && argv[i][k + 1] == 'n') {
                    print(flow_interp, "%s\n", h);
                    memset(h, 0, 400);
                    k++;
                    m = 0;
                    continue;
                }
            }
            if (k == len - 1 && argv[i][k] == '%')
                h[m++] = ' ';
            else
                h[m++] = argv[i][k];
        }

        if (m > 0)
            print(flow_interp, "%s ", h);
    }

    flow_interp->PRLEVEL = j;
    fflush(stdout);
    return 0;
}
/*------------------------------------------------------------------*/



/*--------------------------------------------------------------------
    Function associated to the command 'echoi'
--------------------------------------------------------------------*/
int
echo_int_cmd(int argc, char *argv[])
{
    int             i,
                    j,
                    k;
    char            h[3];
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    k = flow_interp->PRLEVEL;
    flow_interp->PRLEVEL = -1;
    h[0] = 92;
    h[1] = 110;
    h[2] = 0;

    for (i = 1; i < argc; i++) {
        if (comp(argv[i], h) == 1) {
            print(flow_interp, "\n");
            fflush(stdout);
        }
        else {
            j = convert_int(argv[i], flow_interp);
            print(flow_interp, "%d ",j);
            fflush(stdout);
        }
    }

    flow_interp->PRLEVEL = k;
    return 0;
}
/*------------------------------------------------------------------*/



/*--------------------------------------------------------------------
    Function associated to the command 'echof'
--------------------------------------------------------------------*/
int
echo_float_cmd(int argc, char *argv[])
{
    int             i,
                    j;
    double          x;
    char            h[3];
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    h[0] = 92;
    h[1] = 110;
    h[2] = 0;
    j = flow_interp->PRLEVEL;
    flow_interp->PRLEVEL = -1;

    for (i = 1; i < argc; i++) {
        if (comp(argv[i], h) == 1) {
            print(flow_interp, "\n");
            fflush(stdout);
        }
        else {
            x = convert_float(argv[i], flow_interp);
            print(flow_interp, "%f ", x);
            fflush(stdout);
        }
    }

    flow_interp->PRLEVEL = j;
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'editor'
--------------------------------------------------------------------*/
int
editeur(int argc, char *argv[])
{
    char            h[2001],
                    w[200];
    int             i,
                    ilev;
    FILE           *s;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    strcpy(w, command_rep);
    strcat(w, argv[1]);
    s = fopen(w, "w");
    if (s == NULL) {
        err_mess(1);
        return 0;
    }

xxx : memset(h, 0, 2001);
    fgets(h, 1999, flow_interp->INP[flow_interp->CURVOICE]);
    ilev = 0;
    i = 0;
    while (h[i] == 92) {
        i++;
        ilev++;
    }
    if (ilev == flow_interp->CURVOICE + 1) {
        fclose(s);
        return 1;
    }
    fputs(h, s);
    goto xxx;
}
/*------------------------------------------------------------------*/



/*--------------------------------------------------------------------
    Function associated to the command 'delcom'
--------------------------------------------------------------------*/
int
delcom(int argc, char *argv[])
{
    char            w[200];

    memset(w, 0, 200);
    strcpy(w, command_rep);
    strcat(w, argv[1]);
    remove(w);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'delres'
--------------------------------------------------------------------*/
int
delres(int argc, char *argv[])
{
    char            w[200];

    memset(w, 0, 200);
    strcpy(w, result_rep);
    strcat(w, argv[1]);
    remove(w);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'deldat'
--------------------------------------------------------------------*/
int
deldon(int argc, char *argv[])
{
    char            w[200];

    memset(w, 0, 200);
    strcpy(w, data_rep);
    strcat(w, argv[1]);
    remove(w);
    return 0;
}
/*------------------------------------------------------------------*/



/*--------------------------------------------------------------------
    Function associated to the command 'si'
--------------------------------------------------------------------*/
int si_cmd(int argc, char *argv[])
{
    int             i;

    if (argc > 2 && comp(argv[1],"non") != 1) {
        err_mess(3);
        return 1;
    }
#ifdef _HAVE_THREADS
    pthread_mutex_lock(&mutex_cond);
#endif
    if (n_cond == __nbcond - 1) {
        err_mess(4);
#ifdef _HAVE_THREADS
        pthread_mutex_unlock(&mutex_cond);
#endif
        return 1;
    }
    n_cond++;
    memset(v_cond[n_cond], 0, 100);
    if (argc == 2) {
        s_cond[n_cond] = 1;
        i = 1;
    }
    else {
        s_cond[n_cond] = -1;
        i = 2;
    }
    strcpy(v_cond[n_cond], argv[i]);
#ifdef _HAVE_THREADS
    pthread_mutex_unlock(&mutex_cond);
#endif
    return 0;
}
/*------------------------------------------------------------------*/



/*--------------------------------------------------------------------
    Function associated to the command 'is'
--------------------------------------------------------------------*/
int is_cmd(int argc, char *argv[])
{
#ifdef _HAVE_THREADS
    pthread_mutex_lock(&mutex_cond);
#endif
    if (n_cond < 0) {
#ifdef _HAVE_THREADS
        pthread_mutex_unlock(&mutex_cond);
#endif
        return 0;
    }
    if (comp(v_cond[n_cond], argv[1]) != 1) {
#ifdef _HAVE_THREADS
        pthread_mutex_unlock(&mutex_cond);
#endif
        return 0;
    }
    n_cond--;
#ifdef _HAVE_THREADS
    pthread_mutex_unlock(&mutex_cond);
#endif
    return 0;
}
/*------------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Function associated to the command 'write'
-------------------------------------------------------------------*/
int
file_cmd(int argc, char *argv[])
{
    int             i,
                    i0;
    char            h[200];
    double          x;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    i0 = -1;
#ifdef _HAVE_THREADS
    pthread_mutex_lock(&mutex_file);
#endif

    for (i = 0; i < __nss; i++) {
        if (sS[i] != NULL) {
            if (comp(sS_nom[i], argv[1]) == 1) {
                i0 = i;
                if (sS_i_o[i0] != 1) {
                    err_mess(29);
#ifdef _HAVE_THREADS
                    pthread_mutex_unlock(&mutex_file);
#endif
                    return 1;
                }
            }
        }
    }

    if (i0 < 0) {
        for (i = 0; i < __nss; i++) {
            if (sS[i] == NULL) {
                i0 = i;
                break;
            }
        }

        if (i0 < 0) {
            err_mess(5);
#ifdef _HAVE_THREADS
            pthread_mutex_unlock(&mutex_file);
#endif
            return 1;
        }
        memset(h, 0, 200);
        sprintf(h, "%s%s", result_rep, argv[1]);
        sS[i0] = fopen(h, "a");
        if (sS[i0] == NULL) {
            err_mess(1);
#ifdef _HAVE_THREADS
            pthread_mutex_unlock(&mutex_file);
#endif
            return 1;
        }
        sS_nom[i0] = (char *) malloc( 100 * sizeof(char));
        sprintf(sS_nom[i0], "%s", argv[1]);
        sS_i_o[i0] = 1;
    }

    if (comp(argv[2],"_ligne") == 1) {
        fprintf(sS[i0], "\n");
#ifdef _HAVE_THREADS
        pthread_mutex_unlock(&mutex_file);
#endif
        return 0;
    }
    if (comp(argv[2],"-bin") == 1) {
        for (i = 3; i < argc; i++) {
            x = convert_float(argv[i], flow_interp);
            fwrite(&x, sizeof(double), 1 , sS[i0]);
        }
    }
    else {
        for (i = 2; i < argc; i++) {
            fprintf(sS[i0], "%f    ", convert_float(argv[i], flow_interp));
            sS_cmpt[i0]++;
            if (sS_cmpt[i0] > 9)
                fflush(sS[i0]);
        }

        fprintf(sS[i0], "\n");
    }

#ifdef _HAVE_THREADS
    pthread_mutex_unlock(&mutex_file);
#endif
    return 0;
}
/*------------------------------------------------------------------*/



/*-------------------------------------------------------------------
    Function associated to the command 'read'
-------------------------------------------------------------------*/
int
fread_cmd(int argc, char *argv[])
{
    int             i,
                    i0,
                    ind;
    char            h[200];
    double          x;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    i0 = -1;
#ifdef _HAVE_THREADS
    pthread_mutex_lock(&mutex_file);
#endif

    for (i = 0; i < __nss; i++) {
        if (sS[i] != NULL) {
            if (comp(sS_nom[i], argv[1]) == 1) {
                i0 = i;
                if (sS_i_o[i0] != -1) {
                    err_mess(30);
#ifdef _HAVE_THREADS
                    pthread_mutex_unlock(&mutex_file);
#endif
                    return 1;
                }
            }
        }
    }

    if (i0 < 0) {
        for (i = 0; i < __nss; i++) {
            if (sS[i] == NULL) {
                i0 = i;
                break;
            }
        }

        if (i0 < 0) {
            err_mess(5);
#ifdef _HAVE_THREADS
            pthread_mutex_unlock(&mutex_file);
#endif
            return 1;
        }
        memset(h, 0, 200);
        sprintf(h, "%s%s", result_rep, argv[1]);
        sS[i0] = fopen(h, "r");
        if (sS[i0] == NULL) {
            err_mess(1);
#ifdef _HAVE_THREADS
            pthread_mutex_unlock(&mutex_file);
#endif
            return 1;
        }
        sS_nom[i0] = (char *) malloc( 100 * sizeof(char));
        sprintf(sS_nom[i0], "%s", argv[1]);
        sS_i_o[i0] = -1;
    }

    x = 0.0;
    if (argc <= 3 || comp(argv[2],"-bin") != 1) {
        fscanf(sS[i0], "%lf", &x);
        memset(h, 0, 200);
        ind = 0;
    }
    else {
        fread(&x, sizeof(double), 1, sS[i0]);
        ind = 1;
    }
    sprintf(h, "%s=%f", argv[2 + ind], x);
    convert_float(h, flow_interp);
#ifdef _HAVE_THREADS
    pthread_mutex_unlock(&mutex_file);
#endif
    return 0;
}
/*------------------------------------------------------------------*/




/*-------------------------------------------------------------------
     Function associated to the command 'close'
--------------------------------------------------------------------*/
int
close_file_cmd(int argc, char *argv[])
{
    int             i,
                    i0;

    i0 = -1;

#ifdef _HAVE_THREADS
    pthread_mutex_lock(&mutex_file);
#endif
    for (i = 0; i < __nss; i++) {
        if (sS[i] != NULL) {
            if (comp(sS_nom[i], argv[1]) == 1)
                i0 = i;
        }
    }

    if (i0 < 0) {
        err_mess(6);
#ifdef _HAVE_THREADS
        pthread_mutex_unlock(&mutex_file);
#endif
        return 1;
    }
    fclose(sS[i0]);
    sS[i0] = NULL;
    free(sS_nom[i0]);
    sS_nom[i0] = NULL;
    sS_cmpt[i0] = 0;
    sS_i_o[i0] = 0;
#ifdef _HAVE_THREADS
    pthread_mutex_unlock(&mutex_file);
#endif
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'question'
--------------------------------------------------------------------*/
int
question_cmd(int argc, char *argv[])
{
    int             ii,
                    i,
                    j,
                    n_quest;
    FILE           *s;
    char            h[100],
                    k[300],
                    k2[300],
                   *v;
    float           x;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    if (argc >= 2) {
        memset(h, 0, 100);
        strcpy(h, command_rep);
        strcat(h, argv[1]);
        s = fopen(h, "r");
        if (s == NULL) {
            err_mess(1);
            return 1;
        }
        if (fscanf(s, "%d", &n_quest) == EOF) {
            err_mess(7);
            return 1;
        }
        if (n_quest < 1) {
            err_mess(2);
            return 1;
        }
        fgets(k, 299, s);

        for (j = 0; j < n_quest; j++) {
            memset(k, 0, 300);
            memset(k2, 0, 300);

            if (fgets(k, 299, s) == NULL) {
                err_mess(7);
                fclose(s);
                return 1;
            }
            if ((int) strlen(k) < 2) {
                err_mess(7);
                fclose(s);
                return 1;
            }
            nettoie(k);
            if (flow_interp->PRLEVEL <= 0) {
                print(flow_interp, "%s ", k);
            }
            memset(k, 0, 100);
            if (fgets(k, 299, s) == NULL) {
                err_mess(7);
                fclose(s);
                return 1;
            }
            nettoie(k);
            if (k[0] != '$') {
                scanf("%f", &x);
                sprintf(k2, "%s=%f", k, x);
                convert_float(k2, flow_interp);
            }
            else {
                if ((int) strlen(k) < 2) {
                    err_mess(7);
                    fclose(s);
                    return 1;
                }
                v = k + 1;
                ii = convert_int(v, flow_interp);
                if (ii < 0 || ii > __max_quest) {
                    err_mess(7);
                    fclose(s);
                    return 1;
                }
                memset(h, 0, 100);
                i = 0;

                while (i == 0) {
                    fgets(h, 299, flow_interp->INP[flow_interp->CURVOICE]);
                    nettoie(h);
                    if (strlen(h) > 0) {
#ifdef _HAVE_THREADS
                        pthread_mutex_lock(&mutex_quest);
#endif
                        memset(ques[ii], 0, 300);
                        strcpy(ques[ii], h);
#ifdef _HAVE_THREADS
                        pthread_mutex_unlock(&mutex_quest);
#endif
                        i = 1;
                    }
                }
            }
        }

        fclose(s);
        return 0;
    }
    else {
        read_int(&n_quest, flow_interp);
        if (n_quest <= 0) {
            err_mess(7);
            return 1;
        }

        for (j = 0; j < n_quest; j++) {
            memset(h, 0, 100);
            read_char(h, flow_interp);
            memset(k, 0, 100);
            read_char(k, flow_interp);
            v = k + 1;
            ii = convert_int(v, flow_interp);
            if (ii < 0 || ii > __max_quest) {
                err_mess(7);
                return 1;
            }
            if (strlen(h) > 0) {
#ifdef _HAVE_THREADS
                pthread_mutex_lock(&mutex_quest);
#endif
                memset(ques[ii], 0, 300);
                strcpy(ques[ii], h);
#ifdef _HAVE_THREADS
                pthread_mutex_unlock(&mutex_quest);
#endif
            }
        }
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'varlist'
---------------------------------------------------------------------*/
int
var_list_cmd(int argc, char *argv[])
{
    int             i,
                    j,
                    j0,
                    i0,
                    dum;
    flow_data      *flow_interp;
    char           *pr_gen,
                    c[3];
    void           *res_Gen;

    INIT_FLOW(flow_interp);
    c[0] = '@';
    c[1] = 0;
    c[2] = 0;

    j0 = 0;
    i0 = -1;
    if (argc > 1) {
        if (comp(argv[1], "all") == 1)
            j0 = 1;
        else
            i0 = convert_int(argv[1], flow_interp);
    }

    if (j0 == 1 || i0 <= 0 || i0 >= NB_expr_eval) {
        print(flow_interp, "Real numbers :\n");

        for (i = 0; i < MAXXVARS; i++) {
            if ((int) strlen(flow_interp->VARS[i].name) > 0) {
                if (flow_interp->PRLEVEL <= 0 && flow_interp->VARS[i].name[0] <
                    127) {
                    print(flow_interp, "%s = %f\n", flow_interp->VARS[i].name,
                        flow_interp->VARS[i].value);
                }
            }
        }

        for (i = 0; i < MAXXVARS; i++) {
            if ((int) strlen(VArs_global[i].name) > 0) {
                if (flow_interp->PRLEVEL <= 0 && VArs_global[i].name[0] < 127) {
                    print(flow_interp, "%s = %f\n", VArs_global[i].name,
                        VArs_global[i].value);
                }
            }
        }

        for (i = 0; i < 26; i++) {
            if (flow_interp->VARS2[i] != 0.) {
                c[1] = 'a' + i;
                print(flow_interp, "%s = %f\n", c, flow_interp->VARS2[i]);
            }
        }

        for (i = 0; i < 26; i++) {
            if (flow_interp->VARS2[i + 26] != 0.) {
                c[1] = 'A' + i;
                print(flow_interp, "%s = %f\n", c, flow_interp->VARS2[i + 26]);
            }
        }
    }
    if (j0 == 1 || i0 == 1) {
        print(flow_interp, "Complex numbers :\n");

        for (i = 0; i < MAXXVARS; i++) {
            if ((int) strlen(flow_interp->VARS_C[i].name) > 0) {
                if (flow_interp->PRLEVEL <= 0 &&
                    flow_interp->VARS_C[i].name[0] < 127) {
                    print(flow_interp, "%s = %f + %f.I\n",
                        flow_interp->VARS_C[i].name,
                            (flow_interp->VARS_C[i].value).r,
                                       (flow_interp->VARS_C[i].value).i);
                }
            }
        }

        for (i = 0; i < MAXXVARS; i++) {
            if ((int) strlen(VArs_global_C[i].name) > 0) {
                if (flow_interp->PRLEVEL <= 0 &&
                    VArs_global_C[i].name[0] < 127) {
                    print(flow_interp, "%s = %f + %f.I\n",
                        VArs_global_C[i].name, (VArs_global_C[i].value).r,
                            (VArs_global_C[i].value).i);
                }
            }
        }

        for (i = 0; i < 26; i++) {
            if ((flow_interp->VARS2_C[i].r) != 0. ||
                (flow_interp->VARS2_C[i].i) != 0.) {
                c[1] = 'a' + i;
                print(flow_interp, "%s = %f + %f.I\n", c,
                    (flow_interp->VARS2_C[i]).r, (flow_interp->VARS2_C[i]).i);
            }
        }

        for (i = 0; i < 26; i++) {
            if ((flow_interp->VARS2_C[i + 26].r) != 0. ||
                (flow_interp->VARS2_C[i + 26].i) != 0.) {
                c[1] = 'A' + i;
                print(flow_interp, "%s = %f + %f.I\n", c,
                    (flow_interp->VARS2_C[i + 26]).r,
                        (flow_interp->VARS2_C[i + 26]).i);
            }
        }
    }
    if (j0 == 1 || (i0 > 1 && i0 < NB_expr_eval)) {
        for (j = 0; j < NB_expr_eval - 2; j++) {
            if (j0 == 1 || i0 == j + 2) {
                print(flow_interp, "%s :\n", Expreval_ops[j].desc);

                for (i = 0; i < MAXXVARS; i++) {
                    if ((int) strlen(flow_interp->VARS_Gen[j][i].name) > 0) {
                        if (flow_interp->PRLEVEL <= 0 &&
                            flow_interp->VARS_Gen[j][i].name[0] < 127) {
                            res_Gen = NULL;
                            Evaluate_Gen(j,
                                flow_interp->VARS_Gen[j][i].name,
                                    &res_Gen, &dum, flow_interp);
                            if (res_Gen != NULL) {
                                pr_gen = Expreval_ops[j].print(res_Gen);
                                print(flow_interp, "%s = %s\n",
                                    flow_interp->VARS_Gen[j][i].name, pr_gen);
                                free(pr_gen);
                                Expreval_ops[j].clear(res_Gen);
                            }

                        }
                    }
                }

                for (i = 0; i < MAXXVARS; i++) {
                    if ((int) strlen(VArs_global_Gen[j][i].name) > 0) {
                        if (flow_interp->PRLEVEL <= 0 &&
                            VArs_global_Gen[j][i].name[0] < 127) {
                             res_Gen = NULL;
                            Evaluate_Gen(j, VArs_global_Gen[j][i].name,
                                &res_Gen, &dum, flow_interp);
                            if (res_Gen != NULL) {
                                pr_gen = Expreval_ops[j].print(res_Gen);
                                print(flow_interp, "%s = %s\n",
                                    VArs_global_Gen[j][i].name, pr_gen);
                                free(pr_gen);
                                Expreval_ops[j].clear(res_Gen);
                            }
                        }
                    }
                }

                for (i = 0; i < 26; i++) {
                    if (Expreval_ops[j].
                        iszero(flow_interp->VARS2_Gen[j][i].value[0]) == 0) {
                        c[1] = 'a' + i;
                         res_Gen = NULL;
                        Evaluate_Gen(j,
                            flow_interp->VARS2_Gen[j][i].name,
                                &res_Gen, &dum, flow_interp);
                        if (res_Gen != NULL) {
                            pr_gen = Expreval_ops[j].print(res_Gen);
                            print(flow_interp, "%s = %s\n", c, pr_gen);
                            free(pr_gen);
                            Expreval_ops[j].clear(res_Gen);
                        }
                    }
                }

                for (i = 0; i < 26; i++) {
                    if (Expreval_ops[j].iszero(
                        flow_interp->VARS2_Gen[j][i + 26].value[0]) == 0) {
                        c[1] = 'A' + i;
                          res_Gen = NULL;
                        Evaluate_Gen(j,
                            flow_interp->VARS2_Gen[j][i + 26].name,
                                &res_Gen, &dum, flow_interp);
                        if (res_Gen != NULL) {
                            pr_gen = Expreval_ops[j].print(res_Gen);
                            print(flow_interp, "%s = %s\n", c, pr_gen);
                            free(pr_gen);
                            Expreval_ops[j].clear(res_Gen);
                        }
                    }
                }
            }
        }
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*-------------------------------------------------------------------
-------------------------------------------------------------------*/
int
undef_VARS(char *name,  XVARIABLE *Va)
{
    int             i,
                    j,
                    k,
                    n;

    n = -1;
    for (i = 0; i < MAXXVARS; i++)
        if (Va[i].name[0] != 0)
            n = i;

    for (i = 0; i < n; i++) {
        if (Va[i].name[0] == 0) {
            for (j = i + 1; j <= n; j++) {
                for (k = 0; k <= XVARLEN; k++)
                    Va[j - 1].name[k] = Va[j].name[k];
                Va[j - 1].value = Va[j].value;
            }

        for (k = 0; k <= XVARLEN; k++)
            Va[n].name[k] = 0;
        n--;
        }
    }

    for (i = 0; i <= n; i++) {
        if (comp(name, Va[i].name) == 1) {
            for (j = i + 1; j <= n; j++) {
                for (k = 0; k <= XVARLEN; k++)
                    Va[j - 1].name[k] = Va[j].name[k];
                Va[j - 1].value = Va[j].value;
            }

            for (k = 0; k <= XVARLEN; k++)
                Va[n].name[k] = 0;
            Va[n].value = 0.;
            return i + 1;
        }
    }

    return 0;
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Function associated to the command 'undef'
--------------------------------------------------------------------*/
int
undef_cmd(int argc, char *argv[])
{
    int             i;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    if (argv[1][0] == '*') {
        for (i = 0; i < MAXXVARS; i++) {
            memset(flow_interp->VARS[i].name, 0, XVARLEN + 1);
            flow_interp->VARS[i].value = 0.;
        }

        if (comp(argv[1], "**") == 1) {
            for (i = 0; i < MAXXVARS; i++) {
                if (VArs_global[i].name[0] != 127) {
                    memset(VArs_global[i].name, 0, XVARLEN + 1);
                    VArs_global[i].value = 0.;
                }
            }
        }
        return 0;
    }
    else {
        if (undef_VARS(argv[1], flow_interp->VARS) == 0) {
            if (undef_VARS(argv[1], VArs_global) == 0) {
                err_mess(55);
                return 1;
            }
            else
                return 0;
        }
    }

    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'silence'
--------------------------------------------------------------------*/
int
silence_cmd(int argc, char *argv[])
{
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    if (convert_int(argv[1], flow_interp) == 0)
        flow_interp->PRLEVEL = 1;
    else flow_interp->PRLEVEL = 0;

    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'send_print'
--------------------------------------------------------------------*/
int
send_print_cmd(int argc, char *argv[])
{
    flow_data      *flow_interp;
    int             i;
    Misc_Func      *Mi;

    INIT_FLOW(flow_interp);
    Mi = (Misc_Func *) flow_interp->extra[0];
    i = convert_int(argv[1], flow_interp);
    if (i == -1)
        Mi->Print = null_print;
    if (i == 0)
        Mi->Print = NULL;

    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'clock'
--------------------------------------------------------------------*/
int
temps(int argc, char *argv[])
{
    int             i;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    i = convert_int(argv[1], flow_interp);
    flow_interp->HORLOGE = 0;
    if (i != 0)
        flow_interp->HORLOGE = 1;
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'proglist'
--------------------------------------------------------------------*/
int
proglist_cmd(int argc, char *argv[])
{
    int             i,
                    j,
                    l;
    char            h[200],
                    k[20],
                   *v;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    if (flow_interp->PRLEVEL > 0)
        return 0;
    if (argc == 1) {
        for (i = 0; i < nb_com; i++) {
            if (Is_visible_prog[i] == 1)
                print(flow_interp, "%s\n", nom_com[i]);
        }
        return 0;
    }

    for (i = 0; i < nb_com; i++) {
        if (Is_visible_prog[i] == 1 && comp(nom_com[i], argv[1]) == 1) {
            for (j = 0; j < nb_lignes[i]; j++) {
                memset(h, 0, 200);

                for (l = 0; l < nb_label[i]; l++)
                    if (num_label[i][l] == j) {
                        memset(k, 0, 20);
                        sprintf(k, "%d: \n", l);
                       /* strcat(h, k);*/
                        printf(k);
                    }

                v = ligne_com[i][j];
                if (ligne_com[i][j][0] == _GOTO) {
                    v = ligne_com[i][j] + 1;
                    strcat(h, "goto ");
                }
                if (ligne_com[i][j][0] == _IFGT) {
                    v = ligne_com[i][j] + 1;
                    strcat(h, "if>");
                }
                if (ligne_com[i][j][0] == _IFLT) {
                    v = ligne_com[i][j] + 1;
                    strcat(h, "if<");
                }
                if (ligne_com[i][j][0] == _IFEQ) {
                    v = ligne_com[i][j] + 1;
                    strcat(h, "if=");
                }
                if (ligne_com[i][j][0] == _EVAL) {
                    v = ligne_com[i][j] + 1;
                }
                strcat(h, v);
                print(flow_interp, "%s\n", h);
            }

            memset(h, 0, 200);

            for (l = 0; l < nb_label[i]; l++)
                if (num_label[i][l] >= nb_lignes[i]) {
                    memset(k, 0, 20);
                    sprintf(k, "%d: ", l);
                    strcat(h, k);
                }

            if ((int) strlen(h) > 0) {
                print(flow_interp, "%s\n", h);
            }
            return 0;
        }
    }
    err_mess(24);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'load'
--------------------------------------------------------------------*/
int
load_cmd(int argc, char *argv[])
{
    char            h[400];
    flow_data      *flow_interp;

    if (argc > 0) {
        flow_interp = (flow_data *) argv[-1];
        if (num_thread_run > 0) {
            err_mess(40);
            return 1;
        }
        if (flow_interp->num != 0) {
            err_mess(39);
            return 1;
        }
        memset(h, 0, 400);
        strcpy(h, command_rep);
        strcat(h, argv[1]);
        charge_com(h, NULL, 0, 0, flow_interp, NULL, 1);
    }
    else {
        flow_interp = &flow_I[0];
        charge_com(NULL, argv[1], strlen(argv[1]), 1, flow_interp, NULL, 1);
    }
    traite_label(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
int
loadcmd(char *W)
{
    char           *argv[3];

    argv[0] = (char *) &flow_I[0];
    argv[1] = NULL;
    argv[2] = W;
    return load_cmd(2, argv + 1);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'shell'
--------------------------------------------------------------------*/
int
shell_cmd(int argc, char *argv[])
{
    char            h[300];
    int             i;

    memset(h, 0, 300);

    for (i = 1; i < argc; i++) {
        strcat(h, argv[i]);
        strcat(h, " ");
    }

    system(h);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function that shows the hidden variables of the Expr.Ev.
--------------------------------------------------------------------*/
void
init_var(flow_data *flow_interp)
{
    int             i;
    char            h[100],
                   *k;

    for (i = 0; i < MAXXVARS; i++) {
        if ((int) strlen(VArs_global[i].name) > 0) {
            if (VArs_global[i].name[0] == 127) {
                memset(h, 0, 100);
                k = VArs_global[i].name + 1;
                strcpy(h, k);
                strcat(h, "=");
                strcat(h, VArs_global[i].name);
                convert_int(h, flow_interp);
            }
        }
    }
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'initvar'
--------------------------------------------------------------------*/
int
init_var_cmd(int argc, char *argv[])
{
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    init_var(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'numcom'
--------------------------------------------------------------------*/
int
num_com(int argc, char *argv[])
{
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    if (convert_int(argv[1], flow_interp) != 0)
        flow_interp->PR_COM = 1;
    else
        flow_interp->PR_COM = 0;
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'hist'
--------------------------------------------------------------------*/
int
hist_cmd(int argc, char *argv[])
{
    int             i,
                    j;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    j = flow_interp->I_COM + 1;

    for (i = 0; i < __n_com_prec; i++) {
        j--;
        if (j < 0)
            j = __n_com_prec - 1;
        if (flow_interp->IX_COM - i > 0 && flow_interp->PRLEVEL <= 0) {
            print(flow_interp, "    %d    %s\n", flow_interp->IX_COM - i - 1,
                flow_interp->COM_PREC[j]);
        }
    }

    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'mon'
--------------------------------------------------------------------*/
int
mon_cmd(int argc, char *argv[])
{
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    if (flow_interp->MON_FILE != NULL)
        fclose(flow_interp->MON_FILE);
    flow_interp->MON_FILE = fopen(argv[1], "w");
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'end_mon'
--------------------------------------------------------------------*/
int
fin_mon_cmd(int argc, char *argv[])
{
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    if (flow_interp->MON_FILE != NULL)
        fclose(flow_interp->MON_FILE);
    flow_interp->MON_FILE = NULL;
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    clone of 'printf' that prints also in a monitor file
--------------------------------------------------------------------*/
void
print(flow_data *flow_interp, char *fo, ...)
{
    va_list         ap;
    int             i,
                    i_val,
                    icmpt,
                    icmpt2,
                    n_arg,
                    len,
                    len2;
    double          f_val;
    char           *pr,
                    h[100],
                   *k;
    Misc_Func      *Mi;

    Mi = (Misc_Func *) flow_interp->extra[0];
    va_start(ap, fo);
    pr = NULL;
    k = NULL;
    if (flow_interp->PRLEVEL > 0)
        goto fin;
    len = strlen(fo);
    n_arg = 0;
    for (i = 0; i < len; i++)
        if (fo[i] == '%')
            n_arg++;
    if (n_arg == 0) {
        pr = ch_copy(fo);
        goto impr;
    }

    pr = (char *) malloc(250 * sizeof(char));
    memset(pr, 0, 250);
    len2 = 248;
    icmpt = 0;
    icmpt2 = 0;

    for (i = 0; i < n_arg; i++) {
        while (fo[icmpt] != '%') {
            pr[icmpt2++] = fo[icmpt++];
        }

        icmpt++;
        if (icmpt > len)
            goto fin;

        if (fo[icmpt] !=  's' && fo[icmpt] != 'd' && fo[icmpt] != 'f')
            goto fin;
        if (fo[icmpt] == 's') {
            k = va_arg(ap, char*);
        }
        if (fo[icmpt] == 'd') {
            memset(h, 0, 100);
            i_val = va_arg(ap, int);
            sprintf(h, "%d", i_val);
            k = h;
        }
        if (fo[icmpt] == 'f') {
            memset(h, 0, 100);
            f_val = va_arg(ap, double);
            sprintf(h, "%.16g", f_val);
            k = h;
        }
        icmpt++;
        icmpt2 += strlen(k);
        if (icmpt2 > len2) {
            len2 = icmpt2;
            pr = (char *) realloc(pr, len2 + 2);
        }
        strcat(pr, k);
    }

    if (len2 - icmpt2 <= len - icmpt)
        pr = (char *) realloc(pr, len2 + len);

    for (i = icmpt; i < len; i++) {
        pr[icmpt2] = fo[i];
        icmpt2++;
    }

    pr[icmpt2] = 0;

impr : if (Mi->Print == NULL)
        printf(pr);
    else
        extern_print(flow_interp, pr);
    if (flow_interp->MON_FILE != NULL)
        fprintf(flow_interp->MON_FILE, pr);

fin : if (pr != NULL)
        free(pr);
    va_end(ap);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Null printing
--------------------------------------------------------------------*/
void
null_print(flow_data *flow_interp, char *pr)
{
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Printing on an external device
--------------------------------------------------------------------*/
void
extern_print(flow_data *flow_interp, char *pr)
{
    Misc_Func      *Mi;

    Mi = (Misc_Func *) flow_interp->extra[0];
    (Mi->Print)(flow_interp, pr);
}
/*------------------------------------------------------------------*/



/*--------------------------------------------------------------------
    Function associated to the command 'flush'
--------------------------------------------------------------------*/
int
flush_cmd(int argc, char *argv[])
{
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    if (flow_interp->MON_FILE != NULL)
        fflush(flow_interp->MON_FILE);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'greet'
--------------------------------------------------------------------*/
int
greetb_cmd(int argc, char *argv[])
{
    int             i;

    for (i = 0; i < i_greet; i++)
        printf("%s\n", greet[i]);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function printing the message i on screen
--------------------------------------------------------------------*/
void
error_mess(flow_data *flow_interp, int i)
{
    print(flow_interp, "                      ; %s\n", mess[i]);
    if (flow_interp->MON_FILE != NULL)
        fprintf(flow_interp->MON_FILE, "                         ; %s\n",
            mess[i]);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function opening a file whose name has two parts
--------------------------------------------------------------------*/
FILE
*Copen(char *debut, char *fin, char *format)
{
    char            h[200];

    memset(h, 0, 200);
    strcpy(h, debut);
    strcat(h, fin);
    return fopen(h, format);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function opening a file whose name has three parts
--------------------------------------------------------------------*/
FILE
*CCopen(char *debut, char *milieu, char *fin, char *format)
{
    char            h[200];

    memset(h, 0, 200);
    sprintf(h, "%s%s%s", debut, milieu, fin);
    return fopen(h, format);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function opening a file whose name is made with two character
    strings and an integer
--------------------------------------------------------------------*/
FILE
*CIopen(char *debut, char *fin, char *format, int i)
{
    char            h[200];

    memset(h, 0, 200);
    sprintf(h, "%s.%s.%d", debut, fin, i);
    return fopen(h, format);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'time'
--------------------------------------------------------------------*/
int
time_cmd(int argc, char *argv[])
{
    long            i;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    if (argc > 1)
        time(&flow_interp->_I_TIME_X);
    else {
        time(&i);
#ifdef _ENG_LANG
        print(flow_interp, "Time : %d s\n", i - flow_interp->_I_TIME_X);
#else
        print(flow_interp, "Temps : %d s\n", i - flow_interp->_I_TIME_X);
#endif
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'setdir'
--------------------------------------------------------------------*/
int
setdir_cmd(int argc, char *argv[])
{
    int             i;
    char            h[100];

    i = strlen(argv[2]);
    if (i > 78) {
        err_mess(34);
        return 1;
    }
    memset(h, 0, 100);
    strcpy(h, argv[2]);
    if (h[i - 1] != '/')
        h[i] = '/';
    if (comp(argv[1], "com") == 1) {
        memset(command_rep, 0, 80);
        strcpy(command_rep, h);
    }
    else {
        if (comp(argv[1], "data") == 1) {
            memset(data_rep, 0, 80);
            strcpy(data_rep, h);
        }
        else {
            if (comp(argv[1], "data2") == 1) {
                memset(data_rep2, 0, 80);
                strcpy(data_rep2, h);
            }
            else {
                if (comp(argv[1], "res") == 1) {
                    memset(result_rep, 0, 80);
                    strcpy(result_rep, h);
                }
                else {
                    err_mess(33);
                    return 1;
                }
            }
        }
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'string'
--------------------------------------------------------------------*/
int
setstring_cmd(int argc, char *argv[])
{
    int             i,
                    i0;

    i0 = -1;

    if (comp(argv[1], "RESDIR") == 1 || comp(argv[1], "COMDIR") == 1 ||
        comp(argv[1], "DATADIR") == 1 || comp(argv[1], "DATA2DIR") == 1 ||
        comp(argv[1], "THREAD") == 1 || comp(argv[1], "PWD") == 1) {
        err_mess(41);
        return 1;
    }
#ifdef _HAVE_THREADS
    pthread_mutex_lock(&mutex_string);
#endif
    for (i = 0; i < __max_Env_st; i++) {
        if (Env_string[i] != NULL) {
            if (comp(Env_string[i], argv[1]) == 1) {
                i0 = i;
                break;
            }
        }
    }

    if (i0 == -1) {
        for (i = 0; i < __max_Env_st; i++) {
            if (Env_string[i] == NULL) {
                i0 = i;
                break;
            }
        }
    }
    else {
        err_mess(41);
#ifdef _HAVE_THREADS
        pthread_mutex_unlock(&mutex_string);
#endif
        return 1;
    }

    if (i0 == -1) {
#ifdef _HAVE_THREADS
        pthread_mutex_unlock(&mutex_string);
#endif
        err_mess(37);
        return 1;
    }

    if (Env_string[i0] != NULL) {
        free(Env_string[i0]);
        free(Env_string2[i0]);
    }
    Env_string[i0] = ch_copy(argv[1]);
    Env_string2[i0] = ch_copy(argv[2]);
#ifdef _HAVE_THREADS
    pthread_mutex_unlock(&mutex_string);
#endif
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'delstring'
--------------------------------------------------------------------*/
int
delstring_cmd(int argc, char *argv[])
{
    int             i;

    if (comp(argv[1], "RESDIR") == 1 || comp(argv[1], "COMDIR") == 1 ||
        comp(argv[1], "DATADIR") == 1 || comp(argv[1], "DATA2DIR") == 1 ||
        comp(argv[1], "THREAD") == 1 || comp(argv[1], "PWD") == 1) {
        return 0;
    }
#ifdef _HAVE_THREADS
    pthread_mutex_lock(&mutex_string);
#endif

    for (i = 0; i < __max_Env_st; i++) {
        if (Env_string[i] != NULL)
            if (comp(Env_string[i], argv[1]) == 1) {
                free(Env_string[i]);
                free(Env_string2[i]);
                Env_string[i] = NULL;
                Env_string2[i] = NULL;
                break;
            }
    }

    if (i >= __max_Env_st) {
        err_mess(38);
        return 1;
    }
#ifdef _HAVE_THREADS
    pthread_mutex_unlock(&mutex_string);
#endif
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'list_str'
--------------------------------------------------------------------*/
int
liststring_cmd(int argc, char *argv[])
{
    int             i;
    char            X_pwd[1000];
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    memset(X_pwd, 0, 1000);
    print(flow_interp, "RESDIR = %s\n", result_rep);
    print(flow_interp, "COMDIR = %s\n", command_rep);
    print(flow_interp, "DATADIR = %s\n", data_rep);
    print(flow_interp, "DATA2DIR = %s\n", data_rep2);
    print(flow_interp, "THREAD = %s\n", flow_interp->name);
    if (getcwd(X_pwd, 1000) != NULL)
        print(flow_interp, "PWD = %s\n", X_pwd);
#ifdef _HAVE_THREADS
    pthread_mutex_lock(&mutex_string);
#endif

    for (i = 0; i < __max_Env_st; i++) {
        if (Env_string[i] != NULL)
            print(flow_interp, "%s = %s\n", Env_string[i], Env_string2[i]);
    }
#ifdef _HAVE_THREADS
    pthread_mutex_unlock(&mutex_string);
#endif

    return 0;
}
/*------------------------------------------------------------------*/
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'ch_expr'
    changing the current expression evaluator
--------------------------------------------------------------------*/
int
ch_expr_cmd(int argc, char *argv[])
{
    int             i;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    i = convert_int(argv[1], flow_interp);
    if (i < 0 || i >= NB_expr_eval) {
        err_mess(60);
        return 1;
    }
    flow_interp->expr_ev = i;
    if (i > 1)
        print(flow_interp, "%s\n", Expreval_ops[i - 2].desc);
    if (i == 1)
        print(flow_interp, "Complex numbers\n");
    return 0;
}
/*------------------------------------------------------------------*/
