/*************************************************************************
** interpcom-2.3   (command interpreter)                                 **
** objdef.c : Creation and manipulation of 'objects' and 'structures'    **
**                                                                       **
** Copyright (C) 2001  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**                                                                       **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details.                     **
**                                                                       **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free           **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      Aile 45-55                                                       **
**      2, place Jussieu                                                 **
**      75251 Paris Cedex 05                                             **
**      France                                                           **
**                                                                       **
 *************************************************************************/

#include "interp.h"


/*--------------------------------------------------------------------
    Function associated to the section '!def' of an initialization
    file
--------------------------------------------------------------------*/
int
objdef_cmd(FILE *s, char *name_c, flow_data *flow_interp)
{
    int             slen,
                    i,
                    j,
                    l,
                   *n_o,
                    ntyp,
                   *nb_dim,
                   *categ,
                   *alias_;
    char            h_ligne[100],
                  **comment,
                  **name_com,
                 ***n_dim,
                  **name_alias,
                    k[100],
                    arg_n0[100];

    ntyp = -1;
    n_o = int_alloc1(__nbtypmax);
    nb_dim = int_alloc1(__nbtypmax);
    categ = int_alloc1(__nbtypmax);
    alias_ = int_alloc1(__nbtypmax);

    comment = (char **)malloc((size_t) __nbtypmax * sizeof(char *));
    comment[0] = (char *)malloc((size_t) __nbtypmax * 100 * sizeof(char));
    for (i = 1; i < __nbtypmax; i++)
        comment[i] = comment[i - 1] + 100;
    name_alias = (char **)malloc((size_t) __nbtypmax * sizeof(char *));
    name_alias[0] = (char *)malloc((size_t) __nbtypmax * 100 * sizeof(char));
    for (i = 1; i < __nbtypmax; i++)
        name_alias[i] = name_alias[i - 1] + 100;
    name_com = (char **)malloc((size_t) __nbtypmax * sizeof(char *));
    name_com[0] = (char *)malloc((size_t) __nbtypmax * 100 * sizeof(char));
    for (i = 1; i < __nbtypmax; i++)
        name_com[i] = name_com[i - 1] + 100;
    n_dim = (char ***)malloc((size_t) __nbtypmax * sizeof(char **));
    for (i = 0; i < __nbtypmax; i++)
        n_dim[i] = NULL;

    for (i = 0; i < __nbtypmax; i++) {
        memset(comment[i], 0, 100);
        memset(name_com[i], 0, 100);
    }

    memset(h_ligne, 0, 100);

    while (fgets_count(h_ligne, 99, s) != NULL) {
        if (h_ligne[0] == '.')
            goto xxx;
        if (h_ligne[0] != ';') {

/*-------------------------------------
    Name of the command creating objects
-------------------------------------*/
            slen = strlen(h_ligne) - 1;
            if (slen < 2) {
                err_mess(8);
                exit_interp("def");
            }
            ntyp++;
            if (ntyp >= __nbtypmax) {
                err_mess(49);
                exit_interp("def");
            }
            h_ligne[slen] = 0;
            memcpy(name_com[ntyp], h_ligne, slen + 1);

            memset(h_ligne, 0, 100);
            if (fgets_count(h_ligne, 99, s) == NULL)
                exit_interp("def");
            nettoie(h_ligne);
            slen = strlen(h_ligne);

/*-------------------------------------
    Detection of 'alias'
-------------------------------------*/
            memset(arg_n0, 0, 100);
            i = 0;
            while (i < slen) {
                if (h_ligne[i] == ' ')
                    break;
                arg_n0[i] = h_ligne[i++];
            }
            if (comp(arg_n0, "alias") == 1) {
                memset(name_alias[ntyp], 0, 100);
                l = -1;
                for (j = i + 1; j  < slen; j++)
                    if (h_ligne[j] != ' ') {
                        name_alias[ntyp][++l] = h_ligne[j];
                    }
                alias_[ntyp] = 1;
                memset(h_ligne, 0, 100);
                if (fgets_count(h_ligne, 99, s) == NULL)
                    exit_interp("def");
                memcpy(comment[ntyp], h_ligne, strlen(h_ligne) - 1);
                continue;
            }

/*-------------------------------------
    Running modes
-------------------------------------*/
            i = 0;
            j = -1;
            memset(k, 0, 100);

            while (i < slen) {
                if (h_ligne[i] != ' ') {
                    j++;
                    k[j] = h_ligne[i];
                    i++;
                }
                if (h_ligne[i] == ' ' || i == slen) {
                    if ((int) strlen(k) > 0) {
                        j = convert_int(k, flow_interp);
                        if (j < 0)
                            for (l = 0; l < __nmode_fonc; l++)
                                mode_com_obj[ntyp + nb_typ][l] = 1;
                        else
                            if (j < __nmode_fonc)
                                mode_com_obj[ntyp + nb_typ][j] = 1;
                        memset(k, 0, 100);
                        j = -1;
                    }
                    i++;
                }
            }

/*------------------------------------
    Type of variables
------------------------------------*/
            memset(h_ligne, 0, 100);
            if (fgets_count(h_ligne, 99, s) == NULL)
                exit_interp("def");
            nettoie(h_ligne);
            categ[ntyp] = convert_int(h_ligne, flow_interp);
            if (categ[ntyp] < 0 || categ[ntyp] > 7) {
                err_mess(48);
                exit_interp("def");
            }


/*------------------------------------
    Number of dimensions
------------------------------------*/
            memset(h_ligne, 0, 100);
            if (fgets_count(h_ligne, 99, s) == NULL)
                exit_interp("def");
            nettoie(h_ligne);
            nb_dim[ntyp] = convert_int(h_ligne, flow_interp);
            if (nb_dim[ntyp] <= 0 || (categ[ntyp] == 7 && nb_dim[ntyp] != 1)) {
                err_mess(50);
                exit_interp("def");
            }


/*------------------------------------
    Description of the objects
------------------------------------*/
            memset(h_ligne, 0, 100);
            if (fgets_count(h_ligne, 99, s) == NULL)
                exit_interp("def");
            memcpy(comment[ntyp], h_ligne, strlen(h_ligne) - 1);


/*------------------------------------
    Names of the dimensions
------------------------------------*/
            n_dim[ntyp] = (char **) malloc((size_t) nb_dim[ntyp] *
                sizeof(char *));

            for (i = 0; i < nb_dim[ntyp]; i++) {
                memset(h_ligne, 0, 100);
                if (fgets_count(h_ligne, 99, s) == NULL)
                    exit_interp("def");
                nettoie(h_ligne);
                n_dim[ntyp][i] = ch_copy(h_ligne);
            }


/*-----------------------------------
    Maximal number of objects
-----------------------------------*/
            memset(h_ligne, 0, 100);
            if (fgets_count(h_ligne, 99, s) == NULL)
                exit_interp("def");
            nettoie(h_ligne);
            n_o[ntyp] = S_convert_int(h_ligne, flow_interp);
            if (n_o[ntyp] <= 0) {
                err_mess(51);
                exit_interp("def");
            }
            memset(h_ligne, 0, 100);
        }
    }

xxx: ntyp++;

    for (i = 0; i < ntyp; i++) {

        if (alias_[i] == 0) {  /* Case of non-aliases */
            Obj_alias[i + nb_typ] = i;

/*-------- Number of objects of type i -------------*/
            Obj_typ[i + nb_typ].nombre = n_o[i];
/*--------------------------------------------------*/

/*-------- Number of dimensions of objects i -------*/
            Obj_typ[i + nb_typ].nbdim = nb_dim[i];
/*--------------------------------------------------*/

/*------ Type of variables of objects i ------------*/
            Obj_typ[i + nb_typ].type = categ[i];
/*--------------------------------------------------*/

/*--- Names of the dimensions ----------------------*/
            Obj_typ[i + nb_typ].nom_dim = (char **) malloc((size_t) nb_dim[i]
                * sizeof(char *));
            for (j = 0; j < nb_dim[i]; j++)
                (Obj_typ[i + nb_typ].nom_dim)[j] = ch_copy(n_dim[i][j]);
/*-------------------------------------------------*/


/*---------- Name of the objects i ----------------*/
            Obj_typ[i + nb_typ].nom = ch_copy(name_com[i]);
/*-------------------------------------------------*/


/*---------- Comment ------------------------------*/
            Obj_typ[i + nb_typ].comment = ch_copy(comment[i]);
/*-------------------------------------------------*/


/*---------- Creation of the array of objects -----*/
            Obj[i + nb_typ] = (obj *) malloc((size_t) n_o[i] * sizeof(obj));
/*-------------------------------------------------*/


/*-------------------------------------------------*/
            for (j = 0; j < n_o[i]; j++) {
                Obj[i + nb_typ][j].typ_obj = &Obj_typ[i];
                Obj[i + nb_typ][j].occup = 0;
            }
/*-------------------------------------------------*/

            Obj_typ[i + nb_typ].alias = NULL;
        }
        else {  /* Case of aliases */
            l = -1;
            for (j = 0; j < i + nb_typ; j++)
                if (comp(name_alias[i], Obj_typ[j].nom) == 1)
                    l = j;
            if (l == -1) {
                err_mess(52);
                exit_interp("def");
            }
            Obj_alias[i + nb_typ] = l;
            Obj_typ[i + nb_typ].nombre = Obj_typ[l].nombre;
            Obj_typ[i + nb_typ].nbdim = Obj_typ[l].nbdim;
            Obj_typ[i + nb_typ].type = Obj_typ[l].type;
            Obj_typ[i + nb_typ].nom_dim = (char **) malloc((size_t)
                Obj_typ[l].nbdim * sizeof(char *));
            for (j = 0; j < Obj_typ[l].nbdim; j++)
                (Obj_typ[i + nb_typ].nom_dim)[j] =
                    ch_copy((Obj_typ[l].nom_dim)[j]);
            Obj_typ[i + nb_typ].nom = ch_copy(name_com[i]);
            Obj_typ[i + nb_typ].comment = ch_copy(comment[i]);
            Obj[i + nb_typ] = (obj *) malloc((size_t) Obj_typ[l].nombre *
                sizeof(obj));

            for (j = 0; j < Obj_typ[l].nombre; j++) {
                Obj[i + nb_typ][j].typ_obj = &Obj_typ[i + nb_typ];
                Obj[i + nb_typ][j].occup = 0;
            }

            for (j = 0; j < __nmode_fonc; j++)
                mode_com_obj[i + nb_typ][j] = mode_com_obj[l][j];
            Obj_typ[i + nb_typ].alias = (char *) &Obj_typ[l];
        }

/*---------- Creation of the program that
             creates objects i --------------------*/
        make_com(name_com[i], i + nb_typ, mode_com_obj[i + nb_typ]);
/*-------------------------------------------------*/
    }

    nb_typ += ntyp;
    free(comment[0]);
    free(comment);
    free(name_com[0]);
    free(name_com);
    free(name_alias[0]);
    free(name_alias);

    for (i = 0; i < ntyp; i++) {
        if (n_dim[i] != NULL) {
            for (j = 0; j < nb_dim[i]; j++)
                free(n_dim[i][j]);
            free(n_dim[i]);
        }
    }

    free(n_dim);
    XFREE(n_o);
    XFREE(nb_dim);
    XFREE(categ);
    XFREE(alias_);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Suppression of the last character of a string
--------------------------------------------------------------------*/
void
nettoie(char *h)
{
    h[strlen(h) - 1] = 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Creation of a copy of a character string
--------------------------------------------------------------------*/
char *
ch_copy(char *s)
{
    char           *t;
    int             slen;

    slen = strlen(s);
    t = (char *) malloc((size_t) (slen + 1) * sizeof(char));
    memcpy(t, s, slen);
    t[slen] = 0;
    return t;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Returns a string containing the integer argument.
--------------------------------------------------------------------*/
char *
ch_copy_int(int i0)
{
    char            h[20];

    memset(h, 0, 20);
    sprintf(h, "%d", i0);
    return ch_copy(h);
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    Returns a string containing the float argument.
--------------------------------------------------------------------*/
char *
ch_copy_float(double x0)
{
    char            h[100];

    memset(h, 0, 100);
    sprintf(h, "%.16g", x0);
    return ch_copy(h);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function called by 'objdef_cmd'. Creates a program that
    creates objects of type 'ind' with the command name_c
--------------------------------------------------------------------*/
void
make_com(char *name_c, int ind, int *mode_c)
{
    int             n,
                    i;
    char            h[10];

    memset(h, 0, 10);
    nb_com++;
    nom_com[nb_com - 1] = ch_copy(name_c);
    nb_par[nb_com - 1] = 1;
    sil_com[nb_com - 1] = 0;
    nb_lignes[nb_com - 1] = 1;
    for (i = 0; i < __nmode_fonc; i++)
        mode_com_int[nb_com - 1][i] = mode_c[i];
    ligne_com[nb_com - 1][0] = (char *) malloc((size_t) 80 * sizeof(char));
    memset(ligne_com[nb_com - 1][0], 0, 80);
    sprintf(ligne_com[nb_com - 1][0],"objdef");
    ligne_com[nb_com - 1][0][6] = 32;
    sprintf(h, "%d", ind);
    strcat(ligne_com[nb_com - 1][0], h);
    n = strlen(h) + 6;
    ligne_com[nb_com - 1][0][++n] = 32;
    ligne_com[nb_com - 1][0][++n] = '#';
    ligne_com[nb_com - 1][0][++n] = '1';
    Argc_com[nb_com - 1][0] = 3;
    Argv_com[nb_com - 1][0] = (char **) malloc((size_t) (__nbargmax + 2) *
        sizeof(char *));
    for (i = 3; i < __nbargmax + 2; i++)
        Argv_com[nb_com - 1][0][i] = NULL;
    Argv_com[nb_com - 1][0][0] = ch_copy("objdef");
    Argv_com[nb_com - 1][0][1] = ch_copy_int(ind);
    Argv_com[nb_com - 1][0][2] = ch_copy("#1");
    Is_subst_arg[nb_com - 1][0] = (int *) malloc((size_t) 3 * sizeof(int));
    Is_subst_ligne[nb_com - 1][0] = 1;
    Is_subst_arg[nb_com - 1][0][2] = 1;
    Is_Del_prog[nb_com - 1] = 0;
    Is_visible_prog[nb_com - 1] = 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Locks mutex used in functions using 'objects' and 'structures'
--------------------------------------------------------------------*/
void
PTHREAD_LOCK_OBJ(flow_data *flow_interp)
{
    if (flow_interp->mutex_obj == 0) {
#ifdef _DEBUG_THREADS
        printf("mutex_obj = 1\n");
#endif
#ifdef _HAVE_THREADS
        pthread_mutex_lock(&mutex_obj);
#endif
    }
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Unlocks mutex used in functions using 'objects' and 'structures'
--------------------------------------------------------------------*/
void
PTHREAD_UNLOCK_OBJ(flow_data *flow_interp)
{
    if (flow_interp->mutex_obj == 0) {
#ifdef _DEBUG_THREADS
        printf("mutex_obj = 0\n");
#endif
#ifdef _HAVE_THREADS
        pthread_mutex_unlock(&mutex_obj);
#endif
    }
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Command creating an object
--------------------------------------------------------------------*/
int
obj_create(int argc, char *argv[])
{
    int             iw,
                    j,
                    k,
                    l,
                    nb,
                    typ;
    char            nom[100],
                    h[100];
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    nb = 0;
    typ = convert_int(argv[1], flow_interp);
    l = -1;
    PTHREAD_LOCK_OBJ(flow_interp);

    for (k = 2; k < 3; k++) {
        if (argv[k][0] != '#' && (int) strlen(argv[k]) > 0) {
            memset(nom, 0, 30);
            iw = parse_def(argv[k], &nb, nom, flow_interp);
            if (iw == 0) {
                err_mess(8);
                PTHREAD_UNLOCK_OBJ(flow_interp);
                return -1;
            }
            if (iw == 2) {
                l = test_nom_obj(argv[k], typ, flow_interp);
                if (l == -1) {
                    PTHREAD_UNLOCK_OBJ(flow_interp);
                    return -1;
                }
            }
            else {
                for (j = 1; j <= nb; j++) {
                    memset(h, 0, 100);
                    sprintf(h, "%s[%d]", nom, j);
                    l = test_nom_obj(h, typ, flow_interp);
                    if (l == -1) {
                        PTHREAD_UNLOCK_OBJ(flow_interp);
                        return -1;
                    }
                }
            }
        }
    }

    PTHREAD_UNLOCK_OBJ(flow_interp);
    return l;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Called by the preceeding function. Creates an object of type 'typ'
    if its name h is correct
--------------------------------------------------------------------*/
int
test_nom_obj(char *h, int typ, flow_data *flow_interp)
{
    int             i,
                    j,
                    k,
                    nb,
                    nbdim,
                    slen;
    memm           *M;

    nb = Obj_typ[typ].nombre;
    slen = strlen(h);

    if (slen > 20) {
        err_mess(9);
        return -1;
    }


/*----------------------------------------------------
    We look for an non-occupied place in the array
    of objects
----------------------------------------------------*/
    j = 0;

    for (i = 0; i < nb; i++) {
        if (Obj[typ][i].occup == 1)
            j++;
        else
            break;
    }

    if (j == nb) {
        err_mess(10);
        return -1;
    }
    j = i;    /* number of the first non-occupied
                 place */
/*--------------------------------------------------*/



/*----------------------------------------------------
    We verify if the name of the object is not already
    used
----------------------------------------------------*/
    for (i = 0; i < nb_typ; i++) {
        for (k = 0; k < Obj_typ[i].nombre; k++) {
            if (Obj[i][k].occup == 1) {
                if (comp(Obj[i][k].nom_obj, h) == 1) {
                    err_mess(11);
                    return -1;
                }
            }
        }
    }
/*--------------------------------------------------*/


/*----------------------------------------------------
    Creation of the object
----------------------------------------------------*/
    Obj[typ][j].occup = 1;
    Obj[typ][j].nom_obj = ch_copy(h);
    nbdim = Obj_typ[typ].nbdim;
    Obj[typ][j].dim = (int *) malloc((size_t) nbdim * sizeof(int));
    if (Obj_typ[typ].type < 7) {
        for (i = 0; i < nbdim; i++)
            (Obj[typ][j].dim)[i] = S_convert_int((Obj_typ[typ].nom_dim)[i],
                flow_interp);
        M = memm_alloc(Obj[typ][j].dim, nbdim, Obj_typ[typ].type);
    }
    else {
        (Obj[typ][j].dim)[0] = 10;
        M = memm_alloc(Obj[typ][j].dim, nbdim, 0);
    }
    Obj[typ][j].adresse = (char *) M[0].ad;
    return j;

/*--------------------------------------------------*/

}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'destroy'
--------------------------------------------------------------------*/
int
detruit_obj(int argc, char *argv[])
{
    int             i,
                    i0,
                    j,
                    k,
                    l,
                    typ;
    char            h[100];
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    i0 = flow_interp->mutex_obj;

    for (i = 1; i < argc; i++) {
        for (typ = 0; typ < nb_typ; typ++) {
            for (j = 0; j < Obj_typ[typ].nombre; j++) {
                if (Obj[typ][j].occup == 1) {
                    if (comp(Obj[typ][j].nom_obj, argv[i]) == 1) {
                        free(Obj[typ][j].nom_obj);
                        Obj[typ][j].occup = 0;
                        flow_interp->mutex_obj = 1;
                        dest_prop(typ, j, flow_interp);
                        flow_interp->mutex_obj = i0;
                        XFREE(Obj[typ][j].adresse);
                        free(Obj[typ][j].dim);
                        PTHREAD_UNLOCK_OBJ(flow_interp);
                        return 0;
                    }
                }
            }
        }
    }

    for (i = 1; i < argc; i++) {
        for (typ = 0; typ < nb_struc; typ++) {
            for (j = 0; j < Struc_typ[typ].nombre; j++) {
                if (Struc[typ][j].occup == 1) {
                    if (comp(Struc[typ][j].nom_struc, argv[i]) == 1) {
                        for (k = 0; k < Struc_typ[typ].nb_membres; k++) {
                            if (Struc_typ[typ].type_mb[k] == 0) {
                                memset(h, 0, 100);
                                sprintf(h, "%s_%s", Struc[typ][j].nom_struc,
                                    (Struc_typ[typ].membre_id)[k]);

                                    for (l = 0; l < MAXXVARS; l++) {
                                        if (comp(h,
                                            flow_interp->VARS[l].name) == 1) {
                                            memset(flow_interp->VARS[l].name,
                                                0, XVARLEN);
                                            break;
                                        }
                                    }
                                memset(h, 0, 100);
                                sprintf(h, " %s_%s", Struc[typ][j].nom_struc,
                                    (Struc_typ[typ].membre_id)[k]);
                                h[0] = 127;

                                    for (l = 0; l < MAXXVARS; l++) {
                                        if (comp(h, flow_interp->VARS[l].name)
                                            == 1) {
                                            memset(flow_interp->VARS[l].name,
                                                0, XVARLEN);
                                            break;
                                        }
                                    }
                            }
                        }
                        free(Struc[typ][j].nom_struc);
                        Struc[typ][j].occup = 0;
                        free((Struc[typ][j].nom_mb)[0]);
                        free(Struc[typ][j].nom_mb);
                        PTHREAD_UNLOCK_OBJ(flow_interp);
                        return 0;
                    }
                }
            }
        }
    }

    err_mess(12);
    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 1;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'list'
--------------------------------------------------------------------*/
int
liste_obj(int argc, char *argv[])
{
    int             i,
                    typ;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp = (flow_data *) argv[-1];
    if (flow_interp->PRLEVEL > 0) {
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 0;
    }

    for (typ = 0; typ < nb_typ; typ++) {
        if (mode_com_obj[typ][flow_interp->MODE_FONCT_] == 1) {
            print(flow_interp, "                    %s\n",
                Obj_typ[typ].comment);

            for (i = 0; i < Obj_typ[typ].nombre; i++) {
                if (Obj[typ][i].occup == 1) {
                    print(flow_interp, "                        %s\n",
                        Obj[typ][i].nom_obj);
                }
            }
        }
    }

    for (typ = 0; typ < nb_struc; typ++) {
        if (mode_com_str[typ][flow_interp->MODE_FONCT_] == 1) {
            print(flow_interp, "                    %s\n",
                Struc_typ[typ].comment);

            for (i = 0; i < Struc_typ[typ].nombre; i++) {
                if (Struc[typ][i].occup == 1) {
                    print(flow_interp, "                        %s\n",
                        Struc[typ][i].nom_struc);
                }
            }
        }
    }

    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function that destroys all the objects of type 'typ'
--------------------------------------------------------------------*/
void
init_obj(int typ, flow_data *flow_interp)
{
    int             i;

    PTHREAD_LOCK_OBJ(flow_interp);
    if (typ < 0 || typ >= nb_typ) {
        err_mess(13);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return;
    }

    for (i = 0; i < Obj_typ[typ].nombre; i++) {
        if (Obj[typ][i].occup == 1) {
            flow_interp->mutex_obj = 1;
            dest_prop(typ, i, flow_interp);
            flow_interp->mutex_obj = 0;
            XFREE(Obj[typ][i].adresse);
            free(Obj[typ][i].nom_obj);
            Obj[typ][i].occup = 0;
            free(Obj[typ][i].dim);
        }
    }

    PTHREAD_UNLOCK_OBJ(flow_interp);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function that determines the type of the object or structure whose
    name is w. Returns 1+typ if w is the name of an object of type typ,
    -1-type if w is the name of a structure of type typ, and 0 if w is
    not the name of an object or structure. i0 will contain the
    number of the object or structure whose name is w
--------------------------------------------------------------------*/
int
sketch_obj(char *w, int *i0, flow_data *flow_interp)
{
    int             typ,
                    i;

    PTHREAD_LOCK_OBJ(flow_interp);
    *i0 = -1;

    for (typ = 0; typ < nb_typ; typ++) {
        for (i = 0; i < Obj_typ[typ].nombre; i++) {
            if (Obj[typ][i].occup == 1) {
                if (comp(w, Obj[typ][i].nom_obj) == 1) {
                    *i0 = i;
                    PTHREAD_UNLOCK_OBJ(flow_interp);
                    return (typ + 1);
                }
            }
        }
    }

    for (typ = 0; typ < nb_struc; typ++) {
        for (i = 0; i < Struc_typ[typ].nombre; i++) {
            if (Struc[typ][i].occup == 1) {
                if (comp(w, Struc[typ][i].nom_struc) == 1) {
                    *i0 = i;
                    PTHREAD_UNLOCK_OBJ(flow_interp);
                    return (- typ - 1);
                }
            }
        }
    }

    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function that determines the type of the object or structure whose
    name is w. Returns i1 if w is the name of an object of type i1-1,
    -i1 if w is the name of a structure of type -i1-1, and 0 if w is
    not the name of an object or structure of the good type.
    i0 will contain the number of the object or structure whose name
    is w
--------------------------------------------------------------------*/
int
sketch_obj_restr(char *w, int *i0, int i1, flow_data *flow_interp)
{
    int             typ,
                    i;

    PTHREAD_LOCK_OBJ(flow_interp);
    *i0 = -1;
    typ = i1 - 1;
    if (i1 < 0)
        typ = -i1 - 1;

    if (i1 > 0) {
        for (i = 0; i < Obj_typ[typ].nombre; i++) {
            if (Obj[typ][i].occup == 1) {
                if (comp(w, Obj[typ][i].nom_obj) == 1) {
                    *i0 = i;
                    PTHREAD_UNLOCK_OBJ(flow_interp);
                    return (typ + 1);
                }
            }
        }
    }

    else {
        for (i = 0; i < Struc_typ[typ].nombre; i++) {
            if (Struc[typ][i].occup == 1) {
                if (comp(w, Struc[typ][i].nom_struc) == 1) {
                    *i0 = i;
                    PTHREAD_UNLOCK_OBJ(flow_interp);
                    return (- typ - 1);
                }
            }
        }
    }

    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    Function that determines the type of the object whose
    name is w. Returns typ if w is the name of an object of type typ,
    and if the type typ is an alias of the type i1, -1 otherwise.
    i0 will contain the number of the object whose name is w
--------------------------------------------------------------------*/
int
sketch_obj_restr_b(char *w, int *i0, int i1, flow_data *flow_interp)
{
    int             typ,
                    i;

    PTHREAD_LOCK_OBJ(flow_interp);
    *i0 = -1;

    for (typ = 0; typ < nb_typ; typ++) {
        if (Obj_alias[typ] == i1) {
            for (i = 0; i < Obj_typ[typ].nombre; i++) {
                if (Obj[typ][i].occup == 1) {
                    if (comp(w, Obj[typ][i].nom_obj) == 1) {
                        *i0 = i;
                        PTHREAD_UNLOCK_OBJ(flow_interp);
                        return typ;
                    }
                }
            }
        }
    }

    PTHREAD_UNLOCK_OBJ(flow_interp);
    return -1;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function that returns typ+1 if w1, w2 are the names of two objects
     of type typ, -typ-1 if w1, w2 are the names of two structures of
    two structures of type typ, 0 otherwise. i1 will contain the
    number of the object or structure whose name is w1, and i2 the
    number of the object or structure whose name is w2
--------------------------------------------------------------------*/
int
sketch_obj2(char *w1, char *w2, int *i1, int *i2, flow_data *flow_interp)
{
    int             typ,
                    j1,
                    j2,
                    i,
                    ind;

    PTHREAD_LOCK_OBJ(flow_interp);
    *i1 = -1;
    *i2 = -1;
    j1 = -1;
    j2 = -1;
    ind = 0;

    for (typ = 0; typ < nb_typ; typ++) {
        for (i = 0; i < Obj_typ[typ].nombre; i++) {
            if (Obj[typ][i].occup == 1) {
                if (comp(w1, Obj[typ][i].nom_obj) == 1) {
                    j1 = typ;
                    *i1 = i;
                    break;
                }
            }
        }
    }

    if (*i1 == -1) {
        ind = 1;

        for (typ = 0; typ < nb_struc; typ++) {
            for (i = 0; i < Struc_typ[typ].nombre; i++) {
                if (Struc[typ][i].occup == 1) {
                    if (comp(w1, Struc[typ][i].nom_struc) == 1) {
                        j1 = typ;
                        *i1 = i;
                        break;
                    }
                }
            }
        }
    }

    if (*i1 == -1) {
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 0;
    }

    if (ind == 0) {
        for (typ = 0; typ < nb_typ; typ++) {
            for (i = 0; i < Obj_typ[typ].nombre; i++) {
                if (Obj[typ][i].occup == 1) {
                    if (comp(w2, Obj[typ][i].nom_obj) == 1) {
                        j2 = typ;
                        *i2 = i;
                        break;
                    }
                }
            }
        }
    }

    else {
        for (typ = 0; typ < nb_struc; typ++) {
            for (i = 0; i < Struc_typ[typ].nombre; i++) {
                if (Struc[typ][i].occup == 1) {
                    if (comp(w2, Struc[typ][i].nom_struc) == 1) {
                        j2 = typ;
                        *i2 = i;
                        break;
                    }
                }
            }
        }
    }

    PTHREAD_UNLOCK_OBJ(flow_interp);
    if (*i2 == -1)
        return 0;
    if (j1 != j2)
        return 0;
    if (ind == 0)
        return (j1 + 1);
    else
        return (-j1 - 1);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Similar to the preceeding function but with 3 names instad of 2
--------------------------------------------------------------------*/
int
sketch_obj3(char *w1, char *w2, char *w3,int *i1, int *i2, int *i3,
    flow_data *flow_interp)
{
    int             iw,
                    j3,
                    typ,
                    i;

    j3 = -1;
    iw = sketch_obj2(w1, w2, i1, i2, flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    if (iw == 0) {
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 0;
    }

    if (iw > 0) {
        for (typ = 0; typ < nb_typ; typ++) {
            for (i = 0; i < Obj_typ[typ].nombre; i++) {
                if (Obj[typ][i].occup == 1) {
                    if (comp(w3, Obj[typ][i].nom_obj) == 1) {
                        j3 = typ;
                        *i3 = i;
                        break;
                    }
                }
            }
        }
    }

    else {
        for (typ = 0; typ < nb_struc; typ++) {
            for (i = 0; i < Struc_typ[typ].nombre; i++) {
                if (Struc[typ][i].occup == 1) {
                    if (comp(w3, Struc[typ][i].nom_struc) == 1) {
                        j3 = typ;
                        *i3 = i;
                        break;
                    }
                }
            }
        }
    }

    PTHREAD_UNLOCK_OBJ(flow_interp);
    if (*i3 == -1)
        return 0;
    if ((iw > 0 && j3 != iw - 1) || (iw < 0 && iw != (-j3 - 1)))
        return 0;
    return iw;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'add'
--------------------------------------------------------------------*/
int
add_objet(int argc,char *argv[])
{
    int             i0,
                    i1,
                    i2,
                    typ;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp->mutex_obj = 1;
    typ = sketch_obj3(argv[1], argv[2], argv[3], &i0, &i1, &i2,
        flow_interp) - 1;
    flow_interp->mutex_obj = 0;
    if (typ <= -1) {
        err_mess(14);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    if (Obj_typ[typ].type < 7)
        ajoute_tab(_M((char **) Obj[typ][i0].adresse),
            _M((char **) Obj[typ][i1].adresse),
            _M((char **) Obj[typ][i2].adresse));
    else {
        err_mess(58);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'substract'
--------------------------------------------------------------------*/
int
sub_objet(int argc, char *argv[])
{
    int             i0,
                    i1,
                    i2,
                    typ;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp->mutex_obj = 1;
    typ = sketch_obj3(argv[1], argv[2], argv[3], &i0, &i1, &i2,
        flow_interp) - 1;
    flow_interp->mutex_obj = 0;
    if (typ <= -1) {
        err_mess(14);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
        }
    if (Obj_typ[typ].type < 7)
        soustrait_tab(_M((char **) Obj[typ][i1].adresse),
            _M((char **) Obj[typ][i0].adresse),
            _M((char **) Obj[typ][i2].adresse));
    else {
        err_mess(58);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
int
Xmult_objet(int argc, char *argv[])
{
    int             i0,
                    i1,
                    i2,
                    typ;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp->mutex_obj = 1;
    typ = sketch_obj3(argv[1], argv[2], argv[3], &i0, &i1, &i2,
        flow_interp) - 1;
    flow_interp->mutex_obj = 0;
    if (typ <= -1) {
        err_mess(14);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
        }
    if (Obj_typ[typ].type < 7)
        multiplie_tab(_M((char **) Obj[typ][i1].adresse),
            _M((char **) Obj[typ][i0].adresse),
            _M((char **) Obj[typ][i2].adresse));
    else {
        err_mess(58);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
int
mkcomplex_cmd(int argc, char *argv[])
{
    int             i0,
                    i1,
                    i2,
                    j0,
                    j1,
                    j2,
                    typ0,
                    typ1,
                    typ2;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp->mutex_obj = 1;
    typ0 = sketch_obj(argv[1], &i0, flow_interp) - 1;
    typ1 = sketch_obj(argv[2], &i1, flow_interp) - 1;
    typ2 = sketch_obj(argv[3], &i2, flow_interp) - 1;
    flow_interp->mutex_obj = 0;
    j0 = Obj_typ[typ0].type;
    j1 = Obj_typ[typ1].type;
    j2 = Obj_typ[typ2].type;
    if (j0 <= 0 || j1 <= 0 || j2 <= 0 || j0 != j1 ||
        (j0 == 1 && j2 != 3 && j2 != 5) || (j0 == 2 && j2 != 4 && j2 != 6)) {
        err_mess(14);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    Complex_tab(_M((char **) Obj[typ0][i0].adresse),
        _M((char **) Obj[typ1][i1].adresse),
            _M((char **) Obj[typ2][i2].adresse));
    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
int
mkpolaire_cmd(int argc, char *argv[])
{
    int             i0,
                    i1,
                    i2,
                    j0,
                    j1,
                    j2,
                    typ0,
                    typ1,
                    typ2;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp->mutex_obj = 1;
    typ0 = sketch_obj(argv[1], &i0, flow_interp) - 1;
    typ1 = sketch_obj(argv[2], &i1, flow_interp) - 1;
    typ2 = sketch_obj(argv[3], &i2, flow_interp) - 1;
    flow_interp->mutex_obj = 0;
    j0 = Obj_typ[typ0].type;
    j1 = Obj_typ[typ1].type;
    j2 = Obj_typ[typ2].type;
    if (j0 <= 0 || j1 <= 0 || j2 <= 0 || j0 != j1 ||
        (j0 == 1 && j2 != 3 && j2 != 5) || (j0 == 2 && j2 != 4 && j2 != 6)) {
        err_mess(14);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    Polaire_tab(_M((char **) Obj[typ0][i0].adresse),
        _M((char **) Obj[typ1][i1].adresse),
            _M((char **) Obj[typ2][i2].adresse));
    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'multiply'
--------------------------------------------------------------------*/
int
mult_objet(int argc, char *argv[])
{
    int             i0,
                    i2,
                    typ;
    double          facteur;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    facteur = convert_float(argv[2], flow_interp);
    flow_interp->mutex_obj = 1;
    typ = sketch_obj(argv[1], &i0, flow_interp);
    if (typ <= 0 || typ != sketch_obj(argv[3], &i2, flow_interp)) {
        flow_interp->mutex_obj = 0;
        err_mess(14);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    flow_interp->mutex_obj = 0;
    typ--;
    if (Obj_typ[typ].type < 7)
        Rmul_tab(_M((char **) Obj[typ][i0].adresse), facteur,
            _M((char **) Obj[typ][i2].adresse));
    else {
        err_mess(58);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'cmultiply'
--------------------------------------------------------------------*/
int
Cmult_objet(int argc, char *argv[])
{
    int             i0,
                    i2,
                    typ;
    dcomplex        facteur;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    facteur.r = convert_float(argv[2], flow_interp);
    facteur.i = convert_float(argv[3], flow_interp);

    flow_interp->mutex_obj = 1;
    typ = sketch_obj(argv[1], &i0, flow_interp);
    if (typ <= 0 || typ != sketch_obj(argv[4], &i2, flow_interp)) {
        flow_interp->mutex_obj = 0;
        PTHREAD_UNLOCK_OBJ(flow_interp);
        err_mess(14);
        return 1;
    }
    flow_interp->mutex_obj = 0;
    typ--;
    if (Obj_typ[typ].type < 7)
        Cmul_tab(_M((char **) Obj[typ][i0].adresse), facteur,
            _M((char **) Obj[typ][i2].adresse));
    else {
        err_mess(58);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    Function associated to the command 'copy'
--------------------------------------------------------------------*/
int
copie_objet(int argc, char *argv[])
{
    int             i0,
                    i1,
                    typ;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp->mutex_obj = 1;
    typ = sketch_obj2(argv[1], argv[2], &i0, &i1, flow_interp);
    flow_interp->mutex_obj = 0;

    if (typ <= 0) {
        err_mess(14);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    typ--;

    if (Obj_typ[typ].type < 7)
        copie_tab(_M((char **) Obj[typ][i0].adresse),
            _M((char **) Obj[typ][i1].adresse));
    else {
        err_mess(58);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    Function associated to the command 'conjg'
--------------------------------------------------------------------*/
int
conjg_cmd(int argc, char *argv[])
{
    int             i0,
                    i1,
                    typ;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp->mutex_obj = 1;
    typ = sketch_obj2(argv[1], argv[2], &i0, &i1, flow_interp);
    flow_interp->mutex_obj = 0;

    if (typ <= 0) {
        err_mess(14);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    typ--;

    if (Obj_typ[typ].type < 7 && Obj_typ[typ].type > 2)
        Conjg_tab(_M((char **) Obj[typ][i0].adresse),
            _M((char **) Obj[typ][i1].adresse));
    else {
        err_mess(59);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/






/*--------------------------------------------------------------------
    Function associated to the command 'const'
--------------------------------------------------------------------*/
int
cnst(int argc, char *argv[])
{
    int             typ,
                    i0;
    double          val;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp->mutex_obj = 1;
    typ = sketch_obj(argv[1], &i0, flow_interp);
    flow_interp->mutex_obj = 0;
    if (typ <= 0) {
        err_mess(12);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    typ--;
    val = convert_float(argv[2], flow_interp);

    if (Obj_typ[typ].type < 7)
        cnst_tab(_M((char **) Obj[typ][i0].adresse), val);
    else {
        err_mess(58);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }

    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/






/*--------------------------------------------------------------------
    Function associated to the command 'const_c'
--------------------------------------------------------------------*/
int
Ccnst_cmd(int argc, char *argv[])
{
    int             typ,
                    i0;
    dcomplex        val;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp->mutex_obj = 1;
    typ = sketch_obj(argv[1], &i0, flow_interp);
    flow_interp->mutex_obj = 0;
    if (typ <= 0) {
        err_mess(12);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    typ--;

    val.r = convert_float(argv[2], flow_interp);
    val.i = convert_float(argv[3], flow_interp);

    if (Obj_typ[typ].type > 2 && Obj_typ[typ].type < 7)
        Ccnst_tab(_M((char **) Obj[typ][i0].adresse), val);
    else {
        err_mess(59);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }

    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/






/*--------------------------------------------------------------------
    Function associated to the command 'const_r'
--------------------------------------------------------------------*/
int
RPolcnst(int argc, char *argv[])
{
    int             typ,
                    i0;
    double          val;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp->mutex_obj = 1;
    typ = sketch_obj(argv[1], &i0, flow_interp);
    flow_interp->mutex_obj = 0;
    if (typ <= 0) {
        PTHREAD_UNLOCK_OBJ(flow_interp);
        err_mess(12);
        return 1;
    }
    typ--;
    val = convert_float(argv[2], flow_interp);
    if (val <= 0.) {
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }

    if (Obj_typ[typ].type > 2 && Obj_typ[typ].type < 7)
        RPolcnst_tab(_M((char **) Obj[typ][i0].adresse), val);
    else {
        err_mess(59);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }

    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/






/*--------------------------------------------------------------------
    Function associated to the command 'const_th'
--------------------------------------------------------------------*/
int
ThPolcnst(int argc, char *argv[])
{
    int             typ,
                    i0;
    double          val;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp->mutex_obj = 1;
    typ = sketch_obj(argv[1], &i0, flow_interp);
    flow_interp->mutex_obj = 0;
    if (typ <= 0) {
        err_mess(12);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    typ--;

    val = convert_float(argv[2], flow_interp);

    if (Obj_typ[typ].type > 2 && Obj_typ[typ].type < 7)
       ThPolcnst_tab(_M((char **) Obj[typ][i0].adresse), val);
    else {
        err_mess(59);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }

    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/






/*--------------------------------------------------------------------
    Function associated to the command 'Real'
--------------------------------------------------------------------*/
int
Real_part(int argc, char *argv[])
{
    int             typ0,
                    i0,
                    typ1,
                    i1,
                    j0,
                    j1;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp->mutex_obj = 1;
    typ0 = sketch_obj(argv[1], &i0, flow_interp);
    typ1 = sketch_obj(argv[2], &i1, flow_interp);
    flow_interp->mutex_obj = 0;
    if (typ1 <= 0 || typ0 <= 0) {
        err_mess(12);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    typ0--;
    typ1--;
    j0 = Obj_typ[typ0].type;
    j1 = Obj_typ[typ1].type;

    if ((j1 == 1 && (j0 == 3 || j0 == 5)) ||(j1 == 2 &&
        (j0 == 4 || j0 == 6))) {
        reel_tab(_M((char **) Obj[typ0][i0].adresse),
            _M((char **) Obj[typ1][i1].adresse));
    }
    else {
        err_mess(59);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }

    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/






/*--------------------------------------------------------------------
    Function associated to the command 'Imag'
--------------------------------------------------------------------*/
int
Imag_part(int argc, char *argv[])
{
    int             typ0,
                    i0,
                    typ1,
                    i1,
                    j0,
                    j1;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp->mutex_obj = 1;
    typ0 = sketch_obj(argv[1], &i0, flow_interp);
    typ1 = sketch_obj(argv[2], &i1, flow_interp);
    flow_interp->mutex_obj = 0;
    if (typ1 <= 0 || typ0 <= 0) {
        err_mess(12);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    typ0--;
    typ1--;
    j0 = Obj_typ[typ0].type;
    j1 = Obj_typ[typ1].type;

    if ((j1 == 1 && (j0 == 3 || j0 == 5)) ||(j1 == 2 &&
        (j0 == 4 || j0 == 6))) {
        imag_tab(_M((char **) Obj[typ0][i0].adresse),
            _M((char **) Obj[typ1][i1].adresse));
    }
    else {
        err_mess(59);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }

    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/






/*--------------------------------------------------------------------
    Function associated to the command 'radius'
--------------------------------------------------------------------*/
int
Radius_part(int argc, char *argv[])
{
    int             typ0,
                    i0,
                    typ1,
                    i1,
                    j0,
                    j1;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp->mutex_obj = 1;
    typ0 = sketch_obj(argv[1], &i0, flow_interp);
    typ1 = sketch_obj(argv[2], &i1, flow_interp);
    flow_interp->mutex_obj = 0;
    if (typ1 <= 0 || typ0 <= 0) {
        err_mess(12);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    typ0--;
    typ1--;
    j0 = Obj_typ[typ0].type;
    j1 = Obj_typ[typ1].type;

    if ((j1 == 1 && (j0 == 3 || j0 == 5)) ||(j1 == 2 &&
        (j0 == 4 || j0 == 6))) {
        Module_tab(_M((char **) Obj[typ0][i0].adresse),
            _M((char **) Obj[typ1][i1].adresse));
    }
    else {
        err_mess(59);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }

    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/






/*--------------------------------------------------------------------
    Function associated to the command 'phase'
--------------------------------------------------------------------*/
int
Phase_part(int argc, char *argv[])
{
    int             typ0,
                    i0,
                    typ1,
                    i1,
                    j0,
                    j1;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp->mutex_obj = 1;
    typ0 = sketch_obj(argv[1], &i0, flow_interp);
    typ1 = sketch_obj(argv[2], &i1, flow_interp);
    flow_interp->mutex_obj = 0;
    if (typ1 <= 0 || typ0 <= 0) {
        err_mess(12);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    typ0--;
    typ1--;
    j0 = Obj_typ[typ0].type;
    j1 = Obj_typ[typ1].type;

    if ((j1 == 1 && (j0 == 3 || j0 == 5)) ||(j1 == 2 &&
        (j0 == 4 || j0 == 6))) {
        Phase_tab(_M((char **) Obj[typ0][i0].adresse),
            _M((char **) Obj[typ1][i1].adresse));
    }
    else {
        err_mess(59);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }

    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'svg'
--------------------------------------------------------------------*/
int
svg_cmd(int argc, char *argv[])
{
    int             iw,
                    i0;
    char            h[200];
    FILE           *s;
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp->mutex_obj = 1;
    iw = sketch_obj(argv[1], &i0, flow_interp);
    flow_interp->mutex_obj = 0;
    if (iw <= 0) {
        err_mess(12);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    iw--;
    if (Obj[iw][i0].typ_obj->type == 7) {
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    strcpy(h, result_rep);
    strcat(h, argv[2]);
    s = fopen(h, "wb");
    if (s == NULL) {
        err_mess(1);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    fwrite(&iw, sizeof(int), 1, s);
    if (svg_tab(s, Obj[iw][i0].adresse, 0) == 0) {
#ifdef _ENG_LANG
        print(flow_interp, "Incorrect stored array\n");
#else
        print(flow_interp, "Tableau enregistre incorrect\n");
#endif
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 0;
    }
    fclose(s);
    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'restore'
--------------------------------------------------------------------*/
int
restore_cmd(int argc, char *argv[])
{
    int             iw,
                    i,
                    i0;
    char            h[200];
    FILE           *s;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp->mutex_obj = 1;
    iw = sketch_obj(argv[1], &i0, flow_interp);
    flow_interp->mutex_obj = 0;
    if (iw <= 0) {
        err_mess(12);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    iw--;
    if (Obj[iw][i0].typ_obj->type < 7)

    strcpy(h, result_rep);
    strcat(h, argv[2]);
    s = fopen(h, "rb");
    if (s == NULL) {
        err_mess(1);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    fread(&i, sizeof(int), 1, s);
    if (i != iw)
        err_mess(14);
    if (svg_tab(s, Obj[iw][i0].adresse, 1) == 0)
        err_mess(15);
    fclose(s);
    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'setobj'
--------------------------------------------------------------------*/
int
set_obj_val_cmd(int argc, char *argv[])
{
    int             i,
                    iw,
                    i0,
                    j,
                    typ,
                    nb,
                    p,
                    k,
                    q,
                   *xi;
    float          *xf;
    double         *xd,
                    val,
                    val_i;
    fcomplex       *xfc;
    dcomplex       *xdc;
    fpolaire       *xfp;
    dpolaire       *xdp;
    char           *c;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    iw = sketch_obj(argv[1], &i0, flow_interp);
    if (iw <= 0) {
        return 1;
    }
    iw--;
    typ = Obj_typ[iw].type;
    if (typ == 7) {
        err_mess(8);
        return 1;
    }
    nb = Obj_typ[iw].nbdim;
    if ((typ < 3 && argc < nb + 3) || (typ >= 3 && argc < nb + 4)) {
        err_mess(0);
        return 1;
    }
    k = 0;
    if (typ >= 3)
        k = 1;
    p = 0;
    q = 1;

    for (i = nb - 1; i  >= 0; i--) {
        j = convert_int(argv[k + 3 + i], flow_interp);
        if (j < 0 || j > (Obj[iw][i0].dim)[i]) {
            err_mess(47);
            return 1;
        }
        p += j * q;
        if (i > 0)
            q *= (Obj[iw][i0].dim)[i] + 1;
    }

    c = addr_eff_b(_M((char **) Obj[iw][i0].adresse));
    val = 0.;
    val_i = 0.;
    val = convert_float(argv[2], flow_interp);
    if (typ >= 3)
        val_i = convert_float(argv[3], flow_interp);

    switch(typ) {
        case 0 :
            xi = (int *) c;
            xi[p] = (int) val;
            break;
        case 1 :
            xf = (float *) c;
            xf[p] = (float) val;
            break;
        case 2 :
            xd = (double *) c;
            xd[p] = val;;
            break;
        case 3 :
            xfc = (fcomplex *) c;
            xfc[p].r = (float) val;
            xfc[p].i = (float) val_i;
            break;
        case 4 :
            xdc = (dcomplex *) c;
            xdc[p].r = val;
            xdc[p].i = val_i;
            break;
        case 5 :
            xfp = (fpolaire *) c;
            xfp[p].rm = (float) val;
            xfp[p].th = (float) val_i;
            break;
        case 6 :
            xdp = (dpolaire *) c;
            xdp[p].rm = val;
            xdp[p].th = val_i;
            break;
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'fillobj'
--------------------------------------------------------------------*/
int
fill_obj_cmd(int argc, char *argv[])
{
    int             i,
                    iw,
                    i0,
                    j,
                    jj,
                    typ,
                    nb,
                    p,
                    k,
                    n,
                   *pp,
                   *xi;
    float          *xf;
    double         *xd,
                    val,
                    val_i,
                    x;
    fcomplex       *xfc;
    dcomplex       *xdc;
    fpolaire       *xfp;
    dpolaire       *xdp;
    char           *c,
                  **h0,
                    h[100];
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    iw = sketch_obj(argv[1], &i0, flow_interp);
    if (iw <= 0) {
        return 1;
    }
    iw--;
    typ = Obj_typ[iw].type;
    if (typ == 7) {
        err_mess(8);
        return 1;
    }
    nb = Obj_typ[iw].nbdim;
    if ((typ < 3 && argc < 3) || (typ >= 3 && argc < 4)) {
        err_mess(0);
        return 1;
    }

    h0 = (char **) malloc((size_t) nb * sizeof(char *));
    pp = (int *) malloc((size_t) nb * sizeof(int));
    p = 1;
    c = addr_eff_b(_M((char **) Obj[iw][i0].adresse));

    for (i = nb - 1; i >= 0; i--) {
        memset(h, 0, 100);
        sprintf(h, "x%d", i);
        h0[i] = ch_copy(h);
        pp[i] = p;
        p *= (Obj[iw][i0].dim)[i] + 1;
    }

    for (j = 0; j < p; j++) {
        jj = j;

        for (k = 0; k < nb; k++) {
            n = jj / pp[k];
            x = (double) n;
            SetValue(h0[k], &x, flow_interp);
            jj -= n * pp[k];
        }

        val = convert_float(argv[2], flow_interp);
        val_i = 0.;
        if (typ >= 3)
            val_i = convert_float(argv[3], flow_interp);

        switch(typ) {
            case 0 :
                xi = (int *) c;
                xi[j] = (int) val;
                break;
            case 1 :
                xf = (float *) c;
                xf[j] = (float) val;
                break;
            case 2 :
                xd = (double *) c;
                xd[j] = val;;
                break;
            case 3 :
                xfc = (fcomplex *) c;
                xfc[j].r = (float) val;
                xfc[j].i = (float) val_i;
                break;
            case 4 :
                xdc = (dcomplex *) c;
                xdc[j].r = val;
                xdc[j].i = val_i;
                break;
            case 5 :
                xfp = (fpolaire *) c;
                xfp[j].rm = (float) val;
                xfp[j].th = (float) val_i;
                break;
            case 6 :
                xdp = (dpolaire *) c;
                xdp[j].rm = val;
                xdp[j].th = val_i;
                break;
        }
    }

    for (i = 0; i < nb; i++)
        free(h0[i]);
    free(h0);
    free(pp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function that destroys all the structures of type 'typ'
--------------------------------------------------------------------*/
void
init_str(int typ, flow_data *flow_interp)
{
    int             i;

    PTHREAD_LOCK_OBJ(flow_interp);
    if (typ < 0 || typ >= nb_struc) {
        err_mess(13);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return;
    }

    for (i = 0; i < Struc_typ[typ].nombre; i++) {
        if (Struc[typ][i].occup == 1) {
            free(Struc[typ][i].nom_struc);
            Struc[typ][i].occup = 0;
            free((Struc[typ][i].nom_mb)[0]);
            free(Struc[typ][i].nom_mb);
        }
    }

    PTHREAD_UNLOCK_OBJ(flow_interp);
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    Function associated to the section '!struct' of an initialization
    file
--------------------------------------------------------------------*/
int
struct_cmd(FILE *s, char *name_c, flow_data *flow_interp)
{
    int             nbstruc,
                    i,
                    j,
                    l,
                    slen,
                   *nb_mb,
                   *n_o;
    char            h_ligne[100],
                    k[100],
                  **name_str,
                  **comment,
                 ***nom_mbs,
                 ***mb_id;

    nbstruc = -1;
    memset(h_ligne, 0, 100);
    n_o = int_alloc1(__nbstrucmax);
    nb_mb = int_alloc1(__nbstrucmax);

    comment = (char **)malloc((size_t) __nbstrucmax * sizeof(char *));
    comment[0] = (char *)malloc((size_t) __nbstrucmax * 100 * sizeof(char));
    for (i = 1; i < __nbstrucmax; i++)
        comment[i] = comment[i - 1] + 100;
    name_str = (char **)malloc((size_t) __nbstrucmax * sizeof(char *));
    name_str[0] = (char *)malloc((size_t) __nbstrucmax * 100 * sizeof(char));
    for (i = 1; i < __nbstrucmax; i++)
        name_str[i] = name_str[i - 1] + 100;
    nom_mbs = (char ***)malloc((size_t) __nbstrucmax * sizeof(char **));
    mb_id = (char ***)malloc((size_t) __nbstrucmax * sizeof(char **));

    for (i = 0; i < __nbstrucmax; i++) {
        memset(comment[i], 0, 100);
        memset(name_str[i], 0, 100);
    }

    while (fgets_count(h_ligne, 99, s) != NULL) {
        if (h_ligne[0] == '.')
            goto xxx;
        if (h_ligne[0] != ';') {

/*-------------------------------------
    Name of the command that create the structures
-------------------------------------*/
            slen = strlen(h_ligne) - 1;
            if (slen < 2) {
                err_mess(21);
                exit_interp("struct");
            }
            nbstruc++;
            if (nbstruc >= __nbstrucmax) {
                err_mess(53);
                exit_interp("struct");
            }
            h_ligne[slen] = 0;
            memcpy(name_str[nbstruc], h_ligne, slen + 1);
            if (test_name_str(name_str[nbstruc]) == 1) {
                err_mess(21);
                exit_interp("struct");
            }


 /*-----------------------------------
    Number of members
-----------------------------------*/
            memset(h_ligne, 0, 100);
            if (fgets_count(h_ligne, 99, s) == NULL)
                exit_interp("struct");
            nettoie(h_ligne);
            nb_mb[nbstruc] = convert_int(h_ligne, flow_interp);
            if (nb_mb[nb_struc] <= 0) {
                err_mess(54);
                exit_interp("struct");
            }
            nom_mbs[nbstruc] = (char **) malloc((size_t) nb_mb[nbstruc]
                * sizeof(char *));
            mb_id[nbstruc] = (char **) malloc((size_t) nb_mb[nbstruc]
                * sizeof(char *));


 /*-----------------------------------
    types and names of the members
-----------------------------------*/
            for (i = 0; i < nb_mb[nbstruc]; i++) {
                memset(h_ligne, 0, 100);
                if (fgets_count(h_ligne, 99, s) == NULL)
                    exit_interp("struct");
                nettoie(h_ligne);
                mb_id[nbstruc][i] = ch_copy(h_ligne);
                if (test_name_str(mb_id[nbstruc][i]) == 1)
                    exit_interp("struct");
                memset(h_ligne, 0, 100);
                if (fgets_count(h_ligne, 99, s) == NULL)
                    exit_interp("struct");
                nettoie(h_ligne);
                nom_mbs[nbstruc][i] = ch_copy(h_ligne);
            }


/*------------------------------------
    Description of the structure type
------------------------------------*/
            memset(h_ligne, 0, 100);
            if (fgets_count(h_ligne, 99, s) == NULL)
                exit_interp("struct");
            memcpy(comment[nbstruc], h_ligne, strlen(h_ligne) - 1);


/*-------------------------------------
    Running modes
-------------------------------------*/
            memset(h_ligne, 0, 100);
            if (fgets_count(h_ligne, 99, s) == NULL)
                exit_interp("struct");
            nettoie(h_ligne);
            slen = strlen(h_ligne);
            i = 0;
            j = -1;
            memset(k, 0, 100);

            while (i < slen) {
                if (h_ligne[i] != ' ') {
                    j++;
                    k[j] = h_ligne[i];
                    i++;
                }
                if (h_ligne[i] == ' ' || i == slen) {
                    if ((int) strlen(k) > 0) {
                        j = convert_int(k, flow_interp);
                        if (j < 0)
                            for (l = 0; l < __nmode_fonc; l++)
                                mode_com_str[nbstruc + nb_struc][l] = 1;
                        else
                            if (j < __nmode_fonc)
                                mode_com_str[nbstruc + nb_struc][j] = 1;
                        memset(k, 0, 100);
                        j = -1;
                    }
                    i++;
                }
            }


/*-----------------------------------
    Maximal number of structures
-----------------------------------*/
            memset(h_ligne, 0, 100);
            if (fgets_count(h_ligne, 99, s) == NULL)
                exit_interp("struct");
            nettoie(h_ligne);
            n_o[nbstruc] = S_convert_int(h_ligne, flow_interp);
            memset(h_ligne, 0, 100);
        }
    }

xxx: nbstruc++;
    for (i = 0; i < nbstruc; i++) {
/*-------- Number of structures of type i ---------*/
        Struc_typ[i + nb_struc].nombre = n_o[i];
/*-------------------------------------------------*/


/*-------- Number of members of structures
                               of type i ----------*/
        Struc_typ[i + nb_struc].nb_membres = nb_mb[i];
        Struc_typ[i + nb_struc].type_mb = int_alloc1(nb_mb[i]);
/*-------------------------------------------------*/


/*---------- Names of the members of structures
                                of type i ---------*/
        Struc_typ[i + nb_struc].membre_id = (char **)
            malloc((size_t) nb_mb[i] * sizeof(char *));
/*-------------------------------------------------*/


/*---------- Types of the members of the structures
                        of type i -----------------*/
        for (l = 0; l < nb_mb[i]; l++) {
            (Struc_typ[i + nb_struc].membre_id)[l] = ch_copy(mb_id[i][l]);
            (Struc_typ[i + nb_struc].type_mb)[l] = 0;

            for (j = 0; j < nb_typ; j++) {
                if (comp(nom_mbs[i][l], Obj_typ[j].nom) == 1)
                    (Struc_typ[i + nb_struc].type_mb)[l] = j + 1;
            }
        }
/*-------------------------------------------------*/


/*---------- Name of the structures of type i -----*/
        Struc_typ[i + nb_struc].nom = ch_copy(name_str[i]);
/*-------------------------------------------------*/


/*---------- Comment ------------------------------*/
        Struc_typ[i + nb_struc].comment = ch_copy(comment[i]);
/*-------------------------------------------------*/


/*---------- Creation of the array of structures --*/
        Struc[i + nb_struc] = (strucb *) malloc((size_t) n_o[i] *
            sizeof(strucb));
/*-------------------------------------------------*/


/*-------------------------------------------------*/
        for (j = 0; j < n_o[i]; j++) {
            Struc[i + nb_struc][j].type = &Struc_typ[i + nb_struc];
            Struc[i + nb_struc][j].occup = 0;

        }
/*-------------------------------------------------*/


/*---------- Creation of the program that
             creates structures of type i ---------*/
        make_com_str(name_str[i], i + nb_struc, mode_com_str[i + nb_struc]);
/*-------------------------------------------------*/
    }

    for (i = 0; i < nbstruc + nb_struc; i++)
        for (l = 0; l < nb_mb[i]; l++)
            if ((Struc_typ[i].type_mb)[l] == 0) {
                for (j = 0; j < nbstruc + nb_struc; j++) {
                    if (comp(nom_mbs[i][l], Struc_typ[j].nom) == 1) {
                        (Struc_typ[i].type_mb)[l] = -j - 1;
                        break;
                    }
                }
            }

    free(comment[0]);
    free(comment);
    free(name_str[0]);
    free(name_str);

    for (i = 0; i < nbstruc; i++) {
        for (j = 0; j < nb_mb[i]; j++) {
            free(nom_mbs[i][j]);
            free(mb_id[i][j]);
        }

        free(nom_mbs[i]);
        free(mb_id[i]);
    }

    nb_struc += nbstruc;
    free(nom_mbs);
    free(mb_id);
    XFREE(n_o);
    XFREE(nb_mb);
    return 1;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function that returns 0 if the character string 'name' is
    alphanumeric, 1 otherwise
--------------------------------------------------------------------*/
int
test_name_str(char *name)
{
    int             i;

    for (i = 0; i < (int) strlen(name); i++)
        if (isalphab(name[i]) == 0)
                return 1;
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function called by 'struc_cmd'. Creates a program that
    creates structures of type 'ind' with the command name_c
--------------------------------------------------------------------*/
void
make_com_str(char *name_c, int ind, int *mode_c)
{
    int             n,
                    i;
    char            h[10];

    memset(h, 0, 10);
    nb_com++;
    nom_com[nb_com - 1] = ch_copy(name_c);
    nb_par[nb_com - 1] = 1;
    sil_com[nb_com - 1] = 0;
    nb_lignes[nb_com - 1] = 1;
    for (i = 0; i < __nmode_fonc; i++)
        mode_com_int[nb_com - 1][i] = mode_c[i];
    ligne_com[nb_com - 1][0] = (char *) malloc((size_t) 80 * sizeof(char));
    memset(ligne_com[nb_com - 1][0], 0, 80);
    sprintf(ligne_com[nb_com - 1][0],"strucdef");
    ligne_com[nb_com - 1][0][8] = 32;
    sprintf(h, "%d", ind);
    strcat(ligne_com[nb_com - 1][0], h);
    n = strlen(h) + 8;
    ligne_com[nb_com - 1][0][++n] = 32;
    ligne_com[nb_com - 1][0][++n] = '#';
    ligne_com[nb_com - 1][0][++n] = '1';
    Argc_com[nb_com - 1][0] = 3;
    Argv_com[nb_com - 1][0] = (char **) malloc((size_t) (__nbargmax + 2) *
        sizeof(char *));
    for (i = 3; i < __nbargmax + 2; i++)
        Argv_com[nb_com - 1][0][i] = NULL;
    Argv_com[nb_com - 1][0][0] = ch_copy("strucdef");
    Argv_com[nb_com - 1][0][1] = ch_copy_int(ind);
    Argv_com[nb_com - 1][0][2] = ch_copy("#1");
    Is_subst_arg[nb_com - 1][0] = (int *) malloc((size_t) 3 * sizeof(int));
    Is_subst_ligne[nb_com - 1][0] = 1;
    Is_subst_arg[nb_com - 1][0][2] = 1;
    Is_Del_prog[nb_com - 1] = 0;
    Is_visible_prog[nb_com - 1] = 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'strucdef'
--------------------------------------------------------------------*/
int
struc_create(int argc, char *argv[])
{
    int             iw,
                    j,
                    k,
                    nb,
                    typ;
    char            nom[100],
                    h[100];
    flow_data      *flow_interp;

    flow_interp = (flow_data *) argv[-1];
    PTHREAD_LOCK_OBJ(flow_interp);
    nb = 0;
    typ = convert_int(argv[1], flow_interp);

    for (k = 2; k < 3; k++) {
        if (argv[k][0] != '#' && (int) strlen(argv[k]) > 0) {
            memset(nom, 0, 30);
            iw = parse_def(argv[k], &nb, nom, flow_interp);
            if (iw == 0) {
                err_mess(21);
                PTHREAD_UNLOCK_OBJ(flow_interp);
                return -1;
            }
            if (iw == 2)
                test_nom_str(argv[k], typ);
            else {
                for (j = 1; j <= nb; j++) {
                    memset(h, 0, 100);
                    sprintf(h, "%s[%d]", nom, j);
                    test_nom_str(h, typ);
                }
            }
        }
    }

    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Called by the preceeding function. Creates a structure of type
    'typ' if its name h is correct
--------------------------------------------------------------------*/
int
test_nom_str(char *h, int typ)
{
    int             i,
                    j,
                    k,
                    nb,
                    slen;

    nb = Struc_typ[typ].nombre;
    slen = strlen(h);

    if (slen > 20) {
        err_mess(16);
        return -1;
    }


/*----------------------------------------------------
    We look for an non-occupied place in the array
    of structures
----------------------------------------------------*/
    j = 0;

    for (i = 0; i < nb; i++) {
        if (Struc[typ][i].occup == 1)
            j++;
        else
            break;
    }

    if (j == nb) {
        err_mess(17);
        return -1;
    }
    j = i;    /* number of the first non-occupied
                 place */
/*--------------------------------------------------*/



/*----------------------------------------------------
    We verify if the name of the structure is not
    already used
----------------------------------------------------*/
    for (i = 0; i < nb_struc; i++) {
        for (k = 0; k < Struc_typ[i].nombre; k++) {
            if (Struc[i][k].occup == 1) {
                if (comp(Struc[i][k].nom_struc, h) == 1) {
                    err_mess(11);
                    return -1;
                }
            }
        }
    }
/*--------------------------------------------------*/


/*----------------------------------------------------
    Creation of the structure
----------------------------------------------------*/
    Struc[typ][j].occup = 1;
    Struc[typ][j].nom_struc = ch_copy(h);
    Struc[typ][j].nom_mb = (char **) malloc((size_t)
        Struc_typ[typ].nb_membres * sizeof(char *));
    (Struc[typ][j].nom_mb)[0] = (char *) malloc((size_t)
        Struc_typ[typ].nb_membres * _L_OBJNAME * sizeof(char));
    memset((Struc[typ][j].nom_mb)[0], 0, Struc_typ[typ].nb_membres *
        _L_OBJNAME);
    for (i = 1; i < Struc_typ[typ].nb_membres; i++)
        (Struc[typ][j].nom_mb)[i] = (Struc[typ][j].nom_mb)[i - 1] + _L_OBJNAME;

/*--------------------------------------------------*/
    return 0;
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    Function associated to the command 'assign'
--------------------------------------------------------------------*/
int
assign_membre(int argc, char *argv[])
{
    int             iw,
                    iw1,
                    j,
                    k,
                    i0,
                    i,
                    i1;
    char            h[100];
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp = (flow_data *) argv[-1];
    flow_interp->mutex_obj = 1;
    iw = sketch_obj(argv[1], &i0, flow_interp);
    flow_interp->mutex_obj = 0;
    if (iw >= 0) {
        err_mess(18);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 0;
    }
    iw = -1 - iw;
    j = -1;

    for (i = 0; i < Struc_typ[iw].nb_membres; i++) {
        if (comp(argv[2], (Struc_typ[iw].membre_id)[i]) == 1) {
            j = i;
            break;
        }
    }

    if (j == -1) {
        err_mess(19);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 0;
    }
    k = (Struc_typ[iw].type_mb)[j];
    flow_interp->mutex_obj = 1;
    iw1 = sketch_obj(argv[3], &i1, flow_interp);
    flow_interp->mutex_obj = 0;
    if ((k > 0 && iw1 != k) || (k < 0 && iw1 != k)) {
        err_mess(19);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 0;
    }
    if (k > 0)
        memcpy((Struc[iw][i0].nom_mb)[j], Obj[k - 1][i1].nom_obj,
            strlen(Obj[k - 1][i1].nom_obj));
    else {
        if (k < 0)
            memcpy((Struc[iw][i0].nom_mb)[j], Struc[-k - 1][i1].nom_struc,
                strlen(Struc[-k -1][i1].nom_struc));
        else {
            memset(h, 0, 100);
            sprintf(h, "%s_%s=%s", Struc[iw][i0].nom_struc,
                (Struc_typ[iw].membre_id)[j], argv[3]);
            S_convert_float(h, flow_interp);
        }
    }
    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 1;
}
/*------------------------------------------------------------------*/





/*--------------------------------------------------------------------
    Function associated to the command 'desassign'
--------------------------------------------------------------------*/
int
desassign_membre(int argc, char *argv[])
{
    int             iw,
                    j,
                    i0,
                    i;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    flow_interp->mutex_obj = 1;
    iw = sketch_obj(argv[1], &i0, flow_interp);
    flow_interp->mutex_obj = 0;
    if (iw >= 0) {
        err_mess(18);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 0;
    }
    iw = -1 - iw;
    j = -1;

    for (i = 0; i < Struc_typ[iw].nb_membres; i++) {
        if (comp(argv[2], (Struc_typ[iw].membre_id)[i]) == 1) {
            j = i;
            break;
        }
    }

    if (j == -1) {
        err_mess(19);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 0;
    }
    memset((Struc[iw][i0].nom_mb)[j], 0, _L_OBJNAME);
    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 1;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the command 'desc'
--------------------------------------------------------------------*/
int
desc_struct(int argc, char *argv[])
{
    int             iw,
                    i,
                    j,
                    i0;
    char            h[100];
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    PTHREAD_LOCK_OBJ(flow_interp);
    if (flow_interp->PRLEVEL > 0) {
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 1;
    }
    flow_interp->mutex_obj = 1;
    iw = sketch_obj(argv[1], &i0, flow_interp);
    flow_interp->mutex_obj = 0;
    if (iw >= 0) {
        err_mess(21);
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 0;
    }
    iw = -1 -iw;
    print(flow_interp, " Structure %s : \n", Struc_typ[iw].nom);

    for (i = 0; i < Struc_typ[iw].nb_membres; i++) {
        print(flow_interp, "%s (", (Struc_typ[iw].membre_id)[i]);
        j = (Struc_typ[iw].type_mb)[i];
        if (j > 0)
            print(flow_interp, "objet %s) :  ", Obj_typ[j - 1].nom);
        else {
            if (j < 0)
                print(flow_interp, "structure %s) :  ", Struc_typ[-j - 1].nom);
            else
                print(flow_interp, "variable %s_%s) : ",
                    Struc[iw][i0].nom_struc, (Struc_typ[iw].membre_id)[i]);
        }
        if (j != 0) {
            if ((int) strlen((Struc[iw][i0].nom_mb)[i]) > 0)
                print(flow_interp, "%s\n", (Struc[iw][i0].nom_mb)[i]);
            else
                print(flow_interp, "(null)\n");
        }
        else {
            memset(h, 0, 100);
            sprintf(h, "%s_%s", Struc[iw][i0].nom_struc,
                (Struc_typ[iw].membre_id)[i]);
            print(flow_interp, "%f\n", S_convert_float(h, flow_interp));
        }
    }
    PTHREAD_UNLOCK_OBJ(flow_interp);
    return 1;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    If the structure number 'ik' of type 'typ' has a member whose name
    is in 'nom' this function returns 1+i if this member has been
    assigned and is an object of type i. If this member is a structure
    of type i, -1-i is returned. i0 will contain the number of the
    object or structure. If no good member was found, 0 is returned
--------------------------------------------------------------------*/
int
sketch_struc(int typ, int ik, char *nom, int *i0, flow_data *flow_interp)
{
    int             i,
                    iw0,
                    i00,
                    j;

    PTHREAD_LOCK_OBJ(flow_interp);
    if (typ < 0 || typ > nb_struc) {
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 0;
    }
    j = -1;

    for (i = 0; i < Struc_typ[typ].nb_membres; i++) {
        if (comp((Struc_typ[typ].membre_id)[i], nom) == 1) {
            j = i;
            break;
        }
    }

    if (j == -1) {
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 0;
    }
    *i0 = -1;
    if (strlen((Struc[typ][ik].nom_mb)[j]) == 0) {
        PTHREAD_UNLOCK_OBJ(flow_interp);
        return 0;
    }
    flow_interp->mutex_obj = 1;
    iw0 = sketch_obj((Struc[typ][ik].nom_mb)[j], &i00, flow_interp);
    flow_interp->mutex_obj = 0;
    if ((Struc_typ[typ].type_mb)[j] != 0) {
        if (iw0 == (Struc_typ[typ].type_mb)[j])
            *i0 = i00;
    }
   i = (Struc_typ[typ].type_mb)[j];
   PTHREAD_UNLOCK_OBJ(flow_interp);
   return i;
}
/*------------------------------------------------------------------*/


