/*************************************************************************
** interpcom-2.3   (command interpreter)                                 **
** main.c : test program for the command interpreter                     **
**          Minimal application with external initialization file        **
**                                                                       **
** Copyright (C) 2001  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**                                                                       **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details.                     **
**                                                                       **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free           **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      Aile 45-55                                                       **
**      2, place Jussieu                                                 **
**      75251 Paris Cedex 05                                             **
**      France                                                           **
**                                                                       **
 *************************************************************************/

#include "interp.h"
#include <m_apm.h>
#include <gmp.h>
int                 set_mat(int argc, char *argv[]);
int                 _matrix_ev;

int                 _mapm_dec_places = 50;
mpq_t               GMP_Zero,
                    GMP_one;
mpz_t               GMP_Zero_int,
                    GMP_one_int;
pfi                 proc0[] = {
    set_mat,
};

FUNCTION           *Funcs;
FUNCTIONC          *Funcs_C;
extern  FUNCTIONGen Funcs_dummy[];
extern  FUNCTIONGen Funcs_mapm[];
extern  FUNCTIONGen Funcs_GMP[];
extern  FUNCTIONGen Funcs_matrix[];

pfi                *proc[]={
    proc0,
};

FUNCTIONGen        *Funcs_Gen[] = {
    Funcs_dummy,
    Funcs_mapm,
    Funcs_GMP,
    Funcs_matrix,
};

extern EXPREVAL_GEN _dummy_exprev;
extern int          _dummy_NBFONC0;
extern EXPREVAL_GEN _mapm_exprev;
extern int          _mapm_NBFONC0;
extern EXPREVAL_GEN _GMP_exprev;
extern int          _GMP_NBFONC0;
extern EXPREVAL_GEN _matrix_exprev;
extern int          _matrix_NBFONC0;


int
main(int argc, char *argv[])
{
    Funcs = Funcs_interp;
    Funcs_C = Funcs_interp_C;
    _NBFONC = _NBFONC0;
    _NBFONC_C = _NBFONC0_C;
    User_Init_File = NULL;
    prog_c(argc, argv, "interp.ini", NULL, 0, NULL, 0);
    return 0;
}

void
init_prog(flow_data *flow_interp)
{
}

void
init_thread_param(flow_data *flow_interp)
{
}

void init_expr_GEN(flow_data *flow_interp)
{
    NB_expr_eval = 6;
    _NBFONC_Gen[0] = _dummy_NBFONC0;
    Expreval_ops[0] = _dummy_exprev;
    _NBFONC_Gen[1] = _mapm_NBFONC0;
    Expreval_ops[1] = _mapm_exprev;
    _NBFONC_Gen[2] = _GMP_NBFONC0;
    Expreval_ops[2] = _GMP_exprev;
    _NBFONC_Gen[3] = _matrix_NBFONC0;
    Expreval_ops[3] = _matrix_exprev;
    _matrix_ev = 3;  /* number of the matrix expr. ev */
    mpq_init(GMP_Zero);
    mpq_init(GMP_one);
    mpz_init(GMP_Zero_int);
    mpz_init(GMP_one_int);
    mpz_set_si(GMP_one_int, 1);
    mpq_set_num(GMP_one, GMP_one_int);
}

void
clean_thread_param(flow_data *flow_interp)
{
}


extern  M_APM       MM_0_5;
extern  M_APM       MM_0_85;
extern  M_APM       MM_5x_125R;
extern  M_APM       MM_5x_64R;
extern  M_APM       MM_5x_256R;
extern  M_APM       MM_5x_Eight;
extern  M_APM       MM_5x_Sixteen;
extern  M_APM       MM_5x_Twenty;
extern  M_APM       MM_lc_PI;
extern  M_APM       MM_lc_HALF_PI;
extern  M_APM       MM_lc_2_PI;

void
exit_prog()
{
/* cleaning some global mapm variables */
    m_apm_free(MM_0_5);
    m_apm_free(MM_0_85);
    m_apm_free(MM_5x_125R);
    m_apm_free(MM_5x_64R);
    m_apm_free(MM_5x_256R);
    m_apm_free(MM_5x_Eight);
    m_apm_free(MM_5x_Sixteen);
    m_apm_free(MM_5x_Twenty);
    m_apm_free(MM_lc_PI);
    m_apm_free(MM_lc_HALF_PI);
    m_apm_free(MM_lc_2_PI);
    m_apm_free(MM_Zero);
    m_apm_free(MM_One);
    m_apm_free(MM_Two);
    m_apm_free(MM_Three);
    m_apm_free(MM_Four);
    m_apm_free(MM_Five);
    m_apm_free(MM_Ten);
    m_apm_free(MM_PI);
    m_apm_free(MM_HALF_PI);
    m_apm_free(MM_2_PI);
    m_apm_free(MM_E);
    m_apm_free(MM_LOG_E_BASE_10);
    m_apm_free(MM_LOG_10_BASE_E);
    m_apm_free(MM_LOG_2_BASE_E);
    m_apm_free(MM_LOG_3_BASE_E);

    exit(0);
}

void
dest_prop(int typ, int i0, flow_data *flow_interp)
{
}

