/** \file 2D_Collision.h
    Collision detection information/algorithm for sprites.

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.
Permission is granted to use and copy this file for non-commercial use only.  
Please contact the author concerning commercial usage. 
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_2D_COLLISION
#define H_2D_COLLISION

#include <CON_Bitmap.h>

/** Collision detection information for a sprite. */
class Collision2D
{
public:
  /** Construct info base for this bitmap. */
  Collision2D(Bitmap* BM, Rect2D r);

  virtual ~Collision2D();

  /** Returns non-zero value if the specified point is inside
      the borders of the sprite's entity.
  */
  int pointInside(int x, int y);

  /** Check if there is a collision with this object.
      Returns non-zero value if a collision occurred.
      dx,dy specify the offset location of the given
      object from this one.
  */
  int collision(Collision2D& C, int dx, int dy);
protected:
  int  m_w;
  int  m_h;
  int* m_top;
  int* m_bottom;
  int* m_left;
  int* m_right;
  int  m_Status;
};




#endif // H_2D_COLLISION