/** \file 2D_SpriteCache.h
    Cache loader of sprites.

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.
Permission is granted to use and copy this file for non-commercial use only.  
Please contact the author concerning commercial usage. 
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_2D_SPRITECACHE
#define H_2D_SPRITECACHE


#include <2D_Sprite.h>
#include <2D_BitmapCache.h>

/** A Cache to avoid creating multiple instances of identical sprites.
    The key is only the name, in which case two sprites with the same
    name but with different solid setting are considered the same.
*/
class SpriteCache
{
public:
  /** Construct a SpriteCache that will load its bitmaps from the 
      specified ResourceStream.
  */
  SpriteCache(ResourceStream& RS);


 /** Load a sprite into the cache. 
      Notice: for each name there is only one sprite instance.
      If a sprite with the given name already exists in the cache,
      it is returned as is.  use update() to modify settings.

      if Solid != 0, collision info is generated for the sprite.
      if bitmapName == NULL, bitmapName is assumed to be the same as the sprite name.
      if r == Rect2D(0,0,-1,-1) (same as Rect2D()), the rect is the entire bitmap.

      returns NULL if there is no resource named bitmapName (or name if bitmapName==NULL).
  */
  Sprite* load(char* name, int Solid=0, char *bitmapName=NULL, Rect2D r=Rect2D());


  /** update a sprite in the cache .
      returns NULL if an entry does not exist in the cache for name.
  */
  Sprite* update(char* name, int Solid=0, char *bitmapName=NULL, Rect2D r=Rect2D()); 

  /** get from the cache a sprite pointer for the given name.
      returns NULL if there is no sprite in the cache with the given name.
  */
  Sprite* get(char* name);



protected:
  BitmapCache  m_BMCache;
  Hashtable    m_Sprites;
};

#endif // H_2D_SPRITECACHE