/** \file DS_SysDep.h
    System dependent definitions

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.
Permission is granted to use and copy this file for non-commercial use only.
Please contact the author concerning commercial usage.
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_DS_SYSDEP
#define H_DS_SYSDEP

#ifdef WIN32

  #define DLLExport __declspec( dllexport )

  #define stricmp _stricmp
  #define strnicmp _strnicmp

  #ifdef _MSC_VER

  #ifdef _DEBUG
    #pragma comment(linker, "/NoDefaultLib:LIBC")
  #endif

  #pragma comment(lib, "libDS.lib")

  // This disables the 'a non-const must be initialized with an lvalue, not a function' warning
  #pragma warning ( disable : 4270 )
  // This disables the 'Identifier name longer than 255 chars' warning
  #pragma warning ( disable : 4237 )
  // This disables the 'Untagged structure' warning.
  #pragma warning ( disable : 4094 )
  // This disables the 'bool is reserved' warning
  #pragma warning ( disable : 4786 )
  // This disables the 'signed/unsigned mismatch' warning
  #pragma warning ( disable : 4018 )
  #endif


#elif defined ( AIX )

  #define DLLExport 
  #define stricmp strcasecmp
  #define strnicmp strncasecmp
  #include <strings.h>

#else

  #error No system defined (AIX WIN32)

#endif

#include <DS_Global.h>

#endif // H_DS_SYSDEP
