/** \file WO_View.h
    Generic view object.

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.
Permission is granted to use and copy this file for non-commercial use only.
Please contact the author concerning commercial usage.
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_WO_VIEW
#define H_WO_VIEW

#pragma comment(lib, "libWO.lib")

class View {
public:
  /** Must be called before rendering, to ensure correct clipping. */
  virtual int beginRendering() = 0;

  /** Must be called after rendering, to ensure correct clipping. */
  virtual int endRendering() = 0;

};

#endif // H_WO_VIEW
