//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "lebcb_3a.h"
//---------------------------------------------------------------------------
#pragma link "LEBCB"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
  Mark = -1;
  Highlight = FALSE;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::AdjustSettings()
{
   int NewMark;
   long MarkLine = LEdit1->GetBookmarkLine(0);
   MarkLine -= LEdit1->FirstVisibleLine;
   if (MarkLine < 0)
   {
     NewMark = -1;
   }
   else if (MarkLine > MaxMark)
   {
     NewMark = -1;
   }
   else
   {
     NewMark = MarkLine;
   }
   if (NewMark != Mark)
   {
      Mark = NewMark;
      PaintBox1->Invalidate();
   }

}
//---------------------------------------------------------------------------
void __fastcall TForm1::SetDimensions()
{
  Units = LEdit1->UnitsVertical;
  if (Units)
  {
    MaxMark = (ClientHeight / Units) - 1;
    PaintBox1->Invalidate();
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::New1Click(TObject *Sender)
{
  LEdit1->NewFile();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Open1Click(TObject *Sender)
{
  LEdit1->OpenFile();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCloseQuery(TObject *Sender, bool &CanClose)
{
   CanClose = LEdit1->CanClose;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Save1Click(TObject *Sender)
{
  LEdit1->SaveFile();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SaveAs1Click(TObject *Sender)
{
  LEdit1->SaveFileAs();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Exit1Click(TObject *Sender)
{
  Close();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Cut1Click(TObject *Sender)
{
  LEdit1->CutToClipboard();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Copy1Click(TObject *Sender)
{
  LEdit1->CopyToClipboard();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Paste1Click(TObject *Sender)
{
  LEdit1->PasteFromClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Find1Click(TObject *Sender)
{
  LEdit1->ShowFindDialog();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FindNext1Click(TObject *Sender)
{
   LEdit1->FindNext();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Replace1Click(TObject *Sender)
{
  LEdit1->ShowReplaceDialog();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Font1Click(TObject *Sender)
{
   LEdit1->ShowFontDialog();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::AutoIndent1Click(TObject *Sender)
{
   LEdit1->AutoIndent = ! LEdit1->AutoIndent;
   AutoIndent1->Checked = LEdit1->AutoIndent;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::File1Click(TObject *Sender)
{
  Save1->Enabled = LEdit1->CanExecuteCommand(EC_FILESAVE);
  SaveAs1->Enabled = LEdit1->CanExecuteCommand(EC_FILESAVEAS);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Edit1Click(TObject *Sender)
{
  Find1->Enabled = LEdit1->CanExecuteCommand(EC_SEARCHFIND);
  FindNext1->Enabled = LEdit1->CanFindNext;
  Replace1->Enabled = LEdit1->CanExecuteCommand(EC_SEARCHREPLACE);
  Cut1->Enabled = LEdit1->CanExecuteCommand(EC_EDITCUT);
  Copy1->Enabled = LEdit1->CanExecuteCommand(EC_EDITCOPY);
  Paste1->Enabled = LEdit1->CanExecuteCommand(EC_EDITPASTE);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::PaintBox1Paint(TObject *Sender)
{
  TCanvas* C = PaintBox1->Canvas;
  C->Pen->Color = LEdit1->BackColor;
  C->Brush->Color = LEdit1->BackColor;
  C->Rectangle(PaintBox1->Left,PaintBox1->Top,PaintBox1->Width,PaintBox1->Height);
  if (Mark >= 0)
  {
    C->TextOut(0,Units * Mark,"->");
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormResize(TObject *Sender)
{
   SetDimensions();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::LEdit1NewFont(TObject *Sender)
{
   SetDimensions();
   PaintBox1->Font = LEdit1->Font;
   PaintBox1->Font->Color = clRed;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::LEdit1VertScroll(TObject *Sender)
{
   AdjustSettings();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::LEdit1Change(TObject *Sender)
{
  AdjustSettings();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SetHere1Click(TObject *Sender)
{
  LEdit1->SetBookmarkOnCurrent();
  AdjustSettings();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::GoTo1Click(TObject *Sender)
{
  LEdit1->FindBookmark();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::PaintBox1MouseDown(TObject *Sender, TMouseButton Button,
	TShiftState Shift, int X, int Y)
{
   long TheLine = (Y / Units) + LEdit1->FirstVisibleLine;
   if (TheLine > LEdit1->LineCount)
   {
      MessageBeep(0);
   }
   else
   {
      LEdit1->SetBookmark(0,TheLine);
      LEdit1->FindBookmark();
   }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Highlight1Click(TObject *Sender)
{
  Highlight = ! Highlight;
  Highlight1->Checked = Highlight;
  if (Highlight)
  {
     LEdit1->SetBookmarkBackColor(0,clRed);
     LEdit1->SetBookmarkForeColor(0,clYellow);
  }
  else
  {
     LEdit1->RemoveBookmarkBackColor(0);
     LEdit1->RemoveBookmarkForeColor(0);
  }
}
//---------------------------------------------------------------------------
