unit levcl_1a;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Menus, LEVCL;

type
  TForm1 = class(TForm)
    LEdit1: TLEdit;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Edit1: TMenuItem;
    Settings1: TMenuItem;
    New1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    SaveAs1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    N2: TMenuItem;
    Find1: TMenuItem;
    FindNext1: TMenuItem;
    Replace1: TMenuItem;
    Font1: TMenuItem;
    WordWrap1: TMenuItem;
    AutoIndent1: TMenuItem;
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure New1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure Find1Click(Sender: TObject);
    procedure FindNext1Click(Sender: TObject);
    procedure Replace1Click(Sender: TObject);
    procedure Font1Click(Sender: TObject);
    procedure WordWrap1Click(Sender: TObject);
    procedure AutoIndent1Click(Sender: TObject);
    procedure File1Click(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose := LEdit1.CanClose;
end;

procedure TForm1.New1Click(Sender: TObject);
begin
  LEdit1.NewFile
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
  LEdit1.OpenFile
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
  LEdit1.SaveFile
end;

procedure TForm1.SaveAs1Click(Sender: TObject);
begin
  LEdit1.SaveFileAs
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Cut1Click(Sender: TObject);
begin
  LEdit1.CutToClipboard
end;

procedure TForm1.Copy1Click(Sender: TObject);
begin
  LEdit1.CopyToClipboard
end;

procedure TForm1.Paste1Click(Sender: TObject);
begin
  LEdit1.PasteFromClipboard;
end;

procedure TForm1.Find1Click(Sender: TObject);
begin
  LEdit1.ShowFindDialog;
end;

procedure TForm1.FindNext1Click(Sender: TObject);
begin
  LEdit1.FindNext
end;

procedure TForm1.Replace1Click(Sender: TObject);
begin
  LEdit1.ShowReplaceDialog
end;

procedure TForm1.Font1Click(Sender: TObject);
begin
  LEdit1.ShowFontDialog
end;

procedure TForm1.WordWrap1Click(Sender: TObject);
begin
  LEdit1.WordWrap := Not LEdit1.WordWrap;
  WordWrap1.Checked := LEdit1.WordWrap;
  if LEdit1.WordWrap then LEdit1.ScrollBars := lsbVertical else LEdit1.ScrollBars := lsbBoth;
end;

procedure TForm1.AutoIndent1Click(Sender: TObject);
begin
  LEdit1.AutoIndent := Not LEdit1.AutoIndent;
  AutoIndent1.Checked := LEdit1.AutoIndent
end;

procedure TForm1.File1Click(Sender: TObject);
begin
  Save1.Enabled := LEdit1.CanExecuteCommand(EC_FILESAVE);
  SaveAs1.Enabled := LEdit1.CanExecuteCommand(EC_FILESAVEAS);
end;

procedure TForm1.Edit1Click(Sender: TObject);
begin
  Find1.Enabled := LEdit1.CanExecuteCommand(EC_SEARCHFIND);
  FindNext1.Enabled := LEdit1.CanFindNext;
  Replace1.Enabled := LEdit1.CanExecuteCommand(EC_SEARCHREPLACE);
  Cut1.Enabled := LEdit1.CanExecuteCommand(EC_EDITCUT);
  Copy1.Enabled := LEdit1.CanExecuteCommand(EC_EDITCOPY);
  Paste1.Enabled := LEdit1.CanExecuteCommand(EC_EDITPASTE);
end;

end.
