unit levcl_2a;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Menus, LEvcl_2b, LEVCL;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Edit1: TMenuItem;
    Settings1: TMenuItem;
    New1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    SaveAs1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    N2: TMenuItem;
    Find1: TMenuItem;
    FindNext1: TMenuItem;
    Replace1: TMenuItem;
    Font1: TMenuItem;
    WordWrap1: TMenuItem;
    AutoIndent1: TMenuItem;
    OpenDialog1: TOpenDialog;
    procedure New1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure Find1Click(Sender: TObject);
    procedure FindNext1Click(Sender: TObject);
    procedure Replace1Click(Sender: TObject);
    procedure Font1Click(Sender: TObject);
    procedure WordWrap1Click(Sender: TObject);
    procedure AutoIndent1Click(Sender: TObject);
    procedure File1Click(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
    procedure Settings1Click(Sender: TObject);
  private
    { Private declarations }
    FWordWrap: WordBool;
    FAutoIndent: WordBool;
    function CreateNewChild: TForm2;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function TForm1.CreateNewChild: TForm2;
var
  NewChild: TForm2;
begin
  NewChild := TForm2.Create(self);
  if NewChild <> nil then with NewChild.LEdit1 do begin
    WordWrap := FWordWrap;
    if FWordWrap then ScrollBars := lsbVertical;
    AutoIndent := FAutoIndent;
  end;
  CreateNewChild := NewChild;
end;

procedure TForm1.New1Click(Sender: TObject);
begin
  CreateNewChild;
end;

procedure TForm1.Open1Click(Sender: TObject);
var
  NewChild: TForm2;
begin
  if OpenDialog1.Execute then begin
    NewChild := CreateNewChild;
    if NewChild <> nil then
      NewChild.LEdit1.FileName := OpenDialog1.FileName;
  end;
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
  TForm2(ActiveMDIChild).LEdit1.SaveFile
end;

procedure TForm1.SaveAs1Click(Sender: TObject);
begin
  TForm2(ActiveMDIChild).LEdit1.SaveFileAs
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Cut1Click(Sender: TObject);
begin
  TForm2(ActiveMDIChild).LEdit1.CutToClipboard
end;

procedure TForm1.Copy1Click(Sender: TObject);
begin
  TForm2(ActiveMDIChild).LEdit1.CopyToClipboard
end;

procedure TForm1.Paste1Click(Sender: TObject);
begin
  if MDIChildCount = 0 then CreateNewChild;
  if MDIChildCount > 0 then
    TForm2(ActiveMDIChild).LEdit1.PasteFromClipboard
end;

procedure TForm1.Find1Click(Sender: TObject);
begin
  TForm2(ActiveMDIChild).LEdit1.ShowFindDialog;
end;

procedure TForm1.FindNext1Click(Sender: TObject);
begin
  TForm2(ActiveMDIChild).LEdit1.FindNext
end;

procedure TForm1.Replace1Click(Sender: TObject);
begin
  TForm2(ActiveMDIChild).LEdit1.ShowReplaceDialog
end;

procedure TForm1.Font1Click(Sender: TObject);
begin
  TForm2(ActiveMDIChild).LEdit1.ShowFontDialog;
end;

procedure TForm1.WordWrap1Click(Sender: TObject);
var
  i: Integer;
begin
  FWordWrap := Not FWordWrap;
  WordWrap1.Checked := FWordWrap;
  for i := 1 to MDIChildCount do begin
    with TForm2(MDIChildren[i-1]).LEdit1 do begin
      WordWrap := FWordWrap;
      if FWordWrap then ScrollBars := lsbVertical else ScrollBars := lsbBoth;
    end;
  end;
end;

procedure TForm1.AutoIndent1Click(Sender: TObject);
var
  i: Integer;
begin
  FAutoIndent := Not FAutoIndent;
  AutoIndent1.Checked := FAutoIndent;
  for i := 1 to MDIChildCount do
    TForm2(MDIChildren[i-1]).LEdit1.AutoIndent := FAutoIndent;
end;

procedure TForm1.File1Click(Sender: TObject);
begin
  if MDIChildCount > 0 then begin
    Save1.Enabled := TForm2(ActiveMDIChild).LEdit1.CanExecuteCommand(EC_FILESAVE);
    SaveAs1.Enabled := TForm2(ActiveMDIChild).LEdit1.CanExecuteCommand(EC_FILESAVEAS);
  end else begin
    Save1.Enabled := FALSE;
    SaveAs1.Enabled := FALSE;
  end;
end;

procedure TForm1.Edit1Click(Sender: TObject);
begin
  if MDIChildCount > 0 then begin
    Find1.Enabled := TForm2(ActiveMDIChild).LEdit1.CanExecuteCommand(EC_SEARCHFIND);
    FindNext1.Enabled := TForm2(ActiveMDIChild).LEdit1.CanFindNext;
    Replace1.Enabled := TForm2(ActiveMDIChild).LEdit1.CanExecuteCommand(EC_SEARCHREPLACE);
    Cut1.Enabled := TForm2(ActiveMDIChild).LEdit1.CanExecuteCommand(EC_EDITCUT);
    Copy1.Enabled := TForm2(ActiveMDIChild).LEdit1.CanExecuteCommand(EC_EDITCOPY);
    Paste1.Enabled := TForm2(ActiveMDIChild).LEdit1.CanExecuteCommand(EC_EDITPASTE);
  end else begin
    Find1.Enabled := FALSE;
    FindNext1.Enabled := FALSE;
    Replace1.Enabled := FALSE;
    Cut1.Enabled := FALSE;
    Copy1.Enabled := FALSE;
    Paste1.Enabled := TRUE;
  end;
end;

procedure TForm1.Settings1Click(Sender: TObject);
begin
  Font1.Enabled := MDIChildCount > 0;
end;

end.
