/*
 * sample 11
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "mgui.h"

MTColor black, white, cadetblue, seagreen;

void ExitCB(MOBJECT obj, void *a, void *b)
{
	obj = MObjectShell(obj);
	MShellUnrealize(obj);
	MShellDestroy(obj);
	MGUITerm();
	exit(0);
}

void DrawAreaExposeCB(MOBJECT obj, MEvent *pexp, void *a_data)
{
	int hsize, wsize;

	wsize = MObjectWidth(obj);
	hsize = MObjectHeight(obj);
	MDrawLine(obj, 0, 0, wsize, hsize, black);
	MDrawLine(obj, 0, hsize, wsize, 0, white);
	MDrawFilledCircle(obj, wsize/2, hsize/2, wsize/4, cadetblue);
	MDrawCircle(obj, wsize/2, hsize/2, wsize/4, black);

}

void DrawAreaResizeCB(MOBJECT obj, DRAWAREA_PREF *pref, void *label)
{
	char str[128];

	sprintf(str, "Dimensions: %dx%d", pref->new_w, pref->new_h);
	MObjectSetText((MOBJECT )label, str);
}

void DrawAreaInputCB(MOBJECT obj, MEvent *pe, void *a_data)
{
	static int x1, y1, x2, y2;

	if (pe->type == E_BUTTON_PRESS) {
		x1 = x2 = pe->mouse.x;
		y1 = y2 = pe->mouse.y;
		MDrawXorLine(obj, x1, y1, x2, y2);
	}
	else if (pe->type == E_MOTION) {
		MDrawXorLine(obj, x1, y1, x2, y2);
		x2 = pe->mouse.x;
		y2 = pe->mouse.y;
		MDrawXorLine(obj, x1, y1, x2, y2);
	}
	else if (pe->type == E_BUTTON_RELEASE) {
		MDrawXorLine(obj, x1, y1, x2, y2);
		x2 = pe->mouse.x;
		y2 = pe->mouse.y;
		MDrawLine(obj, x1, y1, x2, y2, seagreen);
	}
}

void MGUIMain(int argc, char **argv)
{
	MOBJECT pbutton, shell, label, drawa;

	black = MBlackColor();
	white = MWhiteColor();
	cadetblue = MAllocColor(0x60, 0x85, 0x95);
	seagreen = MAllocColor(0x70, 0xa5, 0xa0);

	shell = MCreateShell("Sample 11", 0);

	label = MCreateLabel(shell, "", HELV_L_FONT);

	drawa = MCreateDrawArea(shell, 256, 256);
	MObjectSetResize(drawa, True, True);
	MDrawAreaSetExposeCallback(drawa, DrawAreaExposeCB, NULL);
	MDrawAreaSetInputCallback(drawa, DrawAreaInputCB, NULL);
	MDrawAreaSetResizeCallback(drawa, DrawAreaResizeCB, label);

	pbutton = MCreatePButton(shell, "Close", TIMES_L_FONT);
	MPButtonSetCallback(pbutton, ExitCB, NULL);

	MShellRealize(shell);
	MMainLoop();
}

