/*
 * This file is part of the MGUI (Morello Graphic User Interface)
 * library. Copyright 1995-2000 Vincenzo Morello.
 *
 * Contains all MGUI macro definitions and typedefs
 */

#ifndef _MGUIDEFS_H
#define _MGUIDEFS_H

#define MGUI_RELEASE    0x320

/*
 * Auto environment detection (if not set):
 * BC_MGUI (DOS BGI), DJGPP_MGUI, W4GW_MGUI, WGRX_MGUI and WIN_MGUI
 * (both 16 & 32 bit) are detected.
 * WIN32 and __WIN32__ are set when compiling for Win32, Win 95 and NT.
 * X11_MGUI is set by default. LIBGRX must be set to compile in LINUX
 * console (svgalib) or GRX under BORLANDC or WATCOMC
 */

#if !defined DJGPP_MGUI && !defined X11_MGUI && !defined BC_MGUI && !defined WIN_MGUI && !defined WGRX_MGUI && !defined W4GW_MGUI
        #if defined __TURBOC__
                #if defined __DPMI32__
                        #define BGI_MGUI
                #elif defined __DPMI16__
                        #define BGI_MGUI
                #elif defined _Windows
                        #define WIN_MGUI
                        #if defined __WIN32__ && !defined WIN32
                                #define WIN32
                        #endif
                #else
                        #define BGI_MGUI
                        #define BC_MGUI
                #endif
        #elif defined __CYGWIN32__
                #define WIN_MGUI
                #define WIN32
                #define __WIN32__
                #define __GNUWIN32__
        #elif defined __MINGW32__
                #define WIN_MGUI
                #define WIN32
                #define __GNUWIN32__
        #elif defined __LCC__
                #define WIN_MGUI
                #define __WIN32__
        #elif defined __RSXNT__
                #define WIN_MGUI
                #define WIN32
                #define __GNUWIN32__
 	#elif defined __GO32__
                #if defined __WIN32__
                        #ifndef WIN32
		                #define WIN32
	                #endif
                        #define WIN_MGUI
                #else
                        #define DJGPP_MGUI
                        #define LIBGRX
                #endif
        #elif defined _WINDOWS
                #define WIN_MGUI
                #ifdef _WINNT
                        #define __WIN32__
                #endif
        #elif defined __WATCOMC__
                #ifdef __NT__
                        #define __WIN32__
                        #define WIN_MGUI
                #elif defined __WINDOWS__
                        #define WIN_MGUI
                #elif defined LIBGRX
                        #define WGRX_MGUI
                #elif defined METAWINDOW
                        #define WMW_MGUI
                #else 
                        #define W4GW_MGUI
                #endif
        #else
                #ifndef LIBGRX
                        #define X11_MGUI
                #endif
                #define UNIX
        #endif
#endif

#if defined __TURBOC__ || defined _MSC_VER || defined __WATCOMC__ || defined __LCC__
#include <time.h>
#elif !defined WIN_MGUI
#include <sys/time.h>
#endif

/*
 * This include file contains key codes definition
 */
#include "keycodes.h"

#ifdef UNIX
#define DIR_SEP   '/'
#else
#define DIR_SEP   '\\'
#endif

/**
   Point structure.
   Used as argument of polyline drawing primitives.
 */
struct MPOINT {
#if defined X11_MGUI
	short x;
	short y;
#else
	int x;
	int y;
#endif
};
typedef struct MPOINT MPOINT;

/**
   Rectangle structure.
 */
struct MRECT {
	int x;
	int y;
	int w;
	int h;
};
typedef struct MRECT MRECT;

/**
   Rectangle list.
 */
struct RLIST {
	MRECT r;
	struct RLIST *next;
};
typedef struct RLIST RLIST;

/*
 * Integer size typedefs
 */
#ifdef X11_MGUI
#include "X11/X.h"
#include <X11/Xmd.h>
#else

        typedef long            INT32;
        typedef short           INT16;
        typedef char            INT8;
        typedef unsigned long   CARD32;
        typedef unsigned short  CARD16;
        typedef unsigned char   CARD8;
#endif /* X11_MGUI */

/**
 Font identifier
 */
typedef int MTFont;

/**
 Mouse cursor identifier
 */
typedef int MTCursor;

/** Color identifier */
typedef CARD32 MTColor;

/* Transparent color definition */
#define NOCOLOR	(~0)

/*
 * Color type definition
 */
#if !defined(X11_MGUI) && !defined(WIN_MGUI)

/**
   Window structure for DOS and Linux/console environments.
 */
struct _Window { MRECT r; RLIST *rl; };
/**
  Window identifier for DOS and Linux/console environments.
 */
typedef struct _Window *Window;

#elif defined WIN_MGUI

/**
  Window identifier under Windows.
 */
typedef void *Window;

#endif

#ifndef True

#define True    1
#define False   0

#endif

/* MGUI Events */

#define E_NO_EVENT              0
#define E_KEY_PRESS             1
#define E_BUTTON_PRESS          2
#define E_BUTTON_RELEASE        3
#define E_MOTION                4
#define E_WINDOW_ENTER          5
#define E_WINDOW_EXIT           6
#define E_EXPOSE                7
#define E_DESTROY               8
#define E_MAP                   9
#define E_UNMAP                 10
#define E_AUTOSIZE              11
#define E_RESIZE                12
#define E_MOVE                  13
#define E_SELECT                14
#define E_DESELECT              15
#define E_TIMER                 16
#define E_FOCUS_IN              17
#define E_FOCUS_OUT             18
#define E_CONFIGURE             19
#define E_PARENT_MAP            20
#define E_PARENT_UNMAP          21
#define E_SET_COLOR             22
#define E_SET_SHADOW            23
#define E_SET_TEXT              24
#define E_GET_TEXT              25
#define E_WM_CLOSE              26
#define E_SET_SENS              27
#define E_SET_PARENT_SENS       28
#define E_GRAB_LOSE             29
#define E_SET_BG_IMAGE          30

/*  Event Masks */

#define EM_NO_EVENT             0L
#define EM_KEY_PRESS            1L
#define EM_BUTTON_PRESS     (1L<<1)
#define EM_BUTTON_RELEASE   (1L<<2)
#define EM_MOTION           (1L<<3)
#define EM_WINDOW_ENTER     (1L<<4)
#define EM_WINDOW_EXIT      (1L<<5)
#define EM_EXPOSE           (1L<<6)
#define EM_DESTROY          (1L<<7)
#define EM_MAP              (1L<<8)
#define EM_UNMAP            (1L<<9)
#define EM_AUTOSIZE         (1L<<10)
#define EM_RESIZE           (1L<<11)
#define EM_MOVE             (1L<<12)
#define EM_SELECT           (1L<<13)
#define EM_DESELECT         (1L<<14)
#define EM_TIMER            (1L<<15)
#define EM_FOCUS_IN         (1L<<16)
#define EM_FOCUS_OUT        (1L<<17)
#define EM_CONFIGURE        (1L<<18)
#define EM_PARENT_MAP       (1L<<19)
#define EM_PARENT_UNMAP     (1L<<20)
#define EM_SET_COLOR        (1L<<21)
#define EM_SET_SHADOW       (1L<<22)
#define EM_SET_TEXT         (1L<<23)
#define EM_GET_TEXT         (1L<<24)
#define EM_WM_CLOSE         (1L<<25)
#define EM_SET_SENS         (1L<<26)
#define EM_SET_PARENT_SENS  (1L<<27)
#define EM_GRAB_LOSE        (1L<<28)
#define EM_SET_BG_IMAGE     (1L<<29)

/*
 * Mouse button bits in mouse events
 */

#ifndef X11_MGUI

#define Button1Mask             (1<<8)
#define Button2Mask             (1<<9)
#define Button3Mask             (1<<10)

#define Button1                 1
#define Button2                 2
#define Button3                 3

/*
 * Keyboard Modifier keys
 */
#define ShiftMask       (1<<0)
#define LockMask        (1<<1)
#define ControlMask     (1<<2)

#endif

#define AltMask         (1<<3)

/**
  Pointer to the image raw pixel data.
 */
#if defined BC_MGUI || defined __DPMI16__ || defined WIN_MGUI && !defined __WIN32__ && !defined _MSC_VER
typedef unsigned char huge *IMAGE_DATA;
#else
typedef unsigned char *IMAGE_DATA;
#endif

/**
   This structure describes the colormap entry.
 */
struct IMAGE_CMAP {
				/** Blue color component */
	unsigned char blue;
				/** Green color component */
        unsigned char green;
				/** Red color component */
        unsigned char red;
				/** Palette index */
        unsigned char index;
};
typedef struct IMAGE_CMAP IMAGE_CMAP;

/**
  Image description structure
 */
struct MIMAGE_DESCR {
				/** Boolean flag describing whether image colors
				 have been allocated or not */
        unsigned int installed;
				/** Number of colors in the image (0 if TrueColor */
        unsigned int ncolors;
				/** Number of planes in the image (1,4,8,24) */
        unsigned int nplanes;
				/** Image width in pixel units */
        unsigned int img_w;
				/** Image height in pixel units */
        unsigned int img_h;
				/** Bytes per row */
        unsigned int row_w;
				/** Low level pixmap id (system dependent) */
        CARD32 pixmap_id;
				/** Image colormap (NULL for 24 planes images) */
        IMAGE_CMAP *colormap;
				/** Image raw pixel data */
        IMAGE_DATA data;
				/** Image file name (if loaded from file) */
        char *fname;
		struct MIMAGE_DESCR *mask;
				/** Low level pixmap id for mask(system dependent) */
        CARD32 mask_id;
};
typedef struct MIMAGE_DESCR MIMAGE_DESCR;

typedef MIMAGE_DESCR *MIMAGE;


/**
   Generic window event.
   This structure contains the fields common in all events generated
   by the windowing system.
 */
struct MAnyWindowEvent {
        int type;
        Window window;
};
typedef struct MAnyWindowEvent MAnyWindowEvent;

/**
   Keyboard event.
 */
struct MKeyEvent {
        int type;
        Window window;
        unsigned int state;
        unsigned int keycode;
};
typedef struct MKeyEvent MKeyEvent;

typedef MAnyWindowEvent MWMCloseEvent;

typedef MAnyWindowEvent MFocusEvent;

typedef MAnyWindowEvent MUnmapEvent;

typedef MAnyWindowEvent MMapEvent;

typedef MAnyWindowEvent MSelectEvent;

typedef MAnyWindowEvent MDeSelectEvent;

struct MMouseEvent {
        int type;
        Window window;
        int x, y;               /* pointer x, y coordinates in event window */
        int x_root, y_root;     /* coordinates relative to root */
        unsigned int state;     /* buttons and key modifiers mask */
        unsigned int button;    /* button */
};
typedef struct MMouseEvent MMouseEvent;

struct MExposeEvent {
        int type;
        Window window;
        int x_off, y_off;
        int x, y;
        int width, height;
};
typedef struct MExposeEvent MExposeEvent;

struct MResizeEvent{
        int type;
        Window window;
        int width, height;
};
typedef struct MResizeEvent MResizeEvent;

typedef struct {
        int type;
        Window window;
        int x, y;
        int width, height;
} MConfigureEvent;

typedef struct {
        int type;
        Window window;
        int x, y;
} MMoveEvent;

/* misc events (related to Objects rather than windows). */

typedef struct {
        int type;
        int sensitive;
} MSetSensitivity;

typedef struct {
        int type;
        char *text;
} MSetGetTextEvent;

typedef struct {
        int type;
        MTColor bgc;
        MTColor fgc;
} MSetColorEvent;

typedef struct {
        int type;
        int shadow;
        int in_thick;
        int out_thick;
} MSetShadowEvent;

typedef struct {
        int type;
        void *id;
        void *user_data;
} MTimerEvent;

typedef struct {
        int type;
        MIMAGE img;
        CARD8  mode;
} MSetBGImageEvent;

union MEvent {
        int type;
        MAnyWindowEvent any_window_event;
        MKeyEvent key;
        MMouseEvent mouse;
        MExposeEvent expose;
        MWMCloseEvent wm_close;
        MFocusEvent focus;
        MUnmapEvent unmap;
        MMapEvent map;
        MDeSelectEvent deselect;
        MSelectEvent select;
        MConfigureEvent configure;
        MResizeEvent resize;
        MMoveEvent move;
        MSetColorEvent setcolor;
        MSetShadowEvent setshadow;
        MSetGetTextEvent setgettext;
        MSetSensitivity setsensitivity;
		MSetBGImageEvent setbgimage;
};
typedef union MEvent MEvent;


/*
 * Pointer static cursors
 */

#define MC_NONE       (MTCursor)0
#define MC_UL_ARROW   (MTCursor)1
#define MC_CROSSHAIR  (MTCursor)2
#define MC_HOURGLASS  (MTCursor)3

/*
 * Static fonts
 */
#define DEFAULT_FONT    0
#define FIXED_SMALL     1
#define FIXED_MEDIUM    2
#define FIXED_LARGE     3
#define HELV_SMALL      4
#define HELV_MEDIUM     5
#define TIMES_SMALL     6
#define TIMES_MEDIUM    7
#define HELV_LARGE      8
#define TIMES_LARGE     9



/*
 * Static fonts
 * WARNING: OBSOLETE
 */
#define SMALL_FONT      FIXED_SMALL
#define MEDIUM_FONT     FIXED_MEDIUM
#define LARGE_FONT      FIXED_LARGE
#define TIMES_N_FONT    TIMES_SMALL
#define TIMES_L_FONT    TIMES_MEDIUM
#define HELV_N_FONT     HELV_SMALL
#define HELV_L_FONT     HELV_MEDIUM

/*
 * Alignment options:
 *  The first 3 are used for text alignment in LABEL and text-only BUTTON
 *	objects and in Text drawing primitives.
 *  All are also used to align objects in the TableForm cell's boundaries
 *  when a Form is enlarged. Moreover them all can be used to set the
 *  Text vs Image alignment in Buttons (Push/Toggle/Radio) having both
 *  image and text.
 */
#define LEFT_ALIGN      0
#define RIGHT_ALIGN     1
#define CENTER_ALIGN    2
#define TOP_ALIGN	3
#define BOTTOM_ALIGN	4
#define UNDEF_ALIGN     0x3f

/*
 * Object Options (for use with MObjectEnableOptions() and MObjectSaveOptions()
 */

#define MO_FONT         0x1
#define MO_FGCOLOR      0x2
#define MO_BGCOLOR      0x4
#define MO_SHADOW       0x8
#define MO_TEXT         0x10

#define MO_COLOR        (MO_FGCOLOR|MO_BGCOLOR)
#define MO_ALL          0x1f


/*
 * Object background Image drawing modes
 */

#define BI_TILED	0
#define BI_CENTERED	1
#define BI_SIZE_FORCING	2	/* Object size is forced to be equal to image size */


/*
 * Object shadows
 */

#define WS_NONE         0
#define WS_SHADOW_OUT   1
#define WS_SHADOW_IN    2
#define WS_ETCHED_IN    3
#define WS_ETCHED_OUT   4
/*
 * The following macros are present only for sources written for
 * release 1.4.3 or earlier. Don't use in new sources!
 */
#define WS_HATCHED_IN   WS_ETCHED_IN
#define WS_HATCHED_OUT  WS_ETCHED_OUT

/* Object Types */

#define OT_SHELL        1
#define OT_FORM         2
#define OT_LABEL        3
#define OT_PBUTTON      4
#define OT_TBUTTON      5
#define OT_RBUTTON      6
#define OT_SCROLLBAR    7
#define OT_EDIT         8
#define OT_STATUSBAR    9
#define OT_TEXT         10
#define OT_SBLIST       11
#define OT_MENUBAR      12
#define OT_MENU         13
#define OT_DRAWAREA     14

/**
  MOBJECT is the Object type identifier.
 */
#ifdef _MGUI_OBJECT_H
        typedef struct mobj_s *MOBJECT;
#else
        typedef void *MOBJECT;
        #ifdef OLD_MGUI_DEF
                typedef void OBJECT, MIMAGE_DESCR;
        #endif
#endif

/*
 * SHELL creation options (bitwise or-ed in the 'flags' parameter)
 */
#define SF_NO_FOCUS_CHANGE      0x1     /* Internal use (MENU) */
#define SF_SAVEUNDER            0x2     /* The area under the appearing SHELL
                                         * window is stored for a fast redraw
                                         * when the window is deleted
                                         */
#define SF_MODAL                0x4     /* Input focus is grabbed by the SHELL
                                         * until it is removed
                                         */
#define SF_POPUP                0x8     /* Undecorated window look (MENU) */

#define SF_IGNORE_WM_CLOSE      0x10    /* SHELL ignores the CLOSE message
                                         * sent by the Window Manager
                                         */
#define SF_UNMAP_ON_WM_CLOSE    0x20    /* The SHELL only unmaps itself
                                         * (not destroy) when receives the
                                         * CLOSE message from the Window Manager
                                         */
#define SF_NO_CLOSE             0x40    /* No close button in the title bar */
#define SF_NO_MAXIMIZE          0x80    /* No maximize button in the title bar*/
#define SF_NO_MINIMIZE          0x100   /* No minimize button in the title bar*/
#define SF_NO_RESIZE            0x200   /* Resize disabled */

#define DEF_POSITION -32768		/* Default x/y position useable in MShellRealizeXY */
#define DEF_SIZE	 -32768		/* Default width/height useable in MShellRealizeXYWH */

/* SPOOL */

#define MSPOOL_OK               0
#define MSPOOL_FULL_QUEUE       -1
#define MSPOOL_NOT_READY        -2
#define MSPOOL_FILE_ERR         -3

/* Child Preferred Attachment */

#define F_PREF_ATT_POS  0
#define F_PREF_ATT_ROW  1
#define F_PREF_ATT_COL  2
#define F_PREF_ATT_TABLE 3

/* Child Attachment */

#define F_ATT_NONE      0
#define F_ATT_FORM      1
#define F_ATT_OBJ       2

/**
  DrawArea Object's resize preferences (for use in the resize callback)
 */

struct DRAWAREA_PREF {
			/** Old width */
        int old_w;
			/** Old height */
        int old_h;
			/** New width */
        int new_w;
			/** New height */
        int new_h;
};
typedef struct DRAWAREA_PREF DRAWAREA_PREF;

/* SCROLLBAR TYPE (for use in the MCreateScrollBar() */

#define SBT_HOR         0
#define SBT_VERT        1

/* SBLIST */
#define SBLT_TEXT       0
#define SBLT_LIST       1
#define SBLT_ELIST      2
#define SBLT_FILE       3
#define SBL_ITEM_SELECTED       0x1L
#define SBL_ITEM_CHECKED        0x2L

/**
  List Item structure.
  Primarily used to supply data in virtual list Objects (Skip and Block Lists).
 */
struct XL_ITEM {
				/** Points to next item */
        struct XL_ITEM  *next;
				/** Points to the item text */
        char            *data;
        			/** Internal use */
        long            misc;
        			/** Item's user data */
        void            *u_data;
};
typedef struct XL_ITEM XL_ITEM;

/**
  List Item Activation structure.
  This structure is passed by the List Object to notify item activation.
 */

struct LIST_ACT {
			/** Item text */
        char *item;
        		/** Item's user data */
        void *u_data;
        		/** Item's position in the list */
        long pos;
        			 /** Item's selection status flag */
        unsigned char selected;
        			 /** Item's check status flag */
        unsigned char checked;
};
typedef struct LIST_ACT LIST_ACT;

/**
  List Item Selection structure.
  This structure is passed by the List Object to the
  Selection callback when the focused item changes.
 */

struct LIST_SEL {
			/** Item text */
        char *item;
        		/** Item's user data */
        void *u_data;
        		/** Item's position in the list */
        long pos;
        			/** Item's selection status flag */
        unsigned char selected;
        			/** Item's check status flag */
        unsigned char checked;
        		/** Event that causes the call (mouse or keyboard).
                    	    NULL if the change is due to a DelItem
                    	*/
        MEvent *pe;
};
typedef struct LIST_SEL LIST_SEL;

/**
  Template structure for the EditList Object's creation.
 */

struct EL_TEMPLATE {
			/** Field's head */
        char *head;
        		/** Field's length */
        short len;
        		/** Field's visible len */
        short vis_len;
        		/** Editable flag */
        short changeable;
        		/** Edit Object returned */
        MOBJECT edit;
        		/** Label heading returned */
        MOBJECT label;
};
typedef struct EL_TEMPLATE EL_TEMPLATE;

/**
   This structure is passed to the NewBlock callback by the 'Clip' and
   'Skip' List Objects. The first member is significant only for
   the 'Skip' List. The member 'offset' is relative to the location
   specified by 'from'.
   The member 'nr' is also a return value of the callback in case of
   'Skip' List Object. It specifies the number of rows actually returned.
 */

struct SBL_NEW_BLOCK {
			/** SEEK_SET, SEEK_CUR, SEEK_END */
        int from;
        		/** Starting offset position */
        long offset;
        		/** Item length */
        int nc;
        		/** Number of rows (to supply/returned) */
        int nr;
        		/** Pointer to destination item list */
        XL_ITEM *pi;
};
typedef struct SBL_NEW_BLOCK SBL_NEW_BLOCK;

/**
   This structure is used by the ItemSeek callback for 'Clip' and 'Skip' lists.
   The second member specifies the searching substring.
   The first is the callback returned item position. It should be set to
   -1L if not found, 0 in case of Skip List, the actual item position
   otherwise.
 */

struct SBL_ITEM_SEEK {
			/** returned item's position */
        long pos;
        		/** item to seek to substring */
        char *sub_item;
};
typedef struct SBL_ITEM_SEEK SBL_ITEM_SEEK;


#define XLItemCheck(pxl)        ((pxl)->misc |= SBL_ITEM_CHECKED)
#define XLItemUncheck(pxl)      ((pxl)->misc &= ~SBL_ITEM_CHECKED)

/* Basic EDIT filter value */

#define NOCHAR          0
#define ANYCHAR         0x1
#define ALPHA           0x2
#define DIGIT           0x4
#define SPACE           0x8

/* Basic filter modifiers */

#define SIGNED          0x100
#define DOT             0x200
#define UPPER           0x400
#define LOWER           0x800

/* Composed filter values */

#define ALPHANUM        (ALPHA|DIGIT)
#define UPALPHA         (ALPHA|UPPER)
#define LOWALPHA        (ALPHA|LOWER)
#define U_INT            DIGIT
#define S_INT           (DIGIT|SIGNED)
#define U_FLOAT         (DIGIT|DOT)
#define S_FLOAT         (DIGIT|DOT|SIGNED)

/**
   Cursor Position structure for the Edit Object.
   This structure is passed to the CursorPosition callback
 */

struct EDIT_CURS {
		/** cursor position in the text stream */
        int pos;
        	/** cursor x position */
        int pos_x;
        	/** cursor y position */
        int pos_y;
};
typedef struct EDIT_CURS EDIT_CURS;

/**
   Value Change structure for the Edit Object.
   The Edit Object passes this structure to the ValueChange callback
   when its text changes. Last member is a return flag.
 */

struct EDIT_CHANGE {
				/** EDIT text before the change */
        char *current_text;
        			/** New text */
        char *change;
        		/** New text insert position */
        int pos;
        		/** Current text's lenght to substitute */
        int len;
        		/** New text's lenght */
        int change_len;
        		/** Validation flag */
        unsigned validate;
        		/** Reject the change if False */
        unsigned exec;
};
typedef struct EDIT_CHANGE EDIT_CHANGE;

/**
  Validation structure for the EditField Object.
  The EDIT Object passes this structure to the Validation callback when
  it's about to lose the input focus. Last three members are return flags.
 */
struct EDIT_VAL {
			/** EDIT text */
        char *text;
        		/** Text lenght */
        short len;
        		/** Key code originator (0 if not applicable) */
        int key;
        			/** If True, EDIT will lose the focus anyway */
        unsigned focus_lost;
        			/** If set to False, EDIT will keep focus */
        unsigned focus_leave;
        			/** If set to True EDIT redraws itself */
        unsigned text_changed;
        			/** If set to True EDIT becomes validated */
        unsigned text_validated;
};
typedef struct EDIT_VAL EDIT_VAL;

/* MENU */

typedef void *MENU_ITEM;


typedef CARD32  TIMEOUT_ID;
typedef INT32 MVALUE;

typedef void (*TIMEOUT_CB)(TIMEOUT_ID id, void *data);
typedef int (*STRCMP_CB)(const char *, const char *);

#ifdef NO_MGUI_CB_PROTO
typedef void (*MGUI_CB)();
#else
typedef void (*MGUI_CB)(MOBJECT obj, void *od, void *ad);
#endif

#if defined UNIQUE_CB_PROTO || defined NO_MGUI_CB_PROTO
typedef MGUI_CB OBJ_EVENT_CB;
typedef MGUI_CB OBJ_STRING_CB;
typedef MGUI_CB OBJ_VALUE_CB;
typedef MGUI_CB WM_CLOSE_CB;
typedef MGUI_CB NEW_BLOCK_CB;
typedef MGUI_CB ITEM_SEEK_CB;
typedef MGUI_CB EDIT_VAL_CB;
typedef MGUI_CB EDIT_CURS_CB;
typedef MGUI_CB EDIT_CHANGE_CB;
typedef MGUI_CB LIST_ACT_CB;
typedef MGUI_CB LIST_SEL_CB;
typedef MGUI_CB DRAWAREA_PREF_CB;
typedef MGUI_CB MENU_ITEM_CB;
#else
typedef void (*OBJ_EVENT_CB)(MOBJECT obj, MEvent *e, void *ad);
typedef void (*OBJ_STRING_CB)(MOBJECT obj, char *str, void *ad);
typedef void (*OBJ_VALUE_CB)(MOBJECT obj, MVALUE value, void *ad);
typedef void (*WM_CLOSE_CB)(MOBJECT obj, void *odata, void *cdata);
typedef void (*NEW_BLOCK_CB)(MOBJECT obj, SBL_NEW_BLOCK *nbs, void *ad);
typedef void (*ITEM_SEEK_CB)(MOBJECT obj, SBL_ITEM_SEEK *iss, void *ad);
typedef void (*EDIT_VAL_CB)(MOBJECT edit, EDIT_VAL *ev, void *ad);
typedef void (*EDIT_CURS_CB)(MOBJECT edit, EDIT_CURS *ev, void *ad);
typedef void (*EDIT_CHANGE_CB)(MOBJECT edit, EDIT_CHANGE *ec, void *ad);
typedef void (*LIST_ACT_CB)(MOBJECT list, LIST_ACT *la, void *ad);
typedef void (*LIST_SEL_CB)(MOBJECT list, LIST_SEL *la, void *ad);
typedef void (*DRAWAREA_PREF_CB)(MOBJECT drawa, DRAWAREA_PREF *dp, void *ad);
typedef void (*MENU_ITEM_CB)(MENU_ITEM item, MVALUE status, void *ad);
#endif /* UNIQUE_CB_PROTO */

/*
 *  Graphic printing currently works only under Windows
 */

#ifdef WIN_MGUI

/*
 * Macros for specifying the page mode
 */
#define PM_FULL		0	/* the printing is maximized */
#define PM_MM		1	/* dimesnsions in mm */
#define PM_PIXEL	3	/* dimensions in printer pixels */
#define PM_PERC		4	/* dimensions in percentage (0-100%) of the paper size */

/*
 * Macros for specifying the paper orientation
 */
#define PO_DEFAULT	 0	/* use the printer setup default */
#define PO_PORTRAIT  1  /* portrait orientation */
#define PO_LANDSCAPE 2  /* landscape orientation */

typedef struct
{
	int mode;	/* Page mode one of PM_FULL, PM_MM, PM_PIXEL, PM_PERC */
	int x;		/* X position of the object to print (-1 to center horiz) */
	int y;		/* Y position of the object to print (-1 to center vert) */
	int w;		/* Width of the object to print */
	int h;		/* Height of the object to print */
} MPRINT_OPTIONS;

typedef struct
{
	int startPage;	/* Starting page to print */
	int endPage;	/* Ending page to print */
	int minPage;	/* min printable page */
	int maxPage;	/* max printable page */
} MPAGE_OPTIONS;

typedef void *DOC_ID;

#endif /* WIN_MGUI */
#endif
