/*
 *    File statbar.cpp
 *      Demonstrates the use of the STATUSBAR Object
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mguipp.h"

#include "mguitest.hpp"

#define END_VALUE	100
#define TIME_OUT	(500L)

class StatusBarDialog : public CmCallback
{
    CmShell *shell;
public:
    StatusBarDialog();
    void closeDialog(void) { delete shell; delete this; };
};

class CaStatusBar:public CmStatusBar
{
    CmTimeout *ptm;
    int elapsed;
      public:
      CaStatusBar(CmContainer * parent, char *text, int max, MTFont font);
     ~CaStatusBar(void);
    void update(void);
};

CaStatusBar::CaStatusBar(CmContainer * parent, char *text, int max, MTFont font)
 : CmStatusBar(parent, text, max, font)
{
    ptm = new CmTimeout(this, (VOID_CB)(&CaStatusBar::update), TIME_OUT, 1);
    elapsed = 0;
}

CaStatusBar::~CaStatusBar(void)
{
    delete ptm;
}

void CaStatusBar::
update(void)
{
    char str[128];

/*
 * The Object itself contains in its user data
 * the current progress percentage
 */
    elapsed += 2;
    sprintf(str, "%d %%", elapsed);
/*
 * Update the STATUSBAR text and position
 */
    setText(str);
    setPos(elapsed);
/*
 * If at the end, stop the Timeout
 */
    if (elapsed >= END_VALUE)
	ptm->stop();
}

StatusBarDialog::StatusBarDialog(void)
{
    CmSFile *sfile;
    CmPushButton *pb;

    shell = new CmShell("Status Bar", 0);
	shell->setBackgroundImageFile("tile5.bmp", BI_TILED);
/*
 * Create a STATUSBAR Object with the initial text '0 %' and
 * a maximum value of 'END_VALUE'
 */
    CaStatusBar *sbar = new CaStatusBar(shell, "0 %", END_VALUE, HELV_MEDIUM);
    sbar->setTransparency(255);
	sbar->setSliderColor(seagreen);
/*
 * Create a SFILE Object to view this source file in the dialog
 */
    sfile = new CmSFile(shell, __FILE__, FIXED_MEDIUM, 10, 48);
    sfile->setTransparency(255);
/*
 * This PUSH BUTTON closes the dialog
 */
    pb = new CmPushButton(shell, "Close", TIMES_MEDIUM);
    pb->setCallback(this, (VOID_CB)&StatusBarDialog::closeDialog);

    shell->realize();
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void
StatusBarDemo(void)
{
	new StatusBarDialog;
}
