// MiniFTP copyright 1997 Paul Gerhart pgerhart@voicenet.com
// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "miniftp.h"
#include "doc.h"
#include "view.h"
#include "sendvw.h"
#include "mainfrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define WM_WINSOCK_EVENT_FRAME_CONTROL (WM_USER+4)	 // for winsock messages
#define WM_WINSOCK_EVENT_VU_CONTROL (WM_USER+4+10)	 // for winsock messages
#define WM_WINSOCK_EVENT_FRAME_LISTEN (WM_USER+6)	 // for winsock messages
#define WM_WINSOCK_EVENT_VU_LISTEN (WM_USER+6+10)	 // for winsock messages
#define WM_WINSOCK_EVENT_FRAME_DATA (WM_USER+8)	 // for winsock messages
#define WM_WINSOCK_EVENT_VU_DATA (WM_USER+8+10)	 // for winsock messages

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_NCLBUTTONDOWN()
	//}}AFX_MSG_MAP
	// Global help commands
	ON_COMMAND(ID_HELP_FINDER, CFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CFrameWnd::OnHelpFinder)
	ON_MESSAGE(WM_WINSOCK_EVENT_FRAME_CONTROL,OnWinsockEventControl)
	ON_MESSAGE(WM_WINSOCK_EVENT_FRAME_LISTEN,OnWinsockEventListen)
	ON_MESSAGE(WM_WINSOCK_EVENT_FRAME_DATA,OnWinsockEventData)

END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
//	ID_MYSBPANE
//	ID_INDICATOR_CAPS,
//	ID_INDICATOR_NUM,
//	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction
CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// fix the caption
	DWORD x = 0;
	x |= FWS_ADDTOTITLE;
	cs.style &= ~x;
//	cs.style &= ~FWS_ADDTOTITLE;  was suggested style in MFC FAQ but it is bad logic
	
	// set the position
	float fClientWidth = (float)0.75;       // think of this as a percentage  of the screen that the
													// client will consume
	int hr = ::GetSystemMetrics( SM_CXSCREEN );
	int vr = ::GetSystemMetrics( SM_CYSCREEN );
	cs.cx = (int)((float)hr * fClientWidth);  // consume fClientWidth% of the x pixels
//	cs.cx = 720;  // consume fClientWidth% of the x pixels
	cs.cy = (int)((float)vr * fClientWidth);  // consume fClientWidth% of the y pixels
	cs.x  = (hr - cs.cx)/2;  // centers the window
	cs.y  = (vr - cs.cy)/2;  // centers the window
	
	// call the base class and return
	BOOL b = CFrameWnd::PreCreateWindow(cs);
	return(b);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG


BOOL CMainFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	if (m_wndSplitter.CreateStatic(this,2,1))
	{
		CRect rect;
		GetClientRect(&rect);
		CSize size = rect.Size();
		size.cy-=100;
		if (m_wndSplitter.CreateView(0,0,RUNTIME_CLASS(CMiniFTPView),size,pContext))
		{
			if (m_wndSplitter.CreateView(1,0,RUNTIME_CLASS(CSendView),CSize(0,0),pContext))
			{
				SetActiveView((CView*)m_wndSplitter.GetPane(0,0));
				return TRUE;	
			}
		}
	}
	return FALSE;
}

void CMainFrame::OnNcLButtonDown(UINT nHitTest, CPoint point) 
{
	// set the upper window active so the menu picks work right
	SetActiveView((CView*)m_wndSplitter.GetPane(0,0));
	CFrameWnd::OnNcLButtonDown(nHitTest, point);
}


/////////////////////////////////////////////////////////////////////////////
LONG CMainFrame::OnWinsockEventControl (WPARAM wParam, LPARAM lParam)
{
	CMiniFTPView * pView = (CMiniFTPView *)(m_wndSplitter.GetPane(0,0));

	pView->SendMessage(WM_WINSOCK_EVENT_VU_CONTROL,wParam,lParam);
	return 0L;
}

/////////////////////////////////////////////////////////////////////////////
LONG CMainFrame::OnWinsockEventListen (WPARAM wParam, LPARAM lParam)
{
	CMiniFTPView * pView = (CMiniFTPView *)(m_wndSplitter.GetPane(0,0));

	pView->SendMessage(WM_WINSOCK_EVENT_VU_LISTEN,wParam,lParam);
	return 0L;
}

/////////////////////////////////////////////////////////////////////////////
LONG CMainFrame::OnWinsockEventData (WPARAM wParam, LPARAM lParam)
{
	CMiniFTPView * pView = (CMiniFTPView *)(m_wndSplitter.GetPane(0,0));

	pView->SendMessage(WM_WINSOCK_EVENT_VU_DATA,wParam,lParam);
	return 0L;
}

