// MiniFTP copyright 1997 Paul Gerhart pgerhart@voicenet.com
// sendvw.cpp : implementation file
//

#include "stdafx.h"
#include "MiniFTP.h"

#include "doc.h"
#include "view.h"
#include "sendvw.h"
#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSendView

IMPLEMENT_DYNCREATE(CSendView, CEditView)

BEGIN_MESSAGE_MAP(CSendView, CEditView)
	//{{AFX_MSG_MAP(CSendView)
	ON_WM_CHAR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSendView construction/destruction

CSendView::CSendView()
{
}

CSendView::~CSendView()
{
}

/////////////////////////////////////////////////////////////////////////////
// CSendView drawing

void CSendView::OnDraw(CDC* pDC)
{
}

/////////////////////////////////////////////////////////////////////////////
// CSendView diagnostics

#ifdef _DEBUG
void CSendView::AssertValid() const
{
	CEditView::AssertValid();
}

void CSendView::Dump(CDumpContext& dc) const
{
	CEditView::Dump(dc);
}

CMiniFTPDoc* CSendView::GetDocument() // non-debug version is inline
{
	return STATIC_DOWNCAST(CMiniFTPDoc, m_pDocument);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSendView message handlers

BOOL CSendView::PreCreateWindow(CREATESTRUCT& cs) 
{
	BOOL ret = CEditView::PreCreateWindow(cs);
	cs.style = AFX_WS_DEFAULT_VIEW | WS_VSCROLL | WS_HSCROLL | ES_AUTOHSCROLL |
		ES_AUTOVSCROLL | ES_MULTILINE | ES_NOHIDESEL;
	return ret;
}

void CSendView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if ((nChar != VK_RETURN) || (nRepCnt!=1))
	{
		CEditView::OnChar(nChar, nRepCnt, nFlags);
		return;
	}
	else
	{
		CMainFrame * pFWnd = (CMainFrame * )AfxGetMainWnd();
		ASSERT( pFWnd != NULL);
		CMiniFTPView * pView = (CMiniFTPView *)(pFWnd->m_wndSplitter.GetPane(0,0));
		// only do if object valid (i.e. there is still a connection to send to)
		if(pView->m_sktControl != INVALID_SOCKET)
		{
			CString strText;
			GetEditCtrl().GetWindowText(strText);
			pView->UserCommand( strText );
		}
		else
		{
			::MessageBeep(MB_OK);
		}
		// clear the user input edit box
		GetEditCtrl().SetWindowText("");
	}
}










