/*
 * Decompiled with CFR 0.152.
 */
package cc.gammasoft.date;

import cc.gammasoft.date.AbstractCalendarView;
import cc.gammasoft.date.DatePickerDateLabel;
import cc.gammasoft.date.DatePickerLabel;
import cc.gammasoft.date.MonthViewButtons;
import cc.gammasoft.date.MonthViewStatusPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class MonthView
extends AbstractCalendarView {
    private final int _$1297 = 6;
    private final int _$1300 = 7;
    private JPanel _$1309;
    private JPanel _$1342;
    DatePickerDateLabel[][] datePickerDateLabel;
    DatePickerLabel[] dayHeader;
    public static Font fontDayNames = new Font("Arial", 0, 12);
    public static Font fontDays = new Font("Arial", 0, 12);
    public static int OVAL = 0;
    public static int RECT = 1;
    private int _$2178;
    public static final Color HASFOCUSCOLOR = Color.lightGray;
    public static final Color SELECTEDCOLOR = Color.lightGray;
    private Color _$2247;
    private Color _$2314;
    public JPanel panelMain;

    public MonthView() {
        this(null, null);
    }

    public MonthView(Calendar calendar) {
        this(null, calendar);
    }

    public MonthView(String calendarString) {
        this(null, null);
        this.setDate(calendarString);
    }

    public MonthView(SimpleDateFormat format) {
        this(format, null);
    }

    public MonthView(SimpleDateFormat format, Calendar calendar) {
        super(format);
        this._$1309 = new MonthViewButtons(this.controller, this);
        this._$1342 = new MonthViewStatusPanel(this);
        this.datePickerDateLabel = new DatePickerDateLabel[6][7];
        this._$2178 = 0;
        this._$2247 = HASFOCUSCOLOR;
        this._$2314 = SELECTEDCOLOR;
        this.panelMain = new JPanel();
        try {
            this._$1500();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setDate(calendar);
    }

    private void _$1531() {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.datePickerDateLabel[i][j].clear();
            }
        }
    }

    private void _$1500() throws Exception {
        this.add((Component)this._$1309, "North");
        this.add((Component)this._$1342, "South");
        this.panelMain.setLayout(new GridLayout());
        this.add(this.panelMain);
        this._$1611();
        this.updateView();
        this.setBorder(new EtchedBorder());
        this.panelMain.setBackground(Color.white);
    }

    private void _$1611() {
        int i;
        this.panelMain.setLayout(new GridLayout(0, 7, 0, 0));
        this.dayHeader = new DatePickerLabel[this.getDayPrefix().length];
        Calendar c = this.getController().getCurrentDate();
        for (i = c.getFirstDayOfWeek(); i < this.getDayPrefix().length; ++i) {
            this.dayHeader[i] = new DatePickerLabel(this.getDayPrefix()[i]);
            this.dayHeader[i].setFont(fontDayNames);
            this.dayHeader[i].setBackground(Color.white);
            this.panelMain.add(this.dayHeader[i]);
        }
        for (i = 1; i < c.getFirstDayOfWeek(); ++i) {
            this.dayHeader[i] = new DatePickerLabel(this.getDayPrefix()[i]);
            this.dayHeader[i].setFont(fontDayNames);
            this.dayHeader[i].setBackground(Color.white);
            this.panelMain.add(this.dayHeader[i]);
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.datePickerDateLabel[i][j] = new DatePickerDateLabel(this);
                this.datePickerDateLabel[i][j].setFont(fontDays);
                this.panelMain.add(this.datePickerDateLabel[i][j]);
            }
        }
    }

    public void formatChanged() {
        int i;
        Calendar c = this.getController().getCurrentDate();
        for (i = c.getFirstDayOfWeek(); i < this.getDayPrefix().length; ++i) {
            this.dayHeader[i].setText(this.getDayPrefix()[i]);
        }
        for (i = 1; i < c.getFirstDayOfWeek(); ++i) {
            this.dayHeader[i].setText(this.getDayPrefix()[i]);
        }
        this.updateView();
    }

    public void updateView() {
        Calendar calendar = this.controller.getCurrentDate();
        try {
            this._$1531();
            int dayMin = calendar.getActualMinimum(5);
            int dayMax = calendar.getActualMaximum(5);
            int firstDayOfWeek = calendar.getFirstDayOfWeek();
            int row = 0;
            int col = 0;
            boolean dayOfWeek = true;
            int minusRow = 0;
            Calendar tempCalendar = Calendar.getInstance();
            tempCalendar.set(calendar.get(1), calendar.get(2), 1);
            minusRow = tempCalendar.get(4);
            minusRow = minusRow == 0 ? 0 : 1;
            for (int i = dayMin; i <= dayMax; ++i) {
                tempCalendar = Calendar.getInstance();
                tempCalendar.set(calendar.get(1), calendar.get(2), i);
                tempCalendar.clear(10);
                tempCalendar.clear(12);
                tempCalendar.clear(13);
                row = tempCalendar.get(4) - minusRow;
                col = tempCalendar.get(7) - firstDayOfWeek;
                col = col < 0 ? col + 7 : col;
                this.datePickerDateLabel[row][col].setCalendar(tempCalendar);
            }
            this.panelMain.revalidate();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void showFullDayNames() {
        int i;
        Calendar c = this.getController().getCurrentDate();
        for (i = c.getFirstDayOfWeek(); i < this.getDayNames().length; ++i) {
            this.dayHeader[i].setText(this.getDayNames()[i]);
        }
        for (i = 1; i < c.getFirstDayOfWeek(); ++i) {
            this.dayHeader[i].setText(this.getDayNames()[i]);
        }
        this.repaint();
    }

    public void showPrefix() {
        for (int i = 1; i < this.getDayPrefix().length; ++i) {
            this.dayHeader[i].setText(this.getDayPrefix()[i]);
        }
        this.repaint();
    }

    public void setStatusPanel(JPanel panel) {
        if (panel == null) {
            throw new NullPointerException("Null Status Panel");
        }
        this.remove(this._$1342);
        this._$1342 = panel;
        this.add((Component)this._$1342, "South");
        this.revalidate();
    }

    public MonthViewStatusPanel getStatusPanel() {
        return (MonthViewStatusPanel)this._$1342;
    }

    public void setButtons(JPanel panel) {
        if (panel == null) {
            throw new NullPointerException("Null Button Panel");
        }
        this.remove(this._$1309);
        this._$1309 = panel;
        this.add((Component)this._$1309, "North");
        this.revalidate();
    }

    public MonthViewButtons getButtons() {
        return (MonthViewButtons)this._$1309;
    }

    public void setHighlightType(int type) {
        this._$2178 = type;
        this.repaint();
    }

    public int getHighlightType() {
        return this._$2178;
    }

    public void setFocusColor(Color color) {
        if (color != null) {
            this._$2247 = color;
        }
        this.repaint();
    }

    public Color getHasFocusColor() {
        return this._$2247;
    }

    public void setSelectedColor(Color color) {
        if (color != null) {
            this._$2314 = color;
        }
        this.repaint();
    }

    public Color getSelectedColor() {
        return this._$2314;
    }

    public void setAlpha(float alpha) {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.datePickerDateLabel[i][j].setAlpha(alpha);
            }
        }
        this.repaint();
    }

    public void setDayForeground(Color color) {
        if (color != null) {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 7; ++j) {
                    this.datePickerDateLabel[i][j].setForeground(color);
                }
            }
        }
        this.repaint();
    }

    public void setDayBackground(Color color) {
        if (color != null) {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 7; ++j) {
                    this.datePickerDateLabel[i][j].setBackground(color);
                }
            }
        }
        this.repaint();
    }

    public void setDayBorder(Border border) {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.datePickerDateLabel[i][j].setBorder(border);
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void setDayFont(Font font) {
        if (font != null) {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 7; ++j) {
                    this.datePickerDateLabel[i][j].setFont(font);
                }
            }
        }
        this.repaint();
    }

    public void setDayHeaderForeground(Color color) {
        if (color != null) {
            for (int i = 1; i < this.dayHeader.length; ++i) {
                this.dayHeader[i].setForeground(color);
            }
            this.repaint();
        }
    }

    public void setDayHeaderBackground(Color color) {
        if (color != null) {
            for (int i = 1; i < this.dayHeader.length; ++i) {
                this.dayHeader[i].setBackground(color);
            }
        }
        this.repaint();
    }

    public void setDayHeaderBorder(Border border) {
        for (int i = 1; i < this.dayHeader.length; ++i) {
            this.dayHeader[i].setBorder(border);
        }
        this.repaint();
    }

    public void setDayHeaderFont(Font font) {
        if (font != null) {
            for (int i = 1; i < this.dayHeader.length; ++i) {
                this.dayHeader[i].setFont(font);
            }
        }
        this.repaint();
    }
}

