//
//
//
//
//
//
//
//
//
//
// Microsoft Windows 95/98/NT Version 
//
//Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Tim Little & Chuck Walbourn
//
// espntdrw.cpp
//
// Contains the code for the EschPointDraw class which is a colored point
// in 3-space.  The point is not lit.
//
//

//
//
//                                Includes
//
//

#include "escher.hpp"

//
//
//                                 Data
//
//

extern VngoPointF EschTempVPointF;

//
//
//                                 Code
//
//

//
//  Operations  
//

//Ŀ
// EschPointDraw - draw                                                     
//                                                                          
// Draws the given point using the current drawing context.                 
//
void EschPointDraw::draw()
{
// Setup local pointers to current camera and Van Gogh viewport.
    assertMyth("EschPointDraw::draw needs camera in current context",
               EschCurrent != NULL && EschCurrent->camera != NULL);

    EschCamera *cam=EschCurrent->camera;

    assertMyth("EschPointDraw::draw needs a viewport in current context's camera",
               cam->vport != NULL);

// Setup Context
    EschContext ec(EschCurrent);
    ec.current = this;
    ec.push();

// Transform
    pos.transform(&cam->eye.iorient,(EschPoint*)&EschTempVPointF);

// Light (normal shade value)
    assertMyth("EschPointDraw::draw needs palette in viewport",
               cam->vport->vbuff.pal != 0);

    EschTempVPointF.clr = color;
    EschTempVPointF.shade = float(cam->vport->vbuff.pal->shd_pal->mid_point);

// Draw
    esch_clipdraw_point(ESCH_CDF_CLIP);

// Cleanup
    ec.pop();
}

// End of module - espntdrw.cpp 
